//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Xg[v[wb_
 * @author Junpee
 */

#ifndef STREAM_PLAYER_H_
#define STREAM_PLAYER_H_

#include <Core/Thread/Thread.h>

namespace Lamp{

class SoundBuffer;
class SoundReader;

//------------------------------------------------------------------------------
/**
 * Xg[v[
 */
class StreamPlayer : public Thread{
friend class StreamSound;
friend class StreamSound3D;
protected:
	/**
	 * RXgN^
	 */
	StreamPlayer();

	/**
	 * fXgN^
	 */
	virtual ~StreamPlayer();

	/**
	 * 
	 * @param soundBuffer TEhobt@
	 * @param soundReader TEh[_
	 */
	virtual bool initialize(SoundBuffer* soundBuffer, SoundReader* soundReader);

	/**
	 * Zbg
	 */
	virtual void reset();

	//--------------------------------------------------------------------------
	/**
	 * s
	 * @param thread sĂXbh
	 *
	 * isStopRequested()trueԂꍇ͑₩ɏI
	 */
	virtual void run(Thread* thread);

	/**
	 * Xg[
	 * @param offset 0Ȃobt@OA1Ȃ㔼ɏ
	 * @return true
	 */
	virtual bool writeStream(int offset);

	//--------------------------------------------------------------------------
	// Đʒu
	//--------------------------------------------------------------------------
	/**
	 * Đʒuݒ
	 * @param cursor ĐʒũoCg
	 */
	virtual void setCursor(u_int cursor);

	/**
	 * Đʒu擾
	 * @return ĐʒũoCg
	 */
	virtual u_int getCursor() const{ return cursor_; }

	//--------------------------------------------------------------------------
	// [v
	//--------------------------------------------------------------------------
	/**
	 * [vʒu̐ݒ
	 * @param loopCursor [vʒuoCgŎw
	 */
	virtual void setLoopCursor(u_int loopCursor);

	/**
	 * [vʒu̎擾
	 * @return [vʒũoCg
	 */
	virtual u_int getLoopCursor() const{ return loopCursor_; }

private:
	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	StreamPlayer(const StreamPlayer& copy);

	// Rs[̉B
	void operator =(const StreamPlayer& copy);

	// DirectSoundNotify
	DirectSoundNotify* directSoundNotify_;
	// TEhobt@
	SoundBuffer* soundBuffer_;
	// TEh[_
	SoundReader* soundReader_;
	// Cxg
	static const int eventCount_ = 3;
	// Cxgnh
	HANDLE event_[eventCount_];
	// Đʒu
	u_int cursor_;
	// [vʒu
	u_int loopCursor_;
	// tO
	volatile bool initialized_;
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of STREAM_PLAYER_H_
//------------------------------------------------------------------------------
