//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * TEhLbVwb_
 * @author Junpee
 */

#ifndef SOUND_CACHE_H_
#define SOUND_CACHE_H_

#include <Core/Container/ArrayList.h>
#include <Core/Container/HashMap.h>
#include <Sound/System/Sound.h>

namespace Lamp{

class TextReader;

//------------------------------------------------------------------------------
/**
 * TEhLbV
 *
 * ÓITEhLbVO邽߂̃NXBXg[͉b̂
 * ݔΉBXg[ɑ΂clone()肭悤ɂȂΑΉlB
 * SoundCache.cpprev1.5ɃXg[LbV̎LB
 */
class SoundCache{
public:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param basePath x[XpX
	 * @param extension u.vtgqi : ".wav" ".ogg"j
	 * @param focus tH[JX
	 * @param defaultMaxMixingCount ftHgő~LVO
	 */
	SoundCache(const String& basePath = "", const String& extension = "",
		Sound::Focus focus = Sound::focusNormal,
		int defaultMaxMixingCount = 16);

	/**
	 * fXgN^
	 */
	virtual ~SoundCache();

	//--------------------------------------------------------------------------
	// TEh̃[h
	//--------------------------------------------------------------------------
	/**
	 * ÓITEh̃[h
	 * @param name TEh
	 * @param loop [vȂtrue
	 * @param priority Dx32767`-32768̊ԂŎw
	 * @param maxMixingCount ő~LVOA0ȂftHggp
	 * @return trueԂ
	 */
	virtual bool loadStaticSound(const String& name, bool loop = false,
		int priority = Sound::priorityDefault, int maxMixingCount = 0);

	/**
	 * ÓI3DTEh̃[h
	 * @param name TEh
	 * @param minimumDistance ŏ
	 * @param maximumDistance ő勗
	 * @param loop [vȂtrue
	 * @param priority Dx32767`-32768̊ԂŎw
	 * @param maxMixingCount ő~LVOA0ȂftHggp
	 * @return trueԂ
	 */
	virtual bool loadStaticSound3D(const String& name, bool loop = false,
		int priority = Sound::priorityDefault,
		float minimumDistance = DS3D_DEFAULTMINDISTANCE,
		float maximumDistance = DS3D_DEFAULTMAXDISTANCE,
		int maxMixingCount = 0);

	/**
	 * TEh̃A[h
	 * @param name TEh
	 * @return trueԂ
	 */
	virtual bool unloadSound(const String& name);

	/**
	 * STEh̃A[h
	 */
	virtual void unloadAll();

	//--------------------------------------------------------------------------
	// TEhXg
	//--------------------------------------------------------------------------
	/**
	 * TEhXg̃[h
	 * @param filePath x[XpX̑΃t@CpX
	 * @return true
	 */
	virtual bool loadSoundList(const String& filePath);

	/**
	 * TEhXg̃[h
	 * @param textReader eLXg[_
	 * @return true
	 */
	virtual bool loadSoundList(TextReader* textReader);

	//--------------------------------------------------------------------------
	// TEh̍Đ
	//--------------------------------------------------------------------------
	/**
	 * TEh̍Đ
	 *
	 * [vTEh̏ꍇ͕Ԃl̃|C^ۑĎOstop()ĂłB
	 * [vTEhŖꍇ͕Ԃl̃|C^ւ̃ANZX́AĂяo_
	 * ̂ݍsǍ͎gpȂŉBA[vĂȂTEhɑ΂
	 * ĐI܂ł̃ANZXKvȂ̂ł΁AgetSound(),releaseSound()
	 * gpĂB
	 * @param name O
	 * @param volume {[1.f0.f̊ԂŎw肷
	 * @param frequency g100100000̊ԂŎw肷A0ȂIWig
	 * @return ĐTEhAsȂNULLB
	 */
	virtual Sound* playSound(const String& name, float volume = 1.f,
		int frequency = 0);

	/**
	 * XeITEh̍Đ
	 *
	 * [vTEh̏ꍇ͕Ԃl̃|C^ۑĎOstop()ĂłB
	 * [vTEhŖꍇ͕Ԃl̃|C^ւ̃ANZX́AĂяo_
	 * ̂ݍsǍ͎gpȂŉBA[vĂȂTEhɑ΂
	 * ĐI܂ł̃ANZXKvȂ̂ł΁AgetSound(),releaseSound()
	 * gpĂB
	 * @param name O
	 * @param volume {[1.f0.f̊ԂŎw肷
	 * @param frequency g100100000̊ԂŎw肷A0ȂIWig
	 * @param pan p-1.f()1.f(E)̊ԂŎw肷
	 * @return ĐTEhAsȂNULLB
	 */
	virtual StereoSound* playStereoSound(const String& name, float volume = 1.f,
		int frequency = 0, float pan = 0.f);

	/**
	 * 3DTEh̍Đ
	 *
	 * [vTEh̏ꍇ͕Ԃl̃|C^ۑĎOstop()ĂłB
	 * [vTEhŖꍇ͕Ԃl̃|C^ւ̃ANZX́AĂяo_
	 * ̂ݍsǍ͎gpȂŉBA[vĂȂTEhɑ΂
	 * ĐI܂ł̃ANZXKvȂ̂ł΁AgetSound(),releaseSound()
	 * gpĂB
	 * @param name O
	 * @param volume {[1.f0.f̊ԂŎw肷
	 * @param frequency g100100000̊ԂŎw肷A0ȂIWig
	 * @param position Đʒuw肷
	 * @return ĐTEhAsȂNULLB
	 */
	virtual Sound3D* playSound3D(const String& name, float volume = 1.f,
		int frequency = 0, const Vector3& position = Vector3::zero);

	//--------------------------------------------------------------------------
	// TEh̎擾A
	//--------------------------------------------------------------------------
	/**
	 * TEh̎擾
	 *
	 * TEh̏L𓾂BL𓾂ĂԁATEh͍ėpȂB
	 * gpreleaseSound()ŕԋpKvB
	 * @param name O
	 * @param resetFlag ZbgtO
	 * @return 擾TEhAsȂNULLB
	 */
	virtual Sound* getSound(const String& name,
		Sound::Reset resetFlag = Sound::resetRuntime);

	/**
	 * XeITEh̎擾
	 *
	 * TEh̏L𓾂BL𓾂ĂԁATEh͍ėpȂB
	 * gpreleaseSound()ŕԋpKvB
	 * @param name O
	 * @param resetFlag ZbgtO
	 * @return 擾TEhAsȂNULLB
	 */
	virtual StereoSound* getStereoSound(const String& name,
		Sound::Reset resetFlag = Sound::resetRuntime);

	/**
	 * 3DTEh̎擾
	 *
	 * TEh̏L𓾂BL𓾂ĂԁATEh͍ėpȂB
	 * gpreleaseSound()ŕԋpKvB
	 * @param name O
	 * @param resetFlag ZbgtO
	 * @return 擾TEhAsȂNULLB
	 */
	virtual Sound3D* getSound3D(const String& name,
		Sound::Reset resetFlag = Sound::resetRuntime);

	/**
	 * TEh̉
	 *
	 * getSound()ŏL𓾂TEhB
	 * @param sound TEh
	 */
	virtual void releaseSound(Sound* sound);

	//--------------------------------------------------------------------------
	// ̑
	//--------------------------------------------------------------------------
	/**
	 * STEh̍Đꎞ~
	 */
	virtual void suspendAll();

	/**
	 * STEh̍ĐĊJ
	 */
	virtual void resumeAll();

	//--------------------------------------------------------------------------
	/**
	 * ւ̕ϊ
	 * @return 
	 */
	virtual String toString() const;

protected:
	//--------------------------------------------------------------------------
	/**
	 * LbV쐬
	 * @param name O
	 * @param sound LbV쐬TEh
	 * @param maxMixingCount ő~LVO
	 */
	virtual void createCache(
		const String& name, Sound* sound, int maxMixingCount);

	//--------------------------------------------------------------------------
	// TEhz
	//--------------------------------------------------------------------------
	/**
	 * TEhz
	 */
	class SoundArray{
	public:
		/**
		 * RXgN^
		 * @param sound TEh
		 * @param maxMixingCount ő~LVO
		 */
		SoundArray(Sound* sound, int maxMixingCount);

		/**
		 * fXgN^
		 */
		virtual ~SoundArray();

		/**
		 * t[TEh擾
		 * @return t[TEhANULLԂ
		 */
		Sound* getFreeSound();

		/**
		 * TEh̎擾
		 * @return TEh
		 */
		virtual int getSoundCount() const{ return sounds_.getCount(); }

		/**
		 * TEh̎擾
		 * @param index TEhCfbNX
		 * @return TEh
		 */
		virtual Sound* getSound(int index){ return sounds_[index]; }

		/**
		 * ւ̕ϊ
		 * @return 
		 */
		virtual String toString() const;

	protected:
		/// TEhz
		ArrayList<Sound*> sounds_;
		/// ő~LVO
		int maxMixingCount_;

	};

	//--------------------------------------------------------------------------
	// oϐ
	//--------------------------------------------------------------------------
	/// LbV
	HashMap<String, SoundArray*> cache_;
	/// Xg
	ArrayList<SoundArray*> list_;
	/// x[XpX
	String basePath_;
	/// gq
	String extension_;
	/// tH[JX
	Sound::Focus focus_;
	/// ftHgő~LVO
	int defaultMaxMixingCount_;

private:
	// Rs[RXgN^̉B
	SoundCache(const SoundCache& copy);

	// Rs[̉B
	void operator =(const SoundCache& copy);

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SOUND_CACHE_H_
//------------------------------------------------------------------------------
