//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * TEh}l[Wwb_
 * @author Junpee
 */

#ifndef SOUND_MANAGER_H_
#define SOUND_MANAGER_H_

#include <Core/Container/Deque.h>
#include <Core/InputOutput/FilePath.h>
#include <Sound/System/Sound.h>
#include <Sound/System/SoundDefinition.h>

namespace Lamp{

class SoundReader;

//------------------------------------------------------------------------------
/**
 * TEh}l[W
 */
class SoundManager{
friend class LampSound;
friend class SoundBuffer;
friend class StaticSound;
friend class StaticSound3D;
public:
	//--------------------------------------------------------------------------
	/// 3DTEhASY
	enum Algorithm{
		/// ʏ3DTEhASY
		algorithmNormal,
		/// yHRTF3DTEhASY
		algorithmLightHRTF,
		/// tHRTF3DTEhASY
		algorithmFullHRTF,
	};

	//--------------------------------------------------------------------------
	// TEh
	//--------------------------------------------------------------------------
	/**
	 * TEh̔j
	 * @param sound jTEh
	 */
	virtual void destroy(Sound* sound);

	/**
	 * STEh̔j
	 */
	virtual void destroyAll();

	/**
	 * TEh̎擾
	 * @return TEh
	 */
	virtual int getCount() const{ return sounds_.getCount(); }

	/**
	 * TEh̎擾
	 * @param index TEh̃CfbNX
	 * @return TEh
	 */
	virtual Sound* getSound(int index){ return sounds_[index]; }

	//--------------------------------------------------------------------------
	/**
	 * 3DASY̐ݒ
	 *
	 * ݒɐ3DTEhɑ΂ăASYKp܂B
	 * @param algorithm 3DASY
	 */
	virtual void set3DAlgorithm(Algorithm algorithm){ algorithm_ = algorithm; }

	/**
	 * 3DASY̎擾
	 * @return 3DASY
	 */
	virtual Algorithm get3DAlgorithm() const{ return algorithm_; }

	//--------------------------------------------------------------------------
	// ÓITEh
	//--------------------------------------------------------------------------
	/**
	 * ÓITEh̍쐬
	 * @param size obt@TCY
	 * @param sample Tv
	 * @param channel `l
	 * @param bit rbg
	 * @param focus tH[JX
	 * @return ÓITEh
	 */
	virtual StaticSound* createStaticSound(
		u_int size, int sample, int channel, int bit,
		Sound::Focus focus = (Sound::Focus)SoundDefinition::defaultFocus);

	/**
	 * ÓITEh̍쐬
	 * @param fileName t@C
	 * @param focus tH[JX
	 * @return ÓITEhBsNULLԂB
	 */
	virtual StaticSound* createStaticSound(const String& fileName,
		Sound::Focus focus = (Sound::Focus)SoundDefinition::defaultFocus);

	//--------------------------------------------------------------------------
	// Xg[TEh
	//--------------------------------------------------------------------------
	/**
	 * Xg[TEh̍쐬
	 * @param size obt@TCY
	 * @param sample Tv
	 * @param channel `l
	 * @param bit rbg
	 * @param focus tH[JX
	 * @return Xg[TEh
	 */
	virtual StreamSound* createStreamSound(
		u_int size, int sample, int channel, int bit,
		Sound::Focus focus = (Sound::Focus)SoundDefinition::defaultFocus);

	/**
	 * Xg[TEh̍쐬
	 * @param fileName t@C
	 * @param focus tH[JX
	 * @return Xg[TEhBsNULLԂB
	 */
	virtual StreamSound* createStreamSound(const String& fileName,
		Sound::Focus focus = (Sound::Focus)SoundDefinition::defaultFocus);

	//--------------------------------------------------------------------------
	// ÓI3DTEh
	//--------------------------------------------------------------------------
	/**
	 * ÓI3DTEh̍쐬
	 * @param size obt@TCY
	 * @param sample Tv
	 * @param channel `l
	 * @param bit rbg
	 * @param focus tH[JX
	 * @return ÓI3DTEh
	 */
	virtual StaticSound3D* createStaticSound3D(
		u_int size, int sample, int channel, int bit,
		Sound::Focus focus = (Sound::Focus)SoundDefinition::defaultFocus);

	/**
	 * ÓI3DTEh̍쐬
	 * @param fileName t@C
	 * @param focus tH[JX
	 * @return ÓI3DTEhBsNULLԂB
	 */
	virtual StaticSound3D* createStaticSound3D(const String& fileName,
		Sound::Focus focus = (Sound::Focus)SoundDefinition::defaultFocus);

	//--------------------------------------------------------------------------
	// Xg[3DTEh
	//--------------------------------------------------------------------------
	/**
	 * Xg[3DTEh̍쐬
	 * @param size obt@TCY
	 * @param sample Tv
	 * @param channel `l
	 * @param bit rbg
	 * @param focus tH[JX
	 * @return Xg[3DTEh
	 */
	virtual StreamSound3D* createStreamSound3D(
		u_int size, int sample, int channel, int bit,
		Sound::Focus focus = (Sound::Focus)SoundDefinition::defaultFocus);

	/**
	 * Xg[3DTEh̍쐬
	 * @param fileName t@C
	 * @param focus tH[JX
	 * @return Xg[3DTEhBsNULLԂB
	 */
	virtual StreamSound3D* createStreamSound3D(const String& fileName,
		Sound::Focus focus = (Sound::Focus)SoundDefinition::defaultFocus);

private:
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param directSound DirectSound
	 */
	SoundManager(DirectSound* directSound);

	/**
	 * fXgN^
	 */
	virtual ~SoundManager();

	//--------------------------------------------------------------------------
	// ÓITEh
	//--------------------------------------------------------------------------
	/**
	 * ÓITEh̍쐬
	 * @param soundReader TEh[_
	 * @param name O
	 * @param focus tH[JX
	 * @return ÓITEhBsNULLԂB
	 */
	virtual StaticSound* createStaticSound(
		SoundReader* soundReader, const String& name,
		Sound::Focus focus = (Sound::Focus)SoundDefinition::defaultFocus);

	/**
	 * ÓITEh̕
	 * @param staticSound ÓITEh
	 * @return ÓITEh
	 */
	virtual StaticSound* cloneStaticSound(StaticSound* staticSound);

	//--------------------------------------------------------------------------
	// Xg[TEh
	//--------------------------------------------------------------------------
	/**
	 * Xg[TEh̍쐬
	 * @param soundReader TEh[_AXg[TEhɂdelete܂B
	 * @param name O
	 * @param focus tH[JX
	 * @return Xg[TEhBsNULLԂB
	 */
	virtual StreamSound* createStreamSound(
		SoundReader* soundReader, const String& name,
		Sound::Focus focus = (Sound::Focus)SoundDefinition::defaultFocus);

	//--------------------------------------------------------------------------
	// ÓI3DTEh
	//--------------------------------------------------------------------------
	/**
	 * ÓI3DTEh̍쐬
	 * @param soundReader TEh[_
	 * @param name O
	 * @param focus tH[JX
	 * @return ÓI3DTEhBsNULLԂB
	 */
	virtual StaticSound3D* createStaticSound3D(
		SoundReader* soundReader, const String& name,
		Sound::Focus focus = (Sound::Focus)SoundDefinition::defaultFocus);

	/**
	 * ÓI3DTEh̕
	 * @param staticSound3D ÓI3DTEh
	 * @return ÓI3DTEh
	 */
	virtual StaticSound3D* cloneStaticSound3D(StaticSound3D* staticSound3D);

	//--------------------------------------------------------------------------
	// Xg[3DTEh
	//--------------------------------------------------------------------------
	/**
	 * Xg[3DTEh̍쐬
	 * @param soundReader TEh[_AXg[3DTEhɂdelete܂B
	 * @param name O
	 * @param focus tH[JX
	 * @return Xg[3DTEhBsNULLԂB
	 */
	virtual StreamSound3D* createStreamSound3D(
		SoundReader* soundReader, const String& name,
		Sound::Focus focus = (Sound::Focus)SoundDefinition::defaultFocus);

	//--------------------------------------------------------------------------
	// TEhobt@
	//--------------------------------------------------------------------------
	/**
	 * EF[utH[}bg̍\z
	 * @param waveFormat EF[utH[}bgւ̃|C^
	 * @param samples Tv
	 * @param channels `l
	 * @param bit rbg
	 */
	virtual void buildWaveFormat(
		WAVEFORMATEX* waveFormat, int sample, int channel, int bit);

	/**
	 * obt@Lq̍\z
	 * @param description obt@Lq
	 * @param waveFormat EF[utH[}bgւ̃|C^
	 * @param size obt@TCY
	 * @param focus tH[JX
	 */
	virtual void buildBufferDescription(DSBUFFERDESC* description,
		WAVEFORMATEX* waveFormat, int size, Sound::Focus focus);

	/**
	 * TEhobt@̍\z
	 * @param description obt@Lq
	 * @return TEhobt@
	 */
	virtual DirectSoundBuffer* buildSoundBuffer(DSBUFFERDESC* description);

	/**
	 * TEh[_̍쐬
	 * @param filePath t@CpX
	 * @return TEh[_
	 */
	virtual SoundReader* createSoundReader(const FilePath& filePath);

	/**
	 * TEhobt@̓ǂݍ
	 * @param soundBuffer TEhobt@
	 * @param soundReader TEh[_
	 * @return true
	 */
	virtual bool readSoundBuffer(SoundBuffer* sound, SoundReader* soundReader);

	/**
	 * TEhobt@̕
	 * @param soundBuffer TEhobt@
	 * @return ꂽTEhobt@
	 */
	virtual DirectSoundBuffer* duplicateSoundBuffer(
		DirectSoundBuffer* soundBuffer);

	//--------------------------------------------------------------------------
	// Abvf[g
	//--------------------------------------------------------------------------
	/**
	 * Abvf[g
	 */
	virtual void update();

	/**
	 * Abvf[gTEh̒ǉ
	 * @param sound ǉAbvf[gTEh
	 */
	virtual void addUpdateSound(Sound* sound);

	/**
	 * Abvf[gTEh̍폜
	 * @param sound 폜Abvf[gTEh
	 */
	virtual void removeUpdateSound(Sound* sound);

	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	SoundManager(const SoundManager& copy);

	// Rs[̉B
	void operator =(const SoundManager& copy);

	//--------------------------------------------------------------------------
	// DirectSound
	DirectSound* directSound_;
	// TEhz
	Deque<Sound*> sounds_;
	// Abvf[gTEhz
	Deque<Sound*> updateSounds_;
	// 3DASY
	Algorithm algorithm_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SOUND_MANAGER_H_
//------------------------------------------------------------------------------
