//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * TEh\̓wb_
 * @author Junpee
 */

#ifndef SOUND_CAPACITY_H_
#define SOUND_CAPACITY_H_

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * TEh\
 */
class SoundCapacity{
friend class LampSound;
public:
	//--------------------------------------------------------------------------
	/**
	 * XV
	 * @return true
	 */
	virtual bool refresh();

	//--------------------------------------------------------------------------
	/**
	 * MicrosoftFhCo
	 * @return MicrosoftFhCoȂtrue
	 */
	virtual bool isCertifiedDriver() const{
		return ((capacity_.dwFlags & DSCAPS_CERTIFIED) != 0);
	}

	/**
	 * AIȎgݒT|[gĂ邩
	 * @return AIȎgݒT|[gĂȂtrue
	 */
	virtual bool isSupportedContinuousRate() const{
		return ((capacity_.dwFlags & DSCAPS_CONTINUOUSRATE) != 0);
	}

	/**
	 * G~[ghCo
	 * @return G~[ghCoȂtrue
	 */
	virtual bool isEmulatedDriver() const{
		return ((capacity_.dwFlags & DSCAPS_EMULDRIVER) != 0);
	}

	//--------------------------------------------------------------------------
	/**
	 * 16bitvC}obt@T|[g邩
	 * @return 16bitvC}obt@T|[gȂtrue
	 */
	virtual bool isSupported16bitPrimaryBuffer() const{
		return ((capacity_.dwFlags & DSCAPS_PRIMARY16BIT) != 0);
	}

	/**
	 * 8bitvC}obt@T|[g邩
	 * @return 8bitvC}obt@T|[gȂtrue
	 */
	virtual bool isSupported8bitPrimaryBuffer() const{
		return ((capacity_.dwFlags & DSCAPS_PRIMARY8BIT) != 0);
	}

	/**
	 * mvC}obt@T|[g邩
	 * @return mvC}obt@T|[gȂtrue
	 */
	virtual bool isSupportedMonauralPrimaryBuffer() const{
		return ((capacity_.dwFlags & DSCAPS_PRIMARYMONO) != 0);
	}

	/**
	 * XeIvC}obt@T|[g邩
	 * @return XeIvC}obt@T|[gȂtrue
	 */
	virtual bool isSupportedStereoPrimaryBuffer() const{
		return ((capacity_.dwFlags & DSCAPS_PRIMARYSTEREO) != 0);
	}

	//--------------------------------------------------------------------------
	/**
	 * 16bitZJ_obt@T|[g邩
	 * @return 16bitZJ_obt@T|[gȂtrue
	 */
	virtual bool isSupported16bitSecondaryBuffer() const{
		return ((capacity_.dwFlags & DSCAPS_SECONDARY16BIT) != 0);
	}

	/**
	 * 8bitZJ_obt@T|[g邩
	 * @return 8bitZJ_obt@T|[gȂtrue
	 */
	virtual bool isSupported8bitSecondaryBuffer() const{
		return ((capacity_.dwFlags & DSCAPS_SECONDARY8BIT) != 0);
	}

	/**
	 * mZJ_obt@T|[g邩
	 * @return mZJ_obt@T|[gȂtrue
	 */
	virtual bool isSupportedMonauralSecondaryBuffer() const{
		return ((capacity_.dwFlags & DSCAPS_SECONDARYMONO) != 0);
	}

	/**
	 * XeIZJ_obt@T|[g邩
	 * @return XeIZJ_obt@T|[gȂtrue
	 */
	virtual bool isSupportedStereoSecondaryBuffer() const{
		return ((capacity_.dwFlags & DSCAPS_SECONDARYSTEREO) != 0);
	}

	//--------------------------------------------------------------------------
	/**
	 * ZJ_̍őTvO[g擾
	 * @return ZJ_̍őTvO[g
	 */
	virtual u_int getMaxSecondarySampleRate() const{
		return capacity_.dwMaxSecondarySampleRate;
	}

	/**
	 * ZJ_̍ŏTvO[g擾
	 * @return ZJ_̍ŏTvO[g
	 */
	virtual u_int getMinSecondarySampleRate() const{
		return capacity_.dwMinSecondarySampleRate;
	}

	//--------------------------------------------------------------------------
	/**
	 * ւ̕ϊ
	 * @return 
	 */
	virtual String toString() const;

private:
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	SoundCapacity();

	/**
	 * fXgN^
	 */
	virtual ~SoundCapacity();

	/**
	 * 
	 * @param directSound DirectSound
	 * @return true
	 */
	virtual bool initialize(DirectSound* directSound);

	/**
	 * \̓`FbN
	 * @return \͂true
	 */
	virtual bool checkCapacity();

	// bool擾
	String getBoolString(bool flag) const{
		if(flag){ return ""; }
		else{ return "~"; }
	}

	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	SoundCapacity(const SoundCapacity& copy);

	// Rs[̉B
	void operator =(const SoundCapacity& copy);

	//--------------------------------------------------------------------------
	// DirectSound
	DirectSound* directSound_;
	// \
	DSCAPS capacity_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SOUND_CAPACITY_H_
//------------------------------------------------------------------------------
