//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * TEhobt@wb_
 * @author Junpee
 */

#ifndef SOUND_BUFFER_H_
#define SOUND_BUFFER_H_

#include <Sound/System/Sound.h>
#include <Core/Utility/Timer.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * TEhobt@
 */
class SoundBuffer : public Sound{
friend class StreamPlayer;
public:
	//--------------------------------------------------------------------------
	// {f[^擾
	//--------------------------------------------------------------------------
	/**
	 * O̐ݒ
	 * @param name O
	 */
	virtual void setName(const String& name){ name_ = name; }

	/**
	 * O̎擾
	 * @return O
	 */
	virtual const String& getName() const{ return name_; }

	//--------------------------------------------------------------------------
	/**
	 * TCY̎擾
	 * @return TCY
	 */
	virtual u_int getSize() const{ return size_; }

	/**
	 * Tv̎擾
	 * @return Tv
	 */
	virtual int getSample() const{ return sample_; }

	/**
	 * `l̎擾
	 * @return `l
	 */
	virtual int getChannel() const{ return channel_; }

	/**
	 * rbg̎擾
	 * @return rbg
	 */
	virtual int getBit() const{ return bit_; }

	/**
	 * tH[JX̎擾
	 * @return tH[JX
	 */
	virtual Focus getFocus() const{ return focus_; }

	/**
	 * obt@TCY̎擾
	 * @return obt@TCY
	 */
	virtual u_int getBufferSize() const{ return size_; }

	//--------------------------------------------------------------------------
	// Đ
	//--------------------------------------------------------------------------
	/**
	 * Đ
	 * @return ɍĐtrue
	 */
	virtual bool play();

	/**
	 * ~
	 */
	virtual void stop();

	/**
	 * Đ̈ꎞ~
	 */
	virtual void suspend();

	/**
	 * ĐĊJ
	 * @return ɍĐĊJtrue
	 */
	virtual bool resume();

	/**
	 * Ԃ̎擾
	 */
	virtual State getState() const;

	//--------------------------------------------------------------------------
	// Đʒu
	//--------------------------------------------------------------------------
	/**
	 * Đʒuݒ
	 * @param cursor ĐʒũoCg
	 */
	virtual void setCursor(u_int cursor);

	/**
	 * Đʒu擾
	 * @return ĐʒũoCg
	 */
	virtual u_int getCursor() const;

	//--------------------------------------------------------------------------
	// Dx
	//--------------------------------------------------------------------------
	/**
	 * Dx̐ݒ
	 *
	 * Dx͎ĐɓKp
	 * @param priority Dx32767`-32768̊ԂŎw
	 */
	virtual void setPriority(int priority){
		Assert(priority <= priorityMax);
		Assert(priority >= priorityMin);
		priority_ = priority;
	}

	/**
	 * Dx̎擾
	 * @return 32767`-32768̊Ԃ̒lDx
	 */
	virtual int getPriority() const{ return priority_; }

	//--------------------------------------------------------------------------
	// [v
	//--------------------------------------------------------------------------
	/**
	 * [v̐ݒ
	 *
	 * [v͎ĐɓKp
	 * @param loop [vȂtrue
	 */
	virtual void setLoop(bool loop){ loop_ = loop; }

	/**
	 * [vĂ邩
	 * @return [vĂȂtrue
	 */
	virtual bool isLoop() const{ return loop_; }

	//--------------------------------------------------------------------------
	// {[
	//--------------------------------------------------------------------------
	/**
	 * {[̐ݒ
	 * @param volume {[1.f0.fŐݒ肷
	 */
	virtual void setVolume(float volume);

	/**
	 * {[̎擾
	 * @return {[1.f0.fŕԂ
	 */
	virtual float getVolume() const{ return volume_; }

	//--------------------------------------------------------------------------
	// g
	//--------------------------------------------------------------------------
	/**
	 * g̐ݒ
	 * @param frequency g
	 */
	virtual void setFrequency(int frequency);

	/**
	 * g̎擾
	 * @return g
	 */
	virtual int getFrequency() const{ return frequency_; }

	/**
	 * IWig̐ݒ
	 */
	virtual void setOriginalFrequency();

	//--------------------------------------------------------------------------
	// tF[h
	//--------------------------------------------------------------------------
	/**
	 * tF[hC
	 * @param millisecond tF[hCɂ鎞ԁB0w肷ƃtF[h~B
	 */
	virtual void fadeIn(float millisecond){
		fade(millisecond, 0.f, 1.f);
	}

	/**
	 * tF[hAEg
	 * @param millisecond tF[hAEgɂ鎞ԁB0w肷ƃtF[h~B
	 */
	virtual void fadeOut(float millisecond){
		fade(millisecond, getVolume(), 0.f);
	}

	/**
	 * tF[h
	 * @param millisecond tF[hAEgɂ鎞ԁB0w肷ƃtF[h~B
	 * @param startVolume Jn{[
	 * @param endVolume I{[
	 */
	virtual void fade(float millisecond, float startVolume, float endVolume);

	/**
	 * tF[hǂ
	 * @return tF[hȂtrue
	 */
	virtual bool isFading() const{ return isFading_; }

	//--------------------------------------------------------------------------
	// Rg
	//--------------------------------------------------------------------------
	/**
	 * Rg̐ݒ
	 * @param comment Rg
	 */
	virtual void setComment(const String& comment){ comment_ = comment; }

	/**
	 * Rg̎擾
	 * @return Rg
	 */
	virtual const String& getComment() const{ return comment_; }

	//--------------------------------------------------------------------------
	// ̑
	//--------------------------------------------------------------------------
	/**
	 * L邩
	 * @return LBfalseȂ炷łɒNɏLĂ
	 */
	virtual bool hasOwnership() const{ return ownership_; }

	//--------------------------------------------------------------------------
	// bN
	//--------------------------------------------------------------------------
	/// bN
	class Lock{
	friend class SoundBuffer;
	public:
		/**
		 * AhX0̎擾
		 * @return AhX0
		 */
		void* getAddress0() const{ return address0_; }

		/**
		 * TCY0̎擾
		 * @return TCY0
		 */
		u_int getSize0() const{ return (u_int)size0_; }

		/**
		 * AhX1̎擾
		 * @return AhX1
		 */
		void* getAddress1() const{ return address1_; }

		/**
		 * TCY1̎擾
		 * @return TCY1
		 */
		u_int getSize1() const{ return (u_int)size1_; }

		/**
		 * f[^L
		 * @return f[^LȂtrueԂ
		 */
		bool isValid() const{ return (size0_ != 0); }

	private:
		/// RXgN^
		Lock(){ clear(); }

		/// NA
		void clear(){
			address0_ = address1_ = NULL;
			size0_ = size1_ = 0;
		}

		// AhX0
		void* address0_;
		// TCY0
		u_long size0_;
		// AhX1
		void* address1_;
		// TCY1
		u_long size1_;
	};

	//--------------------------------------------------------------------------
	/**
	 * bN
	 *
	 * obt@ŜbN܂BsꍇALock::isValid()falseԂ܂B
	 * @return bNf[^
	 */
	virtual Lock& lock();

	/**
	 * bN
	 *
	 * sꍇALock::isValid()falseԂ܂B
	 * @param offset ItZbgoCgŎw肷
	 * @param bytes bNoCg
	 * @return bNf[^
	 */
	virtual Lock& lock(u_int offset, u_int bytes);

	/**
	 * AbN
	 */
	virtual void unlock();

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * TEhobt@ǂ
	 * @return TEhobt@Ȃtrue
	 */
	virtual bool isSoundBuffer() const{ return true; }

protected:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param soundBuffer TEhobt@
	 */
	SoundBuffer(DirectSoundBuffer* soundBuffer);

	/**
	 * fXgN^
	 */
	virtual ~SoundBuffer();

	/**
	 * 
	 * @param size TCY
	 * @param sample Tv
	 * @param channel `l
	 * @param bit rbg
	 * @param focus tH[JX
	 */
	virtual void initialize(
		u_int size, int sample, int channel, int bit, Focus focus);

	/**
	 * TEhobt@f[^̃Rs[
	 * @param destination Rs[TEhobt@
	 */
	virtual void copySoundBufferData(SoundBuffer* destination);

	//--------------------------------------------------------------------------
	/**
	 * Abvf[g
	 * @return Abvf[gKvȏItrueԂ
	 */
	virtual bool update();

	//--------------------------------------------------------------------------
	// {f[^擾
	//--------------------------------------------------------------------------
	/**
	 * TEhobt@̎擾
	 * @return TEhobt@
	 */
	DirectSoundBuffer* getSoundBuffer(){ return soundBuffer_; }

	//--------------------------------------------------------------------------
	/**
	 * L̐ݒ
	 * @param ownership LBfalseȂNɏLĂ
	 */
	virtual void setOwnership(bool ownership){ ownership_ = ownership; }

	//--------------------------------------------------------------------------
	// Đ
	//--------------------------------------------------------------------------
	/**
	 * obt@̍Đ
	 * @return true
	 */
	virtual bool playBuffer();

	/**
	 * obt@̒~
	 */
	virtual void stopBuffer();

	/**
	 * ĐtO̎擾
	 * @return ĐtO
	 */
	virtual u_int getPlayFlag() = 0;

	//--------------------------------------------------------------------------
	// g
	//--------------------------------------------------------------------------
	/**
	 * obt@g̎擾
	 * @return obt@g
	 */
	virtual int getBufferFrequency() const;

private:
	// TEhobt@
	DirectSoundBuffer* soundBuffer_;
	// bN
	Lock lock_;
	// O
	String name_;
	// Rg
	String comment_;
	// TCY
	u_int size_;
	// Tv
	int sample_;
	// `l
	int channel_;
	// rbg
	int bit_;
	// tH[JX
	Focus focus_;
	// {[
	float volume_;
	// g
	int frequency_;
	// tF[hJn
	Timer::Tick fadeStartTime_;
	// tF[h
	float fadePeriod_;
	// tF[hJn{[
	float fadeStartVolume_;
	// tF[hI{[
	float fadeEndVolume_;
	// Dx
	int priority_;
	// LtO
	bool ownership_;
	// tF[h
	bool isFading_;
	// [v
	volatile bool loop_;
	// ꎞ~
	volatile bool isSuspended_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SOUND_BUFFER_H_
//------------------------------------------------------------------------------
