//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * TEhwb_
 * @author Junpee
 */

#ifndef SOUND_H_
#define SOUND_H_

namespace Lamp{

class SoundBuffer;
class StereoSound;
class Sound3D;
class StaticSound;
class StreamSound;
class StaticSound3D;
class StreamSound3D;

//------------------------------------------------------------------------------
/**
 * TEh
 *
 * Ԃ̈ڂςB<br>
 * play()<br>
 *  statePlay@@̂܂܍Đ<br>
 *  stateStop@@擪ɖ߂čĐ<br>
 *  stateSuspend ꎞ~ꏊĐ<br>
 *  stateLost@@̂܂܍Đ݂<br>
 * stop()<br>
 *  statePlay@@~<br>
 *  stateStop@@̂܂ܒ~<br>
 *  stateSuspend ~<br>
 *  stateLost@@~<br>
 * suspend()<br>
 *  statePlay@@ꎞ~<br>
 *  stateStop@@̂܂ܒ~<br>
 *  stateSuspend ̂܂܈ꎞ~<br>
 *  stateLost@@ꎞ~݂<br>
 * resume()<br>
 *  statePlay@@̂܂܍Đ݂<br>
 *  stateStop@@̂܂ܒ~<br>
 *  stateSuspend ĐĊJ<br>
 *  stateLost@@ĐĊJ݂<br>
 */
class Sound{
friend class SoundManager;
friend class SoundCache;
public:
	//--------------------------------------------------------------------------
	// Dx
	//--------------------------------------------------------------------------
	/// ftHgDx
	static const int priorityDefault = 0;

	/// ōDx
	static const int priorityMax = Limit::shortMax;

	/// ŒDx
	static const int priorityMin = Limit::shortMin;

	//--------------------------------------------------------------------------
	// Xe[g
	//--------------------------------------------------------------------------
	/// Xe[g
	enum State{
		/// Đ
		statePlay,
		/// ꎞ~
		stateSuspend,
		/// ~
		stateStop,
		/// Xg
		stateLost,
	};

	//--------------------------------------------------------------------------
	// tH[JX
	//--------------------------------------------------------------------------
	/// tH[JX
	enum Focus{
		/// ʏtH[JX
		focusNormal = 0,
		/// XeBL[tH[JX
		focusSticky,
		/// O[otH[JX
		focusGlobal,
	};

	//--------------------------------------------------------------------------
	// Zbg
	//--------------------------------------------------------------------------
	/// ZbgtO
	enum Reset{
		// Sound
		resetName				= (1),
		resetCursor				= (resetName << 1),
		resetPriority			= (resetCursor << 1),
		resetLoop				= (resetPriority << 1),
		resetLoopCursor			= (resetLoop << 1),
		resetVolume				= (resetLoopCursor << 1),
		resetFrequency			= (resetVolume << 1),
		resetFade				= (resetFrequency << 1),
		// StereoSound
		resetPan				= (resetFade << 1),
		// Sound3D
		resetPosition			= (resetPan << 1),
		resetVelocity			= (resetPosition << 1),
		resetDistance			= (resetVelocity << 1),
		resetConeDirection		= (resetDistance << 1),
		resetConeAngle			= (resetConeDirection << 1),
		resetConeOutsideVolume	= (resetConeAngle << 1),
		reset3DEnabled			= (resetConeOutsideVolume << 1),
		// Custom
		resetNone				= (0),
		resetAll				= (0xffffffff),
		resetRuntime			=
			(resetCursor | resetVolume | resetFrequency | resetFade |
			resetPan | resetPosition | resetVelocity | resetConeDirection |
			resetConeAngle | resetConeOutsideVolume | reset3DEnabled),
	};

	//--------------------------------------------------------------------------
	// {f[^擾
	//--------------------------------------------------------------------------
	/**
	 * O̐ݒ
	 * @param name O
	 */
	virtual void setName(const String& name) = 0;

	/**
	 * O̎擾
	 * @return O
	 */
	virtual const String& getName() const = 0;

	//--------------------------------------------------------------------------
	/**
	 * TCY̎擾
	 * @return TCY
	 */
	virtual u_int getSize() const = 0;

	/**
	 * Ԃ̒̎擾
	 * @return bPʂ̎Ԃ̒
	 */
	virtual float getTimeLength() const{ return byteToTime(getSize()); }

	/**
	 * Tv̎擾
	 * @return Tv
	 */
	virtual int getSample() const = 0;

	/**
	 * `l̎擾
	 * @return `l
	 */
	virtual int getChannel() const = 0;

	/**
	 * rbg̎擾
	 * @return rbg
	 */
	virtual int getBit() const = 0;

	/**
	 * tH[JX̎擾
	 * @return tH[JX
	 */
	virtual Focus getFocus() const = 0;

	/**
	 * 1TṽoCg擾
	 * @return 1TṽoCg
	 */
	virtual u_int getOneSampleBytes() const{
		return (getChannel() * getBit() / 8);
	}

	/**
	 * 1b̃oCg擾
	 * @return 1b̃oCg
	 */
	virtual u_int getOneSecondBytes() const{
		return (getSample() * getOneSampleBytes());
	}

	/**
	 * oCg玞Ԃւ̕ϊ
	 * @param byte oCg
	 * @return bPʂ̎
	 */
	virtual float byteToTime(u_int byte) const{
		Assert(byte <= getSize());
		return (float)byte / (float)getOneSecondBytes();
	}

	/**
	 * ԂoCgւ̕ϊ
	 * @return time bPʂ̎
	 * @return oCg
	 */
	virtual u_int timeToByte(float time) const{
		Assert((time >= 0.f) && (time < getTimeLength()));
		return (u_int)(time * getOneSecondBytes());
	}

	//--------------------------------------------------------------------------
	// Đ
	//--------------------------------------------------------------------------
	/**
	 * Đ
	 * @return ɍĐtrue
	 */
	virtual bool play() = 0;

	/**
	 * ~
	 */
	virtual void stop() = 0;

	/**
	 * Đ̈ꎞ~
	 */
	virtual void suspend() = 0;

	/**
	 * ĐĊJ
	 * @return ɍĐĊJtrue
	 */
	virtual bool resume() = 0;

	/**
	 * Zbg
	 * @param flags ZbgtO
	 */
	virtual void reset(Reset flags);

	/**
	 * Ԃ̎擾
	 */
	virtual State getState() const = 0;

	//--------------------------------------------------------------------------
	// Đʒu
	//--------------------------------------------------------------------------
	/**
	 * Đʒuݒ
	 * @param cursor ĐʒũoCg
	 */
	virtual void setCursor(u_int cursor) = 0;

	/**
	 * Đʒu擾
	 * @return ĐʒũoCg
	 */
	virtual u_int getCursor() const = 0;

	//--------------------------------------------------------------------------
	/**
	 * ĐԐݒ
	 * @param timeCursor ĐԂ̕b
	 */
	virtual void setCurrentTime(float timeCursor){
		setCursor(timeToByte(timeCursor));
	}

	/**
	 * ݂̍ĐԎ擾
	 * @return ݂̍ĐԂ̕b
	 */
	virtual float getCurrentTime() const{ return byteToTime(getCursor()); }

	//--------------------------------------------------------------------------
	// Dx
	//--------------------------------------------------------------------------
	/**
	 * Dx̐ݒ
	 *
	 * Dx͎ĐɓKp
	 * @param priority Dx32767`-32768̊ԂŎw
	 */
	virtual void setPriority(int priority) = 0;

	/**
	 * Dx̎擾
	 * @return 32767`-32768̊Ԃ̒lDx
	 */
	virtual int getPriority() const = 0;

	//--------------------------------------------------------------------------
	// [v
	//--------------------------------------------------------------------------
	/**
	 * [v̐ݒ
	 *
	 * [v͎ĐɓKp
	 * @param loop [vȂtrue
	 */
	virtual void setLoop(bool loop) = 0;

	/**
	 * [vĂ邩
	 * @return [vĂȂtrue
	 */
	virtual bool isLoop() const = 0;

	//--------------------------------------------------------------------------
	/**
	 * [vʒu̐ݒ
	 * @param loopCursor [vʒuoCgŎw
	 */
	virtual void setLoopCursor(u_int loopCursor){
		if(loopCursor == 0){ return; }
		Assert(false);
	}

	/**
	 * [vʒu̎擾
	 * @return [vʒũoCg
	 */
	virtual u_int getLoopCursor() const{ return 0; }

	//--------------------------------------------------------------------------
	/**
	 * [vԂ̐ݒ
	 * @param loopTimeCursor [vԂbŎw
	 */
	virtual void setLoopTime(float loopTimeCursor){
		setLoopCursor(timeToByte(loopTimeCursor));
	}

	/**
	 * [vԂ̎擾
	 * @return [vԂ̕b
	 */
	virtual float getLoopTime() const{ return byteToTime(getLoopCursor()); }

	//--------------------------------------------------------------------------
	// {[
	//--------------------------------------------------------------------------
	/**
	 * {[̐ݒ
	 * @param volume {[1.f0.fŐݒ肷
	 */
	virtual void setVolume(float volume) = 0;

	/**
	 * {[̎擾
	 * @return {[1.f0.fŕԂ
	 */
	virtual float getVolume() const = 0;

	//--------------------------------------------------------------------------
	// g
	//--------------------------------------------------------------------------
	/**
	 * g̐ݒ
	 * @param frequency g
	 */
	virtual void setFrequency(int frequency) = 0;

	/**
	 * g̎擾
	 * @return g
	 */
	virtual int getFrequency() const = 0;

	/**
	 * IWig̐ݒ
	 */
	virtual void setOriginalFrequency() = 0;

	//--------------------------------------------------------------------------
	// tF[h
	//--------------------------------------------------------------------------
	/**
	 * tF[hC
	 * @param millisecond tF[hCɂ鎞ԁB0w肷ƃtF[h~B
	 */
	virtual void fadeIn(float millisecond) = 0;

	/**
	 * tF[hAEg
	 * @param millisecond tF[hAEgɂ鎞ԁB0w肷ƃtF[h~B
	 */
	virtual void fadeOut(float millisecond) = 0;

	/**
	 * tF[h
	 * @param millisecond tF[hAEgɂ鎞ԁB0w肷ƃtF[h~B
	 * @param startVolume Jn{[
	 * @param endVolume I{[
	 */
	virtual void fade(
		float millisecond, float startVolume, float endVolume) = 0;

	/**
	 * tF[h̒~
	 */
	virtual void stopFade(){ fade(0.f, 0.f, 0.f); }

	/**
	 * tF[hǂ
	 * @return tF[hȂtrue
	 */
	virtual bool isFading() const = 0;

	//--------------------------------------------------------------------------
	// Rg
	//--------------------------------------------------------------------------
	/**
	 * Rg̐ݒ
	 * @param comment Rg
	 */
	virtual void setComment(const String& comment) = 0;

	/**
	 * Rg̎擾
	 * @return Rg
	 */
	virtual const String& getComment() const = 0;

	/**
	 * RgIvV̓Kp
	 */
	virtual void applyCommentOption();

	//--------------------------------------------------------------------------
	// ̑
	//--------------------------------------------------------------------------
	/**
	 * 
	 * Xg[͕łȂB
	 * @return ꂽTEhBsNULLԂ
	 */
	virtual Sound* clone(){ return NULL; }

	/**
	 * L̎擾
	 * @return LBfalseȂNɏLĂ
	 */
	virtual bool hasOwnership() const = 0;

	/**
	 * ւ̕ϊ
	 * @return 
	 */
	virtual String toString() const;

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * Xg[gpĂ邩
	 * @return Xg[gpĂtrue
	 */
	virtual bool useStream() const{ return false; }

	//--------------------------------------------------------------------------
	/**
	 * TEhobt@ǂ
	 * @return TEhobt@Ȃtrue
	 */
	virtual bool isSoundBuffer() const{ return false; }

	/**
	 * TEhobt@ւ̃LXg
	 * @return TEhobt@B^ႦNULLԂB
	 */
	virtual SoundBuffer* castSoundBuffer() const{
		if(isSoundBuffer()){ return (SoundBuffer*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * XeITEhǂ
	 * @return XeITEhȂtrue
	 */
	virtual bool isStereoSound() const{ return false; }

	/**
	 * XeITEhւ̃LXg
	 * @return XeITEhB^ႦNULLԂB
	 */
	virtual StereoSound* castStereoSound() const{
		if(isStereoSound()){ return (StereoSound*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * 3DTEhǂ
	 * @return 3DTEhȂtrue
	 */
	virtual bool isSound3D() const{ return false; }

	/**
	 * 3DTEhւ̃LXg
	 * @return 3DTEhB^ႦNULLԂB
	 */
	virtual Sound3D* castSound3D() const{
		if(isSound3D()){ return (Sound3D*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * ÓITEhǂ
	 * @return ÓITEhȂtrue
	 */
	virtual bool isStaticSound() const{ return false; }

	/**
	 * ÓITEhւ̃LXg
	 * @return ÓITEhB^ႦNULLԂB
	 */
	virtual StaticSound* castStaticSound() const{
		if(isStaticSound()){ return (StaticSound*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * Xg[TEhǂ
	 * @return Xg[TEhȂtrue
	 */
	virtual bool isStreamSound() const{ return false; }

	/**
	 * Xg[TEhւ̃LXg
	 * @return Xg[TEhB^ႦNULLԂB
	 */
	virtual StreamSound* castStreamSound() const{
		if(isStreamSound()){ return (StreamSound*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * ÓI3DTEhǂ
	 * @return ÓI3DTEhȂtrue
	 */
	virtual bool isStaticSound3D() const{ return false; }

	/**
	 * ÓI3DTEhւ̃LXg
	 * @return ÓI3DTEhB^ႦNULLԂB
	 */
	virtual StaticSound3D* castStaticSound3D() const{
		if(isStaticSound3D()){ return (StaticSound3D*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * Xg[3DTEhǂ
	 * @return Xg[3DTEhȂtrue
	 */
	virtual bool isStreamSound3D() const{ return false; }

	/**
	 * Xg[3DTEhւ̃LXg
	 * @return Xg[3DTEhB^ႦNULLԂB
	 */
	virtual StreamSound3D* castStreamSound3D() const{
		if(isStreamSound3D()){ return (StreamSound3D*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * {[fVxϊ
	 * @param volume {[
	 * @return fVx
	 */
	static int volumeToDecibel(float volume);

	/**
	 * fVx{[ϊ
	 * @param decibel fVx
	 * @return {[
	 */
	static float decibelToVolume(int decibel);

protected:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	Sound();

	/**
	 * fXgN^
	 */
	virtual ~Sound();

	//--------------------------------------------------------------------------
	/**
	 * L̐ݒ
	 * @param ownership LBfalseȂNɏLĂ
	 */
	virtual void setOwnership(bool ownership) = 0;

	/**
	 * Abvf[g
	 * @return Abvf[gKvȏItrueԂ
	 */
	virtual bool update() = 0;

private:
	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	Sound(const Sound& copy);

	// Rs[̉B
	void operator =(const Sound& copy);

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SOUND_H_
//------------------------------------------------------------------------------
