//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * LampTEhwb_
 * @author Junpee
 */

#ifndef LAMP_SOUND_H_
#define LAMP_SOUND_H_

namespace Lamp{

class SoundCapacity;
class SoundManager;
class SoundListener;

//------------------------------------------------------------------------------
/**
 * LampTEh
 *
 * ̃AvP[VĂ鉹ɂe^Ă܂̂ŁAvC}obt@
 * ΂Ẵ{[͍sȂB
 */
class LampSound{
public:
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param windowHandle EBhEnh
	 * @return ɐtrue
	 */
	static bool initialize(HWND windowHandle);

	/**
	 * n
	 */
	static void finalize();

	/**
	 * v[e[V
	 *
	 * `惋[vɌĂłB
	 * tF[h3DTEhp[^Kp܂B
	 */
	static void presentation();

	//--------------------------------------------------------------------------
	/**
	 * Tv̎擾
	 * @return Tv
	 */
	static int getSample(){ Assert(isInitialized_); return sample_; }

	/**
	 * `l̎擾
	 * @return `l
	 */
	static int getChannel(){ Assert(isInitialized_); return channel_; }

	/**
	 * rbg̎擾
	 * @return rbg
	 */
	static int getBit(){ Assert(isInitialized_); return bit_; }

	/**
	 * ւ̕ϊ
	 * @return 
	 */
	static String toString();

	//--------------------------------------------------------------------------
	/**
	 * TEh\͂̎擾
	 * @return TEh\
	 */
	static SoundCapacity* getCapacity(){
		Assert(isInitialized_);
		return soundCapacity_;
	}

	//--------------------------------------------------------------------------
	/**
	 * TEh}l[W̎擾
	 * @return TEh}l[W
	 */
	static SoundManager* getSoundManager(){
		Assert(isInitialized_);
		return soundManager_;
	}

	//--------------------------------------------------------------------------
	/**
	 * TEhXi̎擾
	 * @return TEhXi
	 */
	static SoundListener* getSoundListener(){
		Assert(isInitialized_);
		return soundListener_;
	}

private:
	//--------------------------------------------------------------------------
	// DirectSound
	static DirectSound* directSound_;
	// vC}obt@
	static DirectSoundPrimaryBuffer* primaryBuffer_;
	// TEh\
	static SoundCapacity* soundCapacity_;
	// TEh}l[W
	static SoundManager* soundManager_;
	// TEhXi
	static SoundListener* soundListener_;
	// Tv
	static int sample_;
	// `l
	static int channel_;
	// rbg
	static int bit_;
	// tO
	static bool isInitialized_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of LAMP_SOUND_H_
//------------------------------------------------------------------------------
