//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Xg[TEhwb_
 * @author Junpee
 */

#ifndef STREAM_SOUND_H_
#define STREAM_SOUND_H_

#include <Sound/Stereo/StereoSound.h>
#include <Sound/System/SoundDefinition.h>

namespace Lamp{

class SoundReader;
class StreamPlayer;

//------------------------------------------------------------------------------
/**
 * Xg[TEh
 */
class StreamSound : public StereoSound{
friend class SoundManager;
public:
	//--------------------------------------------------------------------------
	// {f[^擾
	//--------------------------------------------------------------------------
	/**
	 * TEh[_̎擾
	 * @return TEh[_
	 */
	virtual SoundReader* getSoundReader(){ return soundReader_; }

	/**
	 * Xg[v[̎擾
	 * @return Xg[v[
	 */
	virtual StreamPlayer* getStreamPlayer(){ return streamPlayer_; }

	//--------------------------------------------------------------------------
	/**
	 * TCY̎擾
	 * @return TCY
	 */
	virtual u_int getSize() const;

	//--------------------------------------------------------------------------
	// Đ
	//--------------------------------------------------------------------------
	/**
	 * Đ
	 * @return ɍĐtrue
	 */
	virtual bool play(){
		Assert((soundReader_ != NULL) && (streamPlayer_ != NULL));
		return StereoSound::play();
	}

	/**
	 * ~
	 */
	virtual void stop();

	//--------------------------------------------------------------------------
	// Đʒu
	//--------------------------------------------------------------------------
	/**
	 * Đʒuݒ
	 * @param cursor ĐʒũoCg
	 */
	virtual void setCursor(u_int cursor);

	/**
	 * Đʒu擾
	 * @return ĐʒũoCg
	 */
	virtual u_int getCursor() const;

	//--------------------------------------------------------------------------
	// [v
	//--------------------------------------------------------------------------
	/**
	 * [vʒu̐ݒ
	 * @param loopCursor [vʒuoCgŎw
	 */
	virtual void setLoopCursor(u_int loopCursor);

	/**
	 * [vʒu̎擾
	 * @return [vʒũoCg
	 */
	virtual u_int getLoopCursor() const;

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * Xg[gpĂ邩
	 * @return Xg[gpĂtrue
	 */
	virtual bool useStream() const{ return true; }

	/**
	 * Xg[TEhǂ
	 * @return Xg[TEhȂtrue
	 */
	virtual bool isStreamSound() const{ return true; }

protected:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param soundBuffer TEhobt@
	 */
	StreamSound(DirectSoundBuffer* soundBuffer);

	/**
	 * fXgN^
	 */
	virtual ~StreamSound();

	/**
	 * TEh[_̐ݒ
	 * @param soundReader TEh[_AXg[TEhɂdeleteB
	 */
	virtual void setSoundReader(SoundReader* soundReader);

	//--------------------------------------------------------------------------
	/**
	 * ĐtO̎擾
	 * @return ĐtO
	 */
	virtual u_int getPlayFlag(){
		// vCIeBAĐԂɂ铮I{CXǗA[v
		u_int result = (
//			DSBPLAY_TERMINATEBY_PRIORITY | 
//			DSBPLAY_TERMINATEBY_TIME | 
			DSBPLAY_LOOPING);
		return result;
	}

private:
	// TEh[_
	SoundReader* soundReader_;
	// Xg[v[
	StreamPlayer* streamPlayer_;
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of STREAM_SOUND_H_
//------------------------------------------------------------------------------
