//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * XeITEhwb_
 * @author Junpee
 */

#ifndef STEREO_SOUND_H_
#define STEREO_SOUND_H_

#include <Sound/System/SoundBuffer.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * XeITEh
 */
class StereoSound : public SoundBuffer{
friend class SoundManager;
public:
	//--------------------------------------------------------------------------
	/**
	 * p̐ݒ
	 * @param pan p-1.f()1.f(E)̊ԂŎw肷
	 */
	virtual void setPan(float pan);

	/**
	 * p̎擾
	 * @return p
	 */
	virtual float getPan() const{ return pan_; }

	//--------------------------------------------------------------------------
	/**
	 * Zbg
	 * @param flags ZbgtO
	 */
	virtual void reset(Reset flags);

	//--------------------------------------------------------------------------
	/**
	 * ւ̕ϊ
	 * @return 
	 */
	virtual String toString() const;

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * XeITEhǂ
	 * @return XeITEhȂtrue
	 */
	virtual bool isStereoSound() const{ return true; }

protected:
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param soundBuffer TEhobt@
	 */
	StereoSound(DirectSoundBuffer* soundBuffer);

	/**
	 * fXgN^
	 */
	virtual ~StereoSound();

	/**
	 * XeITEhf[^̃Rs[
	 * @param destination Rs[XeITEh
	 */
	virtual void copyStereoSoundData(StereoSound* destination);

private:
	// p
	float pan_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of STEREO_SOUND_H_
//------------------------------------------------------------------------------
