//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Wave[_wb_
 * @author Junpee
 */

#ifndef WAVE_READER_H_
#define WAVE_READER_H_

#include <Sound/Reader/SoundReader.h>
#include <Core/InputOutput/FilePath.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * Wave[_
 */
class WaveReader : public SoundReader{
public:
	/**
	 * RXgN^
	 * @param filePath t@CpX
	 */
	WaveReader(const FilePath& filePath);

	/**
	 * fXgN^
	 */
	virtual ~WaveReader();

	//--------------------------------------------------------------------------
	/**
	 * TCY̎擾
	 * @return TCY
	 */
	virtual u_int getSize() const{
		Assert(initialized_);
		return size_;
	}

	/**
	 * Tv̎擾
	 * @return Tv
	 */
	virtual int getSample() const{
		Assert(initialized_);
		return sample_;
	}

	/**
	 * `l̎擾
	 * @return `l
	 */
	virtual int getChannel() const{
		Assert(initialized_);
		return channel_;
	}

	/**
	 * rbg̎擾
	 * @return rbg
	 */
	virtual int getBit() const{
		Assert(initialized_);
		return bit_;
	}

	/**
	 * Rg̎擾
	 * @return Rg
	 */
	virtual const String& getComment(){
		Assert(initialized_);
		return comment_;
	}

	//--------------------------------------------------------------------------
	/**
	 * ʒu̐ݒ
	 * @param cursor ݒ肷ʒu
	 */
	virtual void setCursor(u_int cursor);

	/**
	 * ʒu̎擾
	 * @return ʒu
	 */
	virtual u_int getCursor(){ return cursor_; }

	//--------------------------------------------------------------------------
	/**
	 * wb_ǂݍ
	 * @return true
	 */
	virtual bool readHeader();

	/**
	 * ǂݍ
	 * @param buffer ǂݍ݃obt@
	 * @param size ǂݍ݃TCY
	 * @return ǂݍ񂾃TCYBI[Ȃ0As-1
	 */
	virtual int read(void* buffer, u_int size);

	//--------------------------------------------------------------------------
	/**
	 * t@CWavet@C
	 * @param filePath t@CpX
	 * @return Wavet@CȂtrue
	 */
	static bool isWaveFileName(const FilePath& filePath){
		return filePath.getExtension().equals("wav");
	}

private:
	// t@CpX
	FilePath filePath_;
	// t@Cnh
	HMMIO handle_;
	// RIFF`N
	MMCKINFO riffChunk_;
	// f[^`N
	MMCKINFO dataChunk_;
	// Rg
	String comment_;
	// f[^ItZbg
	int dataOffset_;
	// ǂݍ݈ʒu
	u_int cursor_;
	// TCY
	u_int size_;
	// Tv
	int sample_;
	// `l
	int channel_;
	// rbg
	int bit_;
	// ς݃tO
	bool initialized_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of WAVE_READER_H_
//------------------------------------------------------------------------------
