//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * TEh[_wb_
 * @author Junpee
 */

#ifndef SOUND_READER_H_
#define SOUND_READER_H_

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * TEh[_
 */
class SoundReader{
public:
	/**
	 * RXgN^
	 */
	SoundReader(){}

	/**
	 * fXgN^
	 */
	virtual ~SoundReader(){}

	//--------------------------------------------------------------------------
	/**
	 * TCY̎擾
	 * @return TCY
	 */
	virtual u_int getSize() const = 0;

	/**
	 * Tv̎擾
	 * @return Tv
	 */
	virtual int getSample() const = 0;

	/**
	 * `l̎擾
	 * @return `l
	 */
	virtual int getChannel() const = 0;

	/**
	 * rbg̎擾
	 * @return rbg
	 */
	virtual int getBit() const = 0;

	/**
	 * Rg̎擾
	 * @return Rg
	 */
	virtual const String& getComment() = 0;

	//--------------------------------------------------------------------------
	/**
	 * ̎擾
	 * @return bPʂ̒
	 */
	virtual float getLength() const{ return byteToTime(getSize()); }

	/**
	 * 1b̃oCg擾
	 * @return 1b̃oCg
	 */
	virtual int getOneSecondBytes() const{
		return (getSample() * (getChannel() * getBit() / 8));
	}

	/**
	 * oCg玞Ԃւ̕ϊ
	 * @param byte oCg
	 * @return bPʂ̎
	 */
	virtual float byteToTime(u_int byte) const{
		Assert(byte < getSize());
		return (float)byte / (float)getOneSecondBytes();
	}

	/**
	 * ԂoCgւ̕ϊ
	 * @return time bPʂ̎
	 * @return oCg
	 */
	virtual u_int timeToByte(float time) const{
		Assert((time >= 0.f) && (time < getLength()));
		return (u_int)(time * getOneSecondBytes());
	}

	//--------------------------------------------------------------------------
	/**
	 * ʒu̐ݒ
	 * @param cursor ݒ肷ʒu
	 */
	virtual void setCursor(u_int cursor) = 0;

	/**
	 * ʒu̎擾
	 * @return ʒu
	 */
	virtual u_int getCursor() = 0;

	//--------------------------------------------------------------------------
	/**
	 * wb_ǂݍ
	 * @return true
	 */
	virtual bool readHeader() = 0;

	/**
	 * ǂݍ
	 * @param buffer ǂݍ݃obt@
	 * @param size ǂݍ݃TCY
	 * @return ǂݍ񂾃TCYBI[Ȃ0As-1
	 */
	virtual int read(void* buffer, u_int size) = 0;

private:
	// Rs[RXgN^̉B
	SoundReader(const SoundReader& copy);

	// Rs[̉B
	void operator =(const SoundReader& copy);

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SOUND_READER_H_
//------------------------------------------------------------------------------

