//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * OggVorbis[_wb_
 * @author Junpee
 */

#ifndef OGG_VORBIS_READER_H_
#define OGG_VORBIS_READER_H_

#include <Sound/Reader/SoundReader.h>
#include <Core/InputOutput/FilePath.h>

namespace Lamp{

// OggVorbis̃wb_OɌȂ悤ɂ
class OggVorbisReaderImpl;

//------------------------------------------------------------------------------
/**
 * OggVorbis[_
 *
 * ov_open_callbacks()gp΃ǂݍ߂BKvȂB
 * t@CseekKvȂ̂œƎpbNt@C𓱓KvB
 */
class OggVorbisReader : public SoundReader{
public:
	/**
	 * RXgN^
	 * @param filePath t@CpX
	 */
	OggVorbisReader(const FilePath& filePath);

	/**
	 * fXgN^
	 */
	virtual ~OggVorbisReader();

	//--------------------------------------------------------------------------
	/**
	 * TCY̎擾
	 * @return TCY
	 */
	virtual u_int getSize() const;

	/**
	 * Tv̎擾
	 * @return Tv
	 */
	virtual int getSample() const;

	/**
	 * `l̎擾
	 * @return `l
	 */
	virtual int getChannel() const;

	/**
	 * rbg̎擾
	 * @return rbg
	 */
	virtual int getBit() const;

	/**
	 * Rg̎擾
	 * @return Rg
	 */
	virtual const String& getComment();

	//--------------------------------------------------------------------------
	/**
	 * ʒu̐ݒ
	 * @param cursor ݒ肷ʒu
	 */
	virtual void setCursor(u_int cursor);

	/**
	 * ʒu̎擾
	 * @return ʒu
	 */
	virtual u_int getCursor();

	//--------------------------------------------------------------------------
	/**
	 * wb_ǂݍ
	 * @return true
	 */
	virtual bool readHeader();

	/**
	 * ǂݍ
	 * @param buffer ǂݍ݃obt@
	 * @param size ǂݍ݃TCY
	 * @return ǂݍ񂾃TCYBI[Ȃ0As-1
	 */
	virtual int read(void* buffer, u_int size);

	//--------------------------------------------------------------------------
	/**
	 * t@COggVorbist@C
	 * @param filePath t@CpX
	 * @return OggVorbist@CȂtrue
	 */
	static bool isOggVorbisFileName(const FilePath& filePath){
		return filePath.getExtension().equals("ogg");
	}

private:
	/**
	 * RXgN^
	 * @param implement 
	 */
//	OggVorbisReader(OggVorbisReaderImpl* implement);

	// NX
	OggVorbisReaderImpl* implement_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of OGG_VORBIS_READER_H_
//------------------------------------------------------------------------------
