//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ÓI3DTEhwb_
 * @author Junpee
 */

#ifndef STATIC_SOUND_3D_H_
#define STATIC_SOUND_3D_H_

#include <Sound/3D/Sound3D.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * ÓI3DTEh
 */
class StaticSound3D : public Sound3D{
friend class SoundManager;
public:
	/**
	 * 
	 * @return ꂽTEhBsNULLԂ
	 */
	virtual Sound* clone();

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * ÓI3DTEhǂ
	 * @return ÓI3DTEhȂtrue
	 */
	virtual bool isStaticSound3D() const{ return true; }

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 * @param soundBuffer TEhobt@
	 */
	StaticSound3D(DirectSoundBuffer* soundBuffer);

	/**
	 * fXgN^
	 */
	virtual ~StaticSound3D();

	/**
	 * ĐtO̎擾
	 * @return ĐtO
	 */
	virtual u_int getPlayFlag(){
		// vCIeBAɂ铮I{CXǗ
		u_int result =
			(DSBPLAY_TERMINATEBY_PRIORITY | DSBPLAY_TERMINATEBY_DISTANCE);
		// [v
		if(isLoop()){ result |= DSBPLAY_LOOPING; }
		return result;
	}

private:

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of STATIC_SOUND_3D_H_
//------------------------------------------------------------------------------
