//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * TEhXiwb_
 * @author Junpee
 */

#ifndef SOUND_LISTENER_H_
#define SOUND_LISTENER_H_

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * TEhXi
 */
class SoundListener{
friend class LampSound;
public:
	//--------------------------------------------------------------------------
	/**
	 * ʒu̐ݒ
	 * @param position ʒu
	 */
	virtual void setPosition(const Vector3& position);

	/**
	 * ʒu̎擾
	 * @return ʒu
	 */
	virtual const Vector3& getPosition() const{ return position_; }

	//--------------------------------------------------------------------------
	/**
	 * x̐ݒ
	 * @param velocity x
	 */
	virtual void setVelocity(const Vector3& velocity);

	/**
	 * x̎擾
	 * @return x
	 */
	virtual const Vector3& getVelocity() const{ return velocity_; }

	//--------------------------------------------------------------------------
	/**
	 * ʒuƑx̐ݒ
	 * @param position ʒu
	 * @param millisecond O񂩂̎Ԃ~bŐݒ
	 */
	virtual void setPositionAndVelocity(
		const Vector3& position, float millisecond);

	//--------------------------------------------------------------------------
	/**
	 * ̐ݒ
	 * @param frontDirection O
	 * @param upDirection 
	 */
	virtual void setDirection(
		const Vector3& frontDirection, const Vector3& upDirection);

	/**
	 * O̎擾
	 * @return O
	 */
	virtual const Vector3& getFrontDirection() const{ return frontDirection_; }

	/**
	 * ̎擾
	 * @return 
	 */
	virtual const Vector3& getUpDirection() const{ return upDirection_; }

	//--------------------------------------------------------------------------
	/**
	 * W̐ݒ
	 *
	 * ftHglSoundDefinitionŒ`Ă܂B
	 * @param distanceFactor W
	 */
	virtual void setDistanceFactor(float distanceFactor);

	/**
	 * W̎擾
	 *
	 * ftHglSoundDefinitionŒ`Ă܂B
	 * @return W
	 */
	virtual float getDistanceFactor() const{ return distanceFactor_; }

	//--------------------------------------------------------------------------
	/**
	 * [ItW̐ݒ
	 * @param rolloffFactor [ItW
	 */
	virtual void setRolloffFactor(float rolloffFactor);

	/**
	 * [ItW̎擾
	 * @return [ItW
	 */
	virtual float getRolloffFactor() const{ return rolloffFactor_; }

	//--------------------------------------------------------------------------
	/**
	 * hbv[W̐ݒ
	 * @param dopplerFactor hbv[W
	 */
	virtual void setDopplerFactor(float dopplerFactor);

	/**
	 * hbv[W̎擾
	 * @return hbv[W
	 */
	virtual float getDopplerFactor() const{ return dopplerFactor_; }

	//--------------------------------------------------------------------------
	/**
	 * ւ̕ϊ
	 * @return 
	 */
	virtual String toString() const;

	//--------------------------------------------------------------------------
	/**
	 * 3Dݒ̓Kp
	 *
	 * ʏLampSound::presentation()Ă΂܂B
	 */
	virtual void apply3DSettings();

private:
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param primaryBuffer vC}obt@
	 */
	SoundListener(DirectSoundPrimaryBuffer* primaryBuffer);

	/**
	 * fXgN^
	 */
	virtual ~SoundListener();

	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	SoundListener(const SoundListener& copy);

	// Rs[̉B
	void operator =(const SoundListener& copy);

	// Xi
	DirectSound3DListener* listener_;
	// ʒu
	Vector3 position_;
	// x
	Vector3 velocity_;
	// O
	Vector3 frontDirection_;
	// 
	Vector3 upDirection_;
	// W
	float distanceFactor_;
	// [ItW
	float rolloffFactor_;
	// hbv[W
	float dopplerFactor_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SOUND_LISTENER_H_
//------------------------------------------------------------------------------
