//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * 3DTEhwb_
 * @author Junpee
 */

#ifndef SOUND_3D_H_
#define SOUND_3D_H_

#include <Sound/System/SoundBuffer.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * 3DTEh
 */
class Sound3D : public SoundBuffer{
public:
	//--------------------------------------------------------------------------
	// Đ
	//--------------------------------------------------------------------------
	/**
	 * Đ
	 * @return ɍĐtrue
	 */
	virtual bool play(){
		apply3DSettings();
		return SoundBuffer::play();
	}

	//--------------------------------------------------------------------------
	// 3Dp[^
	//--------------------------------------------------------------------------
	/**
	 * ʒu̐ݒ
	 * @param position ʒu
	 */
	virtual void setPosition(const Vector3& position);

	/**
	 * ʒu̎擾
	 * @return ʒu
	 */
	virtual const Vector3& getPosition() const{ return position_; }

	/**
	 * x̐ݒ
	 * @param velocity x
	 */
	virtual void setVelocity(const Vector3& velocity);

	/**
	 * x̎擾
	 * @return x
	 */
	virtual const Vector3& getVelocity() const{ return velocity_; }

	/**
	 * ʒuƑx̐ݒ
	 * @param position ʒu
	 * @param millisecond O񂩂̎Ԃ~bŐݒ
	 */
	virtual void setPositionAndVelocity(
		const Vector3& position, float millisecond);

	//--------------------------------------------------------------------------
	/**
	 * ŏ̐ݒ
	 * @param minimumDistance ŏ
	 */
	virtual void setMinimumDistance(float minimumDistance);

	/**
	 * ŏ̎擾
	 * @return ŏ
	 */
	virtual float getMinimumDistance() const{ return minimumDistance_; }

	/**
	 * ő勗̐ݒ
	 * @param maximumDistance ő勗
	 */
	virtual void setMaximumDistance(float maximumDistance);

	/**
	 * ő勗̎擾
	 * @return ő勗
	 */
	virtual float getMaximumDistance() const{ return maximumDistance_; }

	/**
	 * ̐ݒ
	 * @param minimumDistance ŏ
	 * @param maximumDistance ő勗
	 */
	virtual void setDistance(float minimumDistance, float maximumDistance){
		Assert(minimumDistance <= maximumDistance);
		setMinimumDistance(minimumDistance);
		setMaximumDistance(maximumDistance);
	}

	//--------------------------------------------------------------------------
	/**
	 * R[̌̐ݒ
	 * @param coneDirection R[̌
	 */
	virtual void setConeDirection(const Vector3& coneDirection);

	/**
	 * R[̌̎擾
	 * @return R[̌
	 */
	virtual const Vector3& getConeDirection() const{ return coneDirection_; }

	//--------------------------------------------------------------------------
	/**
	 * R[px̐ݒ
	 * @param insideConeAngle R[pxWAŎw
	 * @param outsideConeAngle OR[pxWAŎw
	 */
	virtual void setConeAngle(float insideConeAngle, float outsideConeAngle);

	/**
	 * R[px̎擾
	 * @return WAɂR[px
	 */
	virtual float getInsideConeAngle() const{ return insideConeAngle_; }

	/**
	 * OR[px̎擾
	 * @return WAɂOR[px
	 */
	virtual float getOutsideConeAngle() const{ return outsideConeAngle_; }

	//--------------------------------------------------------------------------
	/**
	 * R[O{[̐ݒ
	 * @param coneOutsideVolume R[O{[0.f1.f̊ԂŎw
	 */
	virtual void setConeOutsideVolume(float coneOutsideVolume);

	/**
	 * R[O{[̎擾
	 * @return R[O{[
	 */
	virtual float getConeOutsideVolume() const{ return coneOutsideVolume_; }

	//--------------------------------------------------------------------------
	/**
	 * 3D̗LAݒ
	 * @param enabled 3DLȂtrue
	 */
	virtual void set3DEnabled(bool enabled);

	/**
	 * 3DL
	 * @return 3DLȂtrue
	 */
	virtual bool is3DEnabled() const{ return is3DEnabled_; }

	//--------------------------------------------------------------------------
	/**
	 * 3Dݒ̓Kp
	 *
	 * ʏLampSound::presentation()Ă΂܂B
	 */
	virtual void apply3DSettings();

	//--------------------------------------------------------------------------
	// ̑
	//--------------------------------------------------------------------------
	/**
	 * Zbg
	 * @param flags ZbgtO
	 */
	virtual void reset(Reset flags);

	//--------------------------------------------------------------------------
	/**
	 * ւ̕ϊ
	 * @return 
	 */
	virtual String toString() const;

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * 3DTEhǂ
	 * @return 3DTEhȂtrue
	 */
	virtual bool isSound3D() const{ return true; }

protected:
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param soundBuffer TEhobt@
	 */
	Sound3D(DirectSoundBuffer* soundBuffer);

	/**
	 * fXgN^
	 */
	virtual ~Sound3D();

	/**
	 * 3DTEhf[^̃Rs[
	 * @param destination Rs[3DTEh
	 */
	virtual void copySound3DData(Sound3D* destination);

private:
	//--------------------------------------------------------------------------
	// 3Dobt@
	DirectSound3DBuffer* sound3DBuffer_;
	// ʒu
	Vector3 position_;
	// x
	Vector3 velocity_;
	// R[̌
	Vector3 coneDirection_;
	// ŏ
	float minimumDistance_;
	// ő勗
	float maximumDistance_;
	// R[px
	float insideConeAngle_;
	// OR[px
	float outsideConeAngle_;
	// R[O{[
	float coneOutsideVolume_;
	// 3DL
	bool is3DEnabled_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SOUND_3D_H_
//------------------------------------------------------------------------------
