//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * v{wb_
 * @author Junpee
 */

#ifndef LAMP_BASIC_H_
#define LAMP_BASIC_H_

//------------------------------------------------------------------------------
// DirectX`
#include <Core/System/DirectXDefinition.h>

// `FbJ
#include <Core/Debug/MemoryChecker.h>

// G[AEg
#include <Core/Debug/ErrorOutput.h>

// fobOAEg
#include <Core/Debug/DebugOutput.h>

// AT[g
#include <Core/Debug/Assert.h>

// ^`
#include <Core/System/Types.h>

// Sȍ폜
#include <Core/System/SafeDelete.h>

// El
#include <Core/System/Limit.h>

// w
#include <Core/System/Math.h>

// 3Dw
#include <Core/System/Math3D.h>

// v~eBu
#include <Core/Primitive/CorePrimitiveAll.h>

// WIgv~eBu
#include <Geometry/Primitive/GeometryPrimitiveAll.h>

// LampRA
#include <Core/System/LampCore.h>

//------------------------------------------------------------------------------
// LampCu̒ǉ
#ifdef _DEBUG
	#pragma comment(lib, "LampDebug.lib")
#else
	#pragma comment(lib, "Lamp.lib")
#endif

//------------------------------------------------------------------------------
// OggVorbisCu̒ǉ
#ifdef _DEBUG
	// fobOɊւ郊J̃[jO肭ԂȂ̂
	// [XłgpB[XŃ}`XbhWCu𖳌ɂB
	#pragma comment(linker, "/nodefaultlib:libcmt.lib")
	#pragma comment(lib, "ogg_static.lib")
	#pragma comment(lib, "vorbis_static.lib")
	#pragma comment(lib, "vorbisfile_static.lib")
#else
	#pragma comment(lib, "ogg_static.lib")
	#pragma comment(lib, "vorbis_static.lib")
	#pragma comment(lib, "vorbisfile_static.lib")
#endif

//------------------------------------------------------------------------------
#endif // End of LAMP_BASIC_H_
//------------------------------------------------------------------------------
