//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Lamp̓wb_
 * @author Junpee
 */

#ifndef LAMP_INPUT_H_
#define LAMP_INPUT_H_

#include <Core/Container/ArrayList.h>

namespace Lamp{

class BufferedInput;
class Keyboard;
class KeyboardDevice;
class Mouse;
class MouseDevice;
class Joystick;
class JoystickDevice;
class BinaryWriter;
class BinaryReader;

//------------------------------------------------------------------------------
/**
 * Lamp
 */
class LampInput{
friend class LampCore;
public:
	/// ̓[h
	enum InputMode{
		modePolling,
		modeBuffering,
	};

	//--------------------------------------------------------------------------
	// An
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param instanceHandle CX^Xnh
	 * @param windowHandle EBhEnh
	 * @param inputMode ̓[h
	 * @return ɐtrue
	 */
	static bool initialize(HINSTANCE instanceHandle, HWND windowHandle,
		InputMode inputMode = modeBuffering);

	/**
	 * n
	 */
	static void finalize();

	/**
	 * NA
	 * ݂̓͂NA܂
	 */
	static void clear();

	/**
	 * obt@NA
	 * obt@ƌ݂̓͂NA܂
	 */
	static void bufferClear();

	//--------------------------------------------------------------------------
	// ̓[h
	//--------------------------------------------------------------------------
	/**
	 * ̓[h̐ݒ
	 * @param inputMode ̓[h
	 */
	static void setInputMode(InputMode inputMode);

	/**
	 * ̓[h̎擾
	 * @return ̓[h
	 */
	static InputMode getInputMode(){ return inputMode_; }

	//--------------------------------------------------------------------------
	// |[O
	//--------------------------------------------------------------------------
	/**
	 * |[O
	 * @return |[Ołtrue
	 */
	static bool polling();

	//--------------------------------------------------------------------------
	// obt@
	//--------------------------------------------------------------------------
	/**
	 * ͂邩
	 * @return ͂true
	 */
	static bool hasMoreInput();

	/**
	 * ͂҂
	 */
	static void waitForInput();

	/**
	 * ̓
	 */
	static void nextInput();

	/**
	 * ͐̎擾
	 * @return ͐
	 */
	static int getInputCount();

	//--------------------------------------------------------------------------
	// O擾
	//--------------------------------------------------------------------------
	/**
	 * O擾̊Jn
	 * @param filePath t@CpX
	 */
	static void startLogging(const String& filePath = "LampInputLog.log");

	/**
	 * O擾̊Jn
	 * @param binaryWriter oCiC^
	 */
	static void startLogging(BinaryWriter* binaryWriter);

	/**
	 * O擾̏I
	 */
	static void endLogging();

	/**
	 * O擾ǂ
	 * @return O擾Ȃtrue
	 */
	static bool isLogging(){ return isLogging_; }

	//--------------------------------------------------------------------------
	// OĐ
	//--------------------------------------------------------------------------
	/**
	 * OĐ̊Jn
	 * @param filePath t@CpX
	 */
	static void playLog(const String& filePath = "LampInputLog.log");

	/**
	 * OĐ̊Jn
	 * @param binaryReader oCi[_
	 */
	static void playLog(BinaryReader* binaryReader);

	/**
	 * OĐ̒~
	 */
	static void stopLog();

	/**
	 * OĐǂ
	 * @return OĐȂtrue
	 */
	static bool isLogPlaying(){ return isLogPlaying_; }

	//--------------------------------------------------------------------------
	// efoCX
	//--------------------------------------------------------------------------
	/**
	 * L[{[h̎擾
	 * @return L[{[h
	 */
	static Keyboard* getKeyboard(){ return keyboard_; }

	/**
	 * L[{[hfoCX̎擾
	 * @return L[{[hfoCX
	 */
	static KeyboardDevice* getKeyboardDevice(){ return keyboardDevice_; }

	//--------------------------------------------------------------------------
	/**
	 * }EX̎擾
	 * @return }EX
	 */
	static Mouse* getMouse(){ return mouse_; }

	/**
	 * }EXfoCX̎擾
	 * @return }EXfoCX
	 */
	static MouseDevice* getMouseDevice(){ return mouseDevice_; }

	//--------------------------------------------------------------------------
	/**
	 * WCXeBbN̎擾
	 * @return WCXeBbN
	 */
	static int getJoystickCount(){ return joysticks_.getCount(); }

	/**
	 * WCXeBbN̎擾
	 * @param index WCXeBbNCfbNX
	 * @return WCXeBbN
	 */
	static Joystick* getJoystick(int index){ return joysticks_[index]; }

	/**
	 * WCXeBbNfoCX̎擾
	 * @return WCXeBbNfoCX
	 */
	static int getJoystickDeviceCount(){ return joystickDevices_.getCount(); }

	/**
	 * WCXeBbNfoCX̎擾
	 * @param index WCXeBbNfoCXCfbNX
	 * @return WCXeBbNfoCX
	 */
	static JoystickDevice* getJoystickDevice(int index){
		return joystickDevices_[index];
	}

	//--------------------------------------------------------------------------
	/**
	 * WCXeBbN̗񋓃R[obN
	 *
	 * [U͂̃\bhĂяoȂŉ
	 * @param instance foCXCX^X
	 * @param userData [Uf[^
	 * @return 񋓌ptO
	 */
	static int __stdcall joystickEnumeration(
		const DIDEVICEINSTANCE* instance, void* userData);

private:
	//--------------------------------------------------------------------------
	/**
	 * EBhEvV[W
	 * @param windowHandle EBhEnh
	 * @param message bZ[W
	 * @param wParam wbZ[Wp[^
	 * @param lParam lbZ[Wp[^
	 * @return bZ[WAȏ̏KvȂ0ȊOԂB
	 */
	static LRESULT windowProcedure(
		HWND windowHandle, u_int message, WPARAM wParam, LPARAM lParam);

	//--------------------------------------------------------------------------
	// foCX|[O
	static bool devicePolling();
	// O|[O
	static void logPolling();
	// Ȍo
	static void writeLog();

	// obt@͏
	static void initializeBufferInput();
	// obt@͌n
	static void finalizeBufferInput();
	// RXgN^̉B
	LampInput();

	// EBhEnh
	static HWND windowHandle_;
	// DirectInput
	static DirectInput* directInput_;
	// ̓[h
	static InputMode inputMode_;
	// obt@
	static BufferedInput* bufferedInput_;

	// OC^
	static BinaryWriter* logWriter_;
	// oCit@CC^
	static BinaryWriter* binaryFileWriter_;
	// O[_
	static BinaryReader* logReader_;
	// oCit@C[_
	static BinaryReader* binaryFileReader_;

	// L[{[h
	static Keyboard* keyboard_;
	// L[{[hfoCX
	static KeyboardDevice* keyboardDevice_;
	// }EX
	static Mouse* mouse_;
	// }EXfoCX
	static MouseDevice* mouseDevice_;
	// WCXeBbN
	static ArrayList<Joystick*> joysticks_;
	// WCXeBbNfoCX
	static ArrayList<JoystickDevice*> joystickDevices_;

	// tO
	static bool isInitialized_;
	// O擾tO
	static bool isLogging_;
	// OĐtO
	static bool isLogPlaying_;
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of LAMP_INPUT_H_
//------------------------------------------------------------------------------
