//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ̓foCXwb_
 * @author Junpee
 */

#ifndef INPUT_DEVICE_H_
#define INPUT_DEVICE_H_

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * ̓foCX
 */
class InputDevice{
public:
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param exclusive r[hȂtrue
	 */
	InputDevice(bool exclusive) : inputDevice_(NULL), windowHandle_(NULL),
		exclusive_(exclusive), foreground_(true), initialized_(false){}

	/**
	 * fXgN^
	 */
	virtual ~InputDevice(){
		SafeRelease(inputDevice_);
	}

	/**
	 * 
	 * @param inputDevice ̓foCX
	 * @param windowHandle EBhEnh
	 * @return true
	 */
	virtual bool initialize(
		DirectInputDevice* inputDevice, HWND windowHandle){
		Assert(inputDevice != NULL);
		inputDevice_ = inputDevice;
		windowHandle_ = windowHandle;
		// foCXCX^X̎擾
		instance_.dwSize = sizeof(DIDEVICEINSTANCE);
		if(DirectXFailed(inputDevice->GetDeviceInfo(&instance_))){
			ErrorOut("InputDevice::initialize() "
				"GetDeviceInfo()Ɏs܂B");
			return false;
		}
		// foCX\͂̎擾
		capabilities_.dwSize = sizeof(DIDEVCAPS);
		if(DirectXFailed(inputDevice->GetCapabilities(&capabilities_))){
			ErrorOut("InputDevice::initialize() "
				"GetCapabilities()Ɏs܂B");
			return false;
		}
		initialized_ = true;
		return true;
	}

	//--------------------------------------------------------------------------
	/**
	 * ANZX̎擾
	 * @return ANZX̎擾ɐtrue
	 */
	virtual bool acquire(){
		Assert(initialized_);
		HRESULT result = inputDevice_->Acquire();
		if(DirectXSucceeded(result)){ return true; }
		if(result != DIERR_OTHERAPPHASPRIO){
			ErrorOut("InputDevice::acquire() Acquire()Ɏs܂B");
		}
		return false;
	}

	/**
	 * ANZX̉
	 */
	virtual void unacquire(){
		Assert(initialized_);
		inputDevice_->Unacquire();
	}

	//--------------------------------------------------------------------------
	/**
	 * |[O
	 * @return |[Ołtrue
	 */
	virtual bool polling(){
		if(isPolled()){ inputDevice_->Poll(); }
		return true;
	}

	//--------------------------------------------------------------------------
	/**
	 * x̐ݒ
	 * @param exclusive r[hȂtrue
	 * @param foreground tHAOEh[hȂtrue
	 * @return true
	 */
	virtual bool setCooperativeLevel(bool exclusive, bool foreground){
		if(inputDevice_ != NULL){
			// tO쐬
			u_int flag = DISCL_NOWINKEY;
			if(exclusive){ flag |= DISCL_EXCLUSIVE; }
			else{ flag |= DISCL_NONEXCLUSIVE; }
			if(foreground){ flag |= DISCL_FOREGROUND; }
			else{ flag |= DISCL_BACKGROUND; }
			unacquire();
			if(DirectXFailed(inputDevice_->SetCooperativeLevel(
				windowHandle_,flag))){
				ErrorOut("InputDevice::setCooperativeLevel() "
					"SetCooperativeLevel()Ɏs܂B");
				return false;
			}
			acquire();
		}
		exclusive_ = exclusive;
		foreground_ = foreground;
		return true;
	}

	/**
	 * r[h
	 * @return r[hȂtrue
	 */
	virtual bool isExclusive() const{ return exclusive_; }

	/**
	 * tHAOEh[h
	 * @return tHAOEh[hȂtrueAobNOEh[hȂfalse
	 */
	virtual bool isForeground() const{ return foreground_; }

	//--------------------------------------------------------------------------
	/**
	 * v_Ng̎擾
	 * @return v_Ng
	 */
	virtual String getProductName() const{
		return String(instance_.tszProductName);
	}

	/**
	 * CX^X̎擾
	 * @return CX^X
	 */
	virtual String getInstanceName() const{
		return String(instance_.tszInstanceName);
	}

	/**
	 * ̎擾
	 * @return 
	 */
	virtual int getAxisCount() const{ return capabilities_.dwAxes; }

	/**
	 * {^̎擾
	 * @return {^
	 */
	virtual int getButtonCount() const{ return capabilities_.dwButtons; }

	/**
	 * _Rg[̎擾
	 * @return _Rg[
	 */
	virtual int getPOVCount() const{ return capabilities_.dwPOVs; }

	/**
	 * foCXA^b`Ă邩
	 * @return foCXA^b`Ătrue
	 */
	virtual bool isAttached() const{
		return ((capabilities_.dwFlags & DIDC_ATTACHED) != 0);
	}

	/**
	 * |[OKv
	 * @return |[OKvȂtrue
	 */
	virtual bool isPolled() const{
		return ((capabilities_.dwFlags & DIDC_POLLEDDATAFORMAT) != 0);
	}

	//--------------------------------------------------------------------------
	/**
	 * ւ̕ϊ
	 * @return 
	 */
	virtual String toString() const{ return getInputDeviceString(); }

	/**
	 * ̓foCX̎擾
	 * @return ̓foCX
	 */
	virtual String getInputDeviceString() const{
		Assert(initialized_);
		String result;
		result.format("ProductName = %s\nInstanceName = %s\n"
			" = %d  {^ = %d  _Rg[ = %d\n"
			"A^b` = %d  |[O = %d\n",
			getProductName().getBytes(), getInstanceName().getBytes(),
			getAxisCount(), getButtonCount(), getPOVCount(),
			isAttached(), isPolled());
		return result;
	}

	//--------------------------------------------------------------------------
protected:
	/**
	 * r[h̐ݒ
	 * @param exclusive r[hȂtrue
	 */
	virtual void setExclusive(bool exclusive){ exclusive_ = exclusive; }

	/**
	 * tHAOEh[h̐ݒ
	 * @param foreground tHAOEh[hȂtrue
	 * obNOEh[hȂfalse
	 */
	virtual void setForeground(bool foreground){ foreground_ = foreground; }

	/// ̓foCX
	DirectInputDevice* inputDevice_;
	/// EBhEnh
	HWND windowHandle_;

	//--------------------------------------------------------------------------
private:
	// Rs[RXgN^̉B
	InputDevice(const InputDevice& copy);

	// Rs[̉B
	void operator =(const InputDevice& copy);

	/// foCX̃CX^X
	DIDEVICEINSTANCE instance_;
	/// foCX̔\
	DIDEVCAPS capabilities_;
	/// r[htO
	bool exclusive_;
	/// tHAOEh[htO
	bool foreground_;
	/// tO
	bool initialized_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of INPUT_DEVICE_H_
//------------------------------------------------------------------------------
