//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * obt@̓wb_
 * @author Junpee
 */

#ifndef BUFFERED_INPUT_H_
#define BUFFERED_INPUT_H_

#include <Core/Thread/Thread.h>
#include <Core/Utility/FPSController.h>
#include <Core/Container/Deque.h>
#include <Core/Container/ArrayList.h>
#include <Input/Keyboard/KeyboardState.h>
#include <Input/Mouse/MouseState.h>
#include <Input/Joystick/JoystickState.h>

namespace Lamp{

class Keyboard;
class KeyboardDevice;
class Mouse;
class MouseDevice;
class Joystick;
class JoystickDevice;
class BinaryWriter;
class BinaryReader;

//------------------------------------------------------------------------------
/**
 * obt@
 */
class BufferedInput : public Thread{
friend class LampInput;
public:
	/// 60FPS
	static const float interval60FPS;
	/// 30FPS
	static const float interval30FPS;

	//--------------------------------------------------------------------------
	/**
	 * ڕWԊԊu̐ݒ
	 * @param targetInterval ڕWԊԊu~bŎw
	 */
	virtual void setTargetInterval(float targetInterval);

	/**
	 * ڕWԊԊu̎擾
	 * @return ڕWԊԊu~bŎ擾
	 */
	virtual float getTargetInterval();

	//--------------------------------------------------------------------------
	/**
	 * s
	 * @param thread sĂXbh
	 *
	 * [U͌ĂяoȂŉ
	 */
	virtual void run(Thread* thread);

private:
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	BufferedInput();

	/**
	 * fXgN^
	 */
	virtual ~BufferedInput();

	//--------------------------------------------------------------------------
	/**
	 * L[{[h̐ݒ
	 * @param keyboard L[{[h
	 * @param keyboardDevice L[{[hfoCX
	 */
	virtual void setKeyboard(
		Keyboard* keyboard, KeyboardDevice* keyboardDevice){
		keyboard_ = keyboard;
		keyboardDevice_ = keyboardDevice;
		Assert((keyboard_ != NULL) && (keyboardDevice_ != NULL));
	}

	/**
	 * }EX̐ݒ
	 * @param mouse }EX
	 * @param mouseDevice }EXfoCX
	 */
	virtual void setMouse(Mouse* mouse, MouseDevice* mouseDevice){
		mouse_ = mouse;
		mouseDevice_ = mouseDevice;
		Assert((mouse_ != NULL) && (mouseDevice_ != NULL));
	}

	/**
	 * WCXeBbN̒ǉ
	 * @param joystick WCXeBbN
	 * @param joystickDevice WCXeBbNfoCX
	 */
	virtual void addJoystick(
		Joystick* joystick, JoystickDevice* joystickDevice){
		Assert((joystick != NULL) && (joystickDevice != NULL));
		joysticks_.add(joystick);
		joystickDevices_.add(joystickDevice);
	}

	//--------------------------------------------------------------------------
	/**
	 * ͂邩
	 * @return ͂true
	 */
	virtual bool hasMoreInput();

	/**
	 * ̓
	 */
	virtual void nextInput();

	/**
	 * ͐̎擾
	 * @return ͐
	 */
	virtual int getInputCount();

	//--------------------------------------------------------------------------
	// O擾
	//--------------------------------------------------------------------------
	/**
	 * O擾̊Jn
	 * @param binaryWriter oCiC^
	 */
	virtual void startLogging(BinaryWriter* binaryWriter);

	/**
	 * O擾̏I
	 */
	virtual void endLogging();

	//--------------------------------------------------------------------------
	// OĐ
	//--------------------------------------------------------------------------
	/**
	 * OĐ̊Jn
	 * @param binaryReader oCi[_
	 */
	virtual void playLog(BinaryReader* binaryReader);

	/**
	 * OĐ̒~
	 */
	virtual void stopLog();

	//--------------------------------------------------------------------------
	// foCX|[O
	virtual void devicePolling();

	// foCXAbvf[g
	virtual void deviceUpdate();

	// OAbvf[g
	virtual void logUpdate();

	// Ȍo
	virtual void writeLog();

	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	BufferedInput(const BufferedInput& copy);

	// Rs[̉B
	void operator =(const BufferedInput& copy);

	// FPSRg[
	FPSController fpsController_;
	// OC^
	BinaryWriter* logWriter_;
	// O[_
	BinaryReader* logReader_;

	// L[{[h
	Keyboard* keyboard_;
	// L[{[hfoCX
	KeyboardDevice* keyboardDevice_;
	// L[{[hXe[g
	Deque<KeyboardState> keyboardStates_;

	// }EX
	Mouse* mouse_;
	// }EXfoCX
	MouseDevice* mouseDevice_;
	// }EXXe[g
	Deque<MouseState> mouseStates_;

	// WCXeBbN
	ArrayList<Joystick*> joysticks_;
	// WCXeBbNfoCX
	ArrayList<JoystickDevice*> joystickDevices_;
	// WCXeBbNXe[g
	Deque<JoystickState> joystickStates_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of BUFFERED_INPUT_H_
//------------------------------------------------------------------------------
