//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * SF݊pbhwb_
 * @author Junpee
 */

#ifndef SF_PAD_H_
#define SF_PAD_H_

#include <Input/Pad/Pad.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * SF݊pbh
 */
class SFPad : public Pad{
public:
	/**
	 * ݊`FbN
	 * @param joystick ݊`FbNWCXeBbN
	 * @return ݊trueԂ
	 */
	static bool checkCompatibility(Joystick* joystick);

	/// {^
	enum Button{
		button0 = 0,
		button1,
		button2,
		button3,
		buttonL,
		buttonR,
		buttonStart,
		buttonSelect,
		maxButtonCount,
		buttonUnknown = -1,
		buttonA = 0,
		buttonB = 1,
		buttonX = 2,
		buttonY = 3,
	};

	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param joystick gpWCXeBbN
	 */
	SFPad(Joystick* joystick);

	/**
	 * fXgN^
	 */
	virtual ~SFPad();

	//--------------------------------------------------------------------------
	// {^}bv
	//--------------------------------------------------------------------------
	/**
	 * {^}bv̕ύX
	 * @param button {^}bvύX{^
	 * @param id ύX{^ID
	 */
	virtual void changeButtonMap(Button button, int id);

	/**
	 * {^}bv̎擾
	 * @param button {^}bv擾{^
	 * @return {^ID
	 */
	virtual int getButtonMap(const Button button){
		Assert((button >= 0) && (button < maxButtonCount));
		return buttonMap_[button];
	}

	//--------------------------------------------------------------------------
	// fW^E
	//--------------------------------------------------------------------------
	/**
	 * fW^E̐ݒ
	 * @param digitalBoundary fW^E
	 */
	virtual void setDigitalBoundary(float digitalBoundary){
		Assert((digitalBoundary > 0.f) && (digitalBoundary <= 1.f));
		digitalBoundary_ = digitalBoundary;
	}

	/**
	 * fW^E̎擾
	 * @return fW^E
	 */
	virtual float setDigitalBoundary() const{ return digitalBoundary_; }

	//--------------------------------------------------------------------------
	// f[^̎擾
	//--------------------------------------------------------------------------
	/**
	 * X̎擾
	 * @return 1-1̒lƂX
	 */
	virtual float getXAxis() const;

	/**
	 * Y̎擾
	 * @return 1-1̒lƂY
	 */
	virtual float getYAxis() const;

	//--------------------------------------------------------------------------
	// \L[f[^̎擾
	//--------------------------------------------------------------------------
	/**
	 * L[Ă邩
	 * @return L[Ătrue
	 */
	virtual bool upKeyPressed() const;

	/**
	 * L[
	 * @return L[Ȃtrue
	 */
	virtual bool upKeyDown() const;

	/**
	 * L[オ
	 * @return L[オȂtrue
	 */
	virtual bool upKeyUp() const;

	//--------------------------------------------------------------------------
	/**
	 * L[Ă邩
	 * @return L[Ătrue
	 */
	virtual bool downKeyPressed() const;

	/**
	 * L[
	 * @return L[Ȃtrue
	 */
	virtual bool downKeyDown() const;

	/**
	 * L[オ
	 * @return L[オȂtrue
	 */
	virtual bool downKeyUp() const;

	//--------------------------------------------------------------------------
	/**
	 * L[Ă邩
	 * @return L[Ătrue
	 */
	virtual bool leftKeyPressed() const;

	/**
	 * L[
	 * @return L[Ȃtrue
	 */
	virtual bool leftKeyDown() const;

	/**
	 * L[オ
	 * @return L[オȂtrue
	 */
	virtual bool leftKeyUp() const;

	//--------------------------------------------------------------------------
	/**
	 * EL[Ă邩
	 * @return EL[Ătrue
	 */
	virtual bool rightKeyPressed() const;

	/**
	 * EL[
	 * @return EL[Ȃtrue
	 */
	virtual bool rightKeyDown() const;

	/**
	 * EL[オ
	 * @return EL[オȂtrue
	 */
	virtual bool rightKeyUp() const;

	//--------------------------------------------------------------------------
	// {^f[^̎擾
	//--------------------------------------------------------------------------
	/**
	 * {^Ă邩
	 * @param button {^
	 * @return {^Ătrue
	 */
	virtual bool buttonPressed(Button button) const;

	/**
	 * {^
	 * @param button {^
	 * @return {^Ȃtrue
	 */
	virtual bool buttonDown(Button button) const;

	/**
	 * {^オ
	 * @param button {^
	 * @return {^オȂtrue
	 */
	virtual bool buttonUp(Button button) const;

	//--------------------------------------------------------------------------
	// f[^擾
	//--------------------------------------------------------------------------
	/**
	 * {^̎擾
	 * @param button {^
	 * @return {^
	 */
	static String getButtonString(Button button);

	/**
	 * ւ̕ϊ
	 * @return 
	 */
	virtual String toString() const;

protected:
	//--------------------------------------------------------------------------
	/**
	 * YlL[ւ̕ϊ
	 * @param yAxis Yl
	 * @return L[Ătrue
	 */
	inline bool yAxisToUpKey(float yAxis) const{
		return (yAxis < (-digitalBoundary_));
	}

	/**
	 * Yl牺L[ւ̕ϊ
	 * @param yAxis Yl
	 * @return L[Ătrue
	 */
	inline bool yAxisToDownKey(float yAxis) const{
		return (yAxis > digitalBoundary_);
	}

	/**
	 * Xl獶L[ւ̕ϊ
	 * @param xAxis Xl
	 * @return L[Ătrue
	 */
	inline bool xAxisToLeftKey(float xAxis) const{
		return (xAxis < (-digitalBoundary_));
	}

	/**
	 * XlEL[ւ̕ϊ
	 * @param xAxis Xl
	 * @return EL[Ătrue
	 */
	inline bool xAxisToRightKey(float xAxis) const{
		return (xAxis > digitalBoundary_);
	}

	/// {^}bv
	int buttonMap_[maxButtonCount];
	/// fW^E
	float digitalBoundary_;

private:

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SF_PAD_H_
//------------------------------------------------------------------------------
