//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * pbhwb_
 * @author Junpee
 */

#ifndef PAD_H_
#define PAD_H_

namespace Lamp{

class Joystick;

//------------------------------------------------------------------------------
/**
 * pbh
 */
class Pad{
public:
	/**
	 * RXgN^
	 * @param joystick gpWCXeBbN
	 */
	Pad(Joystick* joystick);

	/**
	 * fXgN^
	 */
	virtual ~Pad();

	//--------------------------------------------------------------------------
	/**
	 * WCXeBbN̎擾
	 * @return WCXeBbN
	 */
	virtual Joystick* getJoystick(){ return joystick_; }

	/**
	 * O̎擾
	 * @return O
	 */
	virtual String getName() const;

	/**
	 * A^b`Ă邩
	 * @return A^b`Ătrue
	 */
	virtual bool isAttached() const;

	/**
	 * NA
	 */
	virtual void clear();

	//--------------------------------------------------------------------------
	/**
	 * x̐ݒ
	 * @param exclusive r[hȂtrue
	 * @param foreground tHAOEh[hȂtrue
	 * @return true
	 */
	virtual bool setCooperativeLevel(bool exclusive, bool foreground);

	/**
	 * r[h
	 * @return r[hȂtrue
	 */
	virtual bool isExclusive() const;

	/**
	 * tHAOEh[h
	 * @return tHAOEh[hȂtrueAobNOEh[hȂfalse
	 */
	virtual bool isForeground() const;

	//--------------------------------------------------------------------------
	/**
	 * ւ̕ϊ
	 * @return 
	 */
	virtual String toString() const;

protected:
	//--------------------------------------------------------------------------
	/// WCXeBbN
	Joystick* joystick_;

private:
	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	Pad(const Pad& copy);

	// Rs[̉B
	void operator =(const Pad& copy);

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of PAD_H_
//------------------------------------------------------------------------------
