//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * PS2݊pbhwb_
 * @author Junpee
 */

#ifndef PS2_PAD_H_
#define PS2_PAD_H_

#include <Input/Pad/Pad.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * PS2݊pbh
 *
 * ELECOMALOASPS2Rg[ϊP[ugpꍇɑΉĂB
 * FFXI݊搂ĂUSBpbh̓{^тĂ͗lB
 * SmartJoypadɂΉAZAZ]̈tɂȂA\L[{^ŔFĂB
 */
class PS2Pad : public Pad{
public:
	/**
	 * ݊`FbN
	 * @param joystick ݊`FbNWCXeBbN
	 * @return ݊trueԂ
	 */
	static bool checkCompatibility(Joystick* joystick);

	/// {^
	enum Button{
		button0 = 0,
		button1,
		button2,
		button3,
		buttonL2,
		buttonR2,
		buttonL1,
		buttonR1,
		buttonStart,
		buttonSelect,
		buttonL3,
		buttonR3,
		buttonPOVUp,
		buttonPOVRight,
		buttonPOVDown,
		buttonPOVLeft,
		maxButtonCount,
		buttonUnknown = -1,
		buttonSankaku = 0,
		buttonMaru = 1,
		buttonBatu = 2,
		buttonSikaku = 3,
	};

	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param joystick gpWCXeBbN
	 */
	PS2Pad(Joystick* joystick);

	/**
	 * fXgN^
	 */
	virtual ~PS2Pad();

	//--------------------------------------------------------------------------
	// {^}bv
	//--------------------------------------------------------------------------
	/**
	 * {^}bv̕ύX
	 * @param button {^}bvύX{^
	 * @param id ύX{^ID
	 */
	virtual void changeButtonMap(Button button, int id);

	/**
	 * {^}bv̎擾
	 * @param button {^}bv擾{^
	 * @return {^ID
	 */
	virtual int getButtonMap(const Button button){
		Assert((button >= 0) && (button < maxButtonCount));
		return buttonMap_[button];
	}

	//--------------------------------------------------------------------------
	// f[^̎擾
	//--------------------------------------------------------------------------
	/**
	 * ̎擾
	 * @return 
	 */
	virtual Point2f getLeftAxis() const{
		return Point2f(getLeftXAxis(), getLeftYAxis());
	}

	/**
	 * X̎擾
	 * @return X
	 */
	virtual float getLeftXAxis() const;

	/**
	 * Y̎擾
	 * @return Y
	 */
	virtual float getLeftYAxis() const;

	//--------------------------------------------------------------------------
	/**
	 * E̎擾
	 * @return E
	 */
	virtual Point2f getRightAxis() const{
		return Point2f(getRightXAxis(), getRightYAxis());
	}

	/**
	 * EX̎擾
	 * @return EX
	 */
	virtual float getRightXAxis() const;

	/**
	 * EY̎擾
	 * @return EY
	 */
	virtual float getRightYAxis() const;

	//--------------------------------------------------------------------------
	// \L[f[^̎擾
	//--------------------------------------------------------------------------
	/**
	 * L[Ă邩
	 * @return L[Ătrue
	 */
	virtual bool upKeyPressed() const;

	/**
	 * L[
	 * @return L[Ȃtrue
	 */
	virtual bool upKeyDown() const;

	/**
	 * L[オ
	 * @return L[オȂtrue
	 */
	virtual bool upKeyUp() const;

	//--------------------------------------------------------------------------
	/**
	 * L[Ă邩
	 * @return L[Ătrue
	 */
	virtual bool downKeyPressed() const;

	/**
	 * L[
	 * @return L[Ȃtrue
	 */
	virtual bool downKeyDown() const;

	/**
	 * L[オ
	 * @return L[オȂtrue
	 */
	virtual bool downKeyUp() const;

	//--------------------------------------------------------------------------
	/**
	 * L[Ă邩
	 * @return L[Ătrue
	 */
	virtual bool leftKeyPressed() const;

	/**
	 * L[
	 * @return L[Ȃtrue
	 */
	virtual bool leftKeyDown() const;

	/**
	 * L[オ
	 * @return L[オȂtrue
	 */
	virtual bool leftKeyUp() const;

	//--------------------------------------------------------------------------
	/**
	 * EL[Ă邩
	 * @return EL[Ătrue
	 */
	virtual bool rightKeyPressed() const;

	/**
	 * EL[
	 * @return EL[Ȃtrue
	 */
	virtual bool rightKeyDown() const;

	/**
	 * EL[オ
	 * @return EL[オȂtrue
	 */
	virtual bool rightKeyUp() const;

	//--------------------------------------------------------------------------
	// {^f[^̎擾
	//--------------------------------------------------------------------------
	/**
	 * {^Ă邩
	 * @param button {^
	 * @return {^Ătrue
	 */
	virtual bool buttonPressed(Button button) const;

	/**
	 * {^
	 * @param button {^
	 * @return {^Ȃtrue
	 */
	virtual bool buttonDown(Button button) const;

	/**
	 * {^オ
	 * @param button {^
	 * @return {^オȂtrue
	 */
	virtual bool buttonUp(Button button) const;

	//--------------------------------------------------------------------------
	// f[^擾
	//--------------------------------------------------------------------------
	/**
	 * {^̎擾
	 * @param button {^
	 * @return {^
	 */
	static String getButtonString(Button button);

	/**
	 * ւ̕ϊ
	 * @return 
	 */
	virtual String toString() const;

protected:
	//--------------------------------------------------------------------------
	/**
	 * _Rg[lL[ւ̕ϊ
	 * @param pov _Rg[l
	 * @return L[Ătrue
	 */
	inline bool povToUpKey(int pov) const{
		if(((pov & 0xffff) == 0xffff)){ return false; }
		return ((pov >= (deg45 * 7)) && (pov <= (deg45 * 8))) ||
			((pov >= 0) && (pov <= deg45));
	}

	/**
	 * _Rg[l牺L[ւ̕ϊ
	 * @param pov _Rg[l
	 * @return L[Ătrue
	 */
	inline bool povToDownKey(int pov) const{
		if(((pov & 0xffff) == 0xffff)){ return false; }
		return ((pov >= (deg45 * 3)) && (pov <= (deg45 * 5)));
	}

	/**
	 * _Rg[l獶L[ւ̕ϊ
	 * @param pov _Rg[l
	 * @return L[Ătrue
	 */
	inline bool povToLeftKey(int pov) const{
		if(((pov & 0xffff) == 0xffff)){ return false; }
		return ((pov >= (deg45 * 5)) && (pov <= (deg45 * 7)));
	}

	/**
	 * _Rg[lEL[ւ̕ϊ
	 * @param pov _Rg[l
	 * @return EL[Ătrue
	 */
	inline bool povToRightKey(int pov) const{
		if(((pov & 0xffff) == 0xffff)){ return false; }
		return ((pov >= (deg45)) && (pov <= (deg45 * 3)));
	}

	//--------------------------------------------------------------------------
	/// {^}bv
	int buttonMap_[maxButtonCount];
	/// X}[gWCpbhtO
	bool isSmartJoypad_;

	/// _Rg[ɂ45x
	static const int deg45 = 4500;

private:

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of PS2_PAD_H_
//------------------------------------------------------------------------------
