//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * }EXXe[gwb_
 * @author Junpee
 */

#ifndef MOUSE_STATE_H_
#define MOUSE_STATE_H_

namespace Lamp{

class BinaryWriter;
class BinaryReader;

//------------------------------------------------------------------------------
/**
 * }EXXe[g
 */
class MouseState{
friend class MouseDevice;
public:
	/// ő{^
	static const int maxButtonCount = 8;

	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	MouseState(){ clear(); }

	/**
	 * fXgN^
	 */
	virtual ~MouseState(){}

	/**
	 * NA
	 */
	virtual void clear(){
		xAxis_ = yAxis_ = zAxis_ = 0;
		for(int i = 0; i < maxButtonCount; i++){ buttons_[i] = false; }
	}

	//--------------------------------------------------------------------------
	/**
	 * X̐ݒ
	 * @param xAxis X
	 */
	virtual void setXAxis(int xAxis){ xAxis_ = xAxis; }

	/**
	 * X̎擾
	 * @return X
	 */
	virtual int getXAxis() const{ return xAxis_; }

	/**
	 * Y̐ݒ
	 * @param yAxis Y
	 */
	virtual void setYAxis(int yAxis){ yAxis_ = yAxis; }

	/**
	 * Y̎擾
	 * @return Y
	 */
	virtual int getYAxis() const{ return yAxis_; }

	/**
	 * Z̐ݒ
	 * @param zAxis Z
	 */
	virtual void setZAxis(int zAxis){ zAxis_ = zAxis; }

	/**
	 * Z̎擾
	 * @return Z
	 */
	virtual int getZAxis() const{ return zAxis_; }

	//--------------------------------------------------------------------------
	/**
	 * {^̐ݒ
	 * @param id Ώۃ{^ID
	 * @param pressed trueȂ牟Ă
	 */
	virtual void setButtonPressed(int id, bool pressed){
		Assert((id >= 0) && (id < maxButtonCount));
		buttons_[id] = pressed;
	}

	/**
	 * {^Ă邩
	 * @param id Ώۃ{^ID
	 * @return {^Ătrue
	 */
	virtual bool buttonPressed(int id) const{
		Assert((id >= 0) && (id < maxButtonCount));
		return buttons_[id];
	}

	//--------------------------------------------------------------------------
	/**
	 * ւ̕ϊ
	 * @return 
	 */
	virtual String toString() const{
		String result;
		result.format("( X = %4d , Y = %4d , Z = %4d )\n"
			"Press       %d %d %d %d %d %d %d %d\n",
			getXAxis(), getYAxis(), getZAxis(),
			buttonPressed(0), buttonPressed(1), buttonPressed(2),
			buttonPressed(3), buttonPressed(4), buttonPressed(5), 
			buttonPressed(6), buttonPressed(7));
		return result;
	}

	//--------------------------------------------------------------------------
	/**
	 * oCio
	 * @param binaryWriter oCiC^
	 */
	virtual void writeBinary(BinaryWriter* binaryWriter) const;

	/**
	 * oCiǂݍ
	 * @param binaryReader oCi[_
	 */
	virtual void readBinary(BinaryReader* binaryReader);

	//--------------------------------------------------------------------------
private:
	// X
	int xAxis_;
	// Y
	int yAxis_;
	// Z
	int zAxis_;
	// {^f[^
	bool buttons_[maxButtonCount];
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of _H_
//------------------------------------------------------------------------------

