//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * }EXfoCXwb_
 * @author Junpee
 */

#ifndef MOUSE_DEVICE_H_
#define MOUSE_DEVICE_H_

#include <Input/System/InputDevice.h>
#include <Input/Mouse/MouseState.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * }EXfoCX
 */
class MouseDevice : public InputDevice{
friend class LampInput;
friend class BufferedInput;
public:
	//--------------------------------------------------------------------------
	// 萔
	//--------------------------------------------------------------------------
	/// ő{^
	static const int maxButtonCount = MouseState::maxButtonCount;

	//--------------------------------------------------------------------------
	/**
	 * }EXXe[g̎擾
	 * @return }EXXe[g
	 */
	virtual const MouseState& getMouseState() const{ return mouseState_; }

	/**
	 * Z𑜓x̎擾
	 * @return Z𑜓x
	 */
	int getZResolution() const{ return zResolution_; }

	/**
	 * x̐ݒ
	 * @param exclusive r[hȂtrue
	 * @param foreground tHAOEh[hȂtrue
	 * @return true
	 */
	virtual bool setCooperativeLevel(bool exclusive, bool foreground){
		// sȑgݍ킹`FbN
		Assert(!(exclusive && (!foreground)));
		return InputDevice::setCooperativeLevel(exclusive, foreground);
	}

	/**
	 * ւ̕ϊ
	 * @return 
	 */
	virtual String toString() const{
		String deviceString;
		deviceString.format("ZResolution %d\n", getZResolution());
		return getInputDeviceString() + deviceString + mouseState_.toString();
	}

protected:
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	MouseDevice();

	/**
	 * fXgN^
	 */
	virtual ~MouseDevice();

	/**
	 * 
	 * @param inputDevice ̓foCX
	 * @param windowHandle EBhEnh
	 * @return true
	 */
	virtual bool initialize(DirectInputDevice* inputDevice, HWND windowHandle);

	/**
	 * |[O
	 * @return |[Ołtrue
	 */
	virtual bool polling();

private:
	// }EXXe[g
	MouseState mouseState_;
	// Z𑜓x
	int zResolution_;
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of MOUSE_DEVICE_H_
//------------------------------------------------------------------------------
