//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * }EXwb_
 * @author Junpee
 */

#ifndef MOUSE_H_
#define MOUSE_H_

#include <Input/Mouse/MouseState.h>
#include <Input/Mouse/MouseDevice.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * }EX
 */
class Mouse{
friend class LampInput;
friend class BufferedInput;
public:
	//--------------------------------------------------------------------------
	// 萔
	//--------------------------------------------------------------------------
	/// ő{^
	static const int maxButtonCount = 8;

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * X̎擾
	 * @return X
	 */
	virtual int getXAxis() const{ return state_.getXAxis(); }

	/**
	 * Y̎擾
	 * @return Y
	 */
	virtual int getYAxis() const{ return state_.getYAxis(); }

	/**
	 * Z̎擾
	 * @return Z
	 */
	virtual int getZAxis() const{ return state_.getZAxis(); }

	/**
	 * Z𑜓x̎擾
	 * @return Z𑜓x
	 */
	int getZResolution() const{ return device_->getZResolution(); }

	/**
	 * ␳ςZ̎擾
	 * @return ␳ςZ
	 */
	virtual float getCorrectedZAxis() const{
		return (float)getZAxis() / (float)getZResolution();
	}

	//--------------------------------------------------------------------------
	// {^
	//--------------------------------------------------------------------------
	/**
	 * {^̎擾
	 * @return {^
	 */
	virtual int getButtonCount() const{ return device_->getButtonCount(); }

	/**
	 * {^Ă邩
	 * @param id Ώۃ{^ID
	 * @return {^Ătrue
	 */
	virtual bool buttonPressed(int id) const{
		return state_.buttonPressed(id);
	}

	/**
	 * {^
	 * @param id {^ID
	 * @return {^Ȃtrue
	 */
	virtual bool buttonDown(int id) const{
		return (state_.buttonPressed(id) && (!preState_.buttonPressed(id)));
	}

	/**
	 * {^オ
	 * @param id {^ID
	 * @return {^オȂtrue
	 */
	virtual bool buttonUp(int id) const{
		return ((!state_.buttonPressed(id)) && preState_.buttonPressed(id));
	}

	//--------------------------------------------------------------------------
	// NbN
	//--------------------------------------------------------------------------
	/**
	 * NbNʒu͈͂̐ݒ
	 * @param clickPositionRange NbNʒu͈
	 */
	virtual void setClickPositionRange(int clickPositionRange){
		clickPositionRange_ = clickPositionRange;
	}

	/**
	 * NbNʒu͈͂̎擾
	 * @return NbNʒu͈
	 */
	virtual int getClickPositionRange() const{ return clickPositionRange_; }

	//--------------------------------------------------------------------------
	/**
	 * _uNbNԔ͈͂̐ݒ
	 * @param doubleClickTimeRange _uNbNԔ͈
	 */
	virtual void setDoubleClickTimeRange(int doubleClickTimeRange){
		doubleClickTimeRange_ = doubleClickTimeRange;
	}

	/**
	 * _uNbNԔ͈͂̎擾
	 * @return _uNbNԔ͈
	 */
	virtual int getDoubleClickTimeRange() const{ return doubleClickTimeRange_; }

	//--------------------------------------------------------------------------
	/**
	 * NbNꂽ
	 * @param id Ώۃ{^ID
	 * @return {^NbNĂtrue
	 */
	virtual bool clicked(int id) const{
		Assert(id >= 0);
		Assert(id < maxButtonCount);
		return clicked_[id];
	}

	/**
	 * _uNbNꂽ
	 * @param id Ώۃ{^ID
	 * @return {^_uNbNĂtrue
	 */
	virtual bool doubleClicked(int id) const{
		Assert(id >= 0);
		Assert(id < maxButtonCount);
		return doubleClicked_[id];
	}

	/**
	 * _u_Eꂽ
	 * @param id Ώۃ{^ID
	 * @return {^_u_EĂtrue
	 */
	virtual bool doubleDown(int id) const{
		Assert(id >= 0);
		Assert(id < maxButtonCount);
		return doubleDown_[id];
	}

	//--------------------------------------------------------------------------
	/**
	 * O̎擾
	 * @return O
	 */
	virtual String getName() const{ return device_->getProductName(); }

	/**
	 * A^b`Ă邩
	 * @return A^b`Ătrue
	 */
	virtual bool isAttached() const{ return device_->isAttached(); }

	/**
	 * |[OKv
	 * @return |[OKvȂtrue
	 */
	virtual bool isPolled() const{ return device_->isPolled(); }

	/**
	 * ւ̕ϊ
	 * @return 
	 */
	virtual String toString() const;

	/**
	 * NA
	 */
	virtual void clear(){
		state_.clear();
		preState_.clear();
	}

	/**
	 * x̐ݒ
	 * @param exclusive r[hȂtrue
	 * @param foreground tHAOEh[hȂtrue
	 * @return true
	 */
	virtual bool setCooperativeLevel(bool exclusive, bool foreground){
		return device_->setCooperativeLevel(exclusive, foreground);
	}

	/**
	 * r[h
	 * @return r[hȂtrue
	 */
	virtual bool isExclusive() const{ return device_->isExclusive(); }

	/**
	 * tHAOEh[h
	 * @return tHAOEh[hȂtrueAobNOEh[hȂfalse
	 */
	virtual bool isForeground() const{ return device_->isForeground(); }

protected:
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param device foCX
	 */
	Mouse(MouseDevice* device);

	/**
	 * fXgN^
	 */
	virtual ~Mouse();

	/**
	 * ̃Xe[gݒ
	 * @param state ̃Xe[g
	 */
	virtual void setNextState(const MouseState& state);

	/**
	 * Xe[g̎擾
	 * @return Xe[g
	 */
	virtual const MouseState& getState(){ return state_; }

	/**
	 * NbNXe[gNA
	 */
	virtual void clickStateClear();

private:
	//--------------------------------------------------------------------------
	// foCX
	MouseDevice* device_;
	// Xe[g
	MouseState state_;
	// ÕXe[g
	MouseState preState_;
	// ItZbg
	Point2i downOffset_[maxButtonCount];
	// 
	int downTime_[maxButtonCount];
	// ỎItZbg
	Point2i preDownOffset_[maxButtonCount];
	// Ỏ
	int preDownTime_[maxButtonCount];
	// NbNʒu͈
	int clickPositionRange_;
	// _uNbNԔ͈
	int doubleClickTimeRange_;
	// NbN
	bool clicked_[maxButtonCount];
	// _uNbN
	bool doubleClicked_[maxButtonCount];
	// _u_E
	bool doubleDown_[maxButtonCount];
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of MOUSE_H_
//------------------------------------------------------------------------------
