//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * L[{[hXe[gwb_
 * @author Junpee
 */

#ifndef KEYBOARD_STATE_H_
#define KEYBOARD_STATE_H_

#include <Input/Keyboard/KeyboardKey.h>

namespace Lamp{

class BinaryWriter;
class BinaryReader;

//------------------------------------------------------------------------------
/**
 * L[{[hXe[g
 */
class KeyboardState : public KeyboardKey{
public:
	/**
	 * RXgN^
	 */
	KeyboardState(){ clear(); }

	/**
	 * fXgN^
	 */
	virtual ~KeyboardState(){}

	/**
	 * NA
	 */
	virtual void clear(){
		for(int i = 0; i < maxKeyCount; i++){ keys_[i] = false; }
	}

	//--------------------------------------------------------------------------
	/**
	 * L[̐ݒ
	 * @param key ΏۃL[
	 * @param pressed trueȂ牟Ă
	 */
	virtual void setKeyPressed(Key key, bool pressed){
		Assert((key >= 0) && (key < maxKeyCount));
		keys_[key] = pressed;
	}

	/**
	 * L[Ă邩
	 * @param key ΏۃL[
	 * @return L[Ătrue
	 */
	virtual bool keyPressed(Key key) const{
		Assert((key >= 0) && (key < maxKeyCount));
		return keys_[key];
	}

	//--------------------------------------------------------------------------
	/**
	 * ւ̕ϊ
	 * @return 
	 */
	virtual String toString() const{
		String result = "Press ";
		for(int i = 0; i < maxKeyCount; i++){
			Key key = (Key)i;
			if(keyPressed(key)){ result += keyToString(key) + " "; }
		}
		result += "\n";
		return result;
	}

	//--------------------------------------------------------------------------
	/**
	 * oCio
	 * @param binaryWriter oCiC^
	 */
	virtual void writeBinary(BinaryWriter* binaryWriter) const;

	/**
	 * oCiǂݍ
	 * @param binaryReader oCi[_
	 */
	virtual void readBinary(BinaryReader* binaryReader);

	//--------------------------------------------------------------------------
private:
	// L[f[^
	bool keys_[maxKeyCount];

};
//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of KEYBOARD_STATE_H_
//------------------------------------------------------------------------------

