//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * L[{[hL[wb_
 * @author Junpee
 */

#ifndef KEYBOARD_KEY_H_
#define KEYBOARD_KEY_H_

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * L[{[hL[
 */
class KeyboardKey{
friend class LampInput;
public:
	/// őL[
	static const int maxKeyCount = 256;

	//--------------------------------------------------------------------------
	/// L[
	enum Key{
		keyEscape =			0x01,
		key1 =				0x02,
		key2 =				0x03,
		key3 =				0x04,
		key4 =				0x05,
		key5 =				0x06,
		key6 =				0x07,
		key7 =				0x08,
		key8 =				0x09,
		key9 =				0x0a,
		key0 =				0x0b,
		keyMinus =			0x0c,
		keyEquals =			0x0d,
		keyBackspace =		0x0e,
		keyTab =			0x0f,
		keyQ =				0x10,
		keyW =				0x11,
		keyE =				0x12,
		keyR =				0x13,
		keyT =				0x14,
		keyY =				0x15,
		keyU =				0x16,
		keyI =				0x17,
		keyO =				0x18,
		keyP =				0x19,
		keyLeftBracket =	0x1a,
		keyRightBracket =	0x1b,
		keyEnter =			0x1c,
		keyLeftControl =	0x1d,
		keyA =				0x1e,
		keyS =				0x1f,
		keyD =				0x20,
		keyF =				0x21,
		keyG =				0x22,
		keyH =				0x23,
		keyJ =				0x24,
		keyK =				0x25,
		keyL =				0x26,
		keySemicolon =		0x27,
		keyApostrophe =		0x28,
		keyGrave =			0x29,
		keyLeftShift =		0x2a,
		keyBackslash =		0x2b,
		keyZ =				0x2c,
		keyX =				0x2d,
		keyC =				0x2e,
		keyV =				0x2f,
		keyB =				0x30,
		keyN =				0x31,
		keyM =				0x32,
		keyComma =			0x33,
		keyPeriod =			0x34,
		keySlash =			0x35,
		keyRightShift =		0x36,
		keyNumPadMultiply =	0x37,
		keyLeftAlt =		0x38,
		keySpace =			0x39,
		keyCapsLock =		0x3a,
		keyF1 =				0x3b,
		keyF2 =				0x3c,
		keyF3 =				0x3d,
		keyF4 =				0x3e,
		keyF5 =				0x3f,
		keyF6 =				0x40,
		keyF7 =				0x41,
		keyF8 =				0x42,
		keyF9 =				0x43,
		keyF10 =			0x44,
		keyNumLock =		0x45,
		keyScroll =			0x46,
		keyNumPad7 =		0x47,
		keyNumPad8 =		0x48,
		keyNumPad9 =		0x49,
		keyNumPadSubtract =	0x4a,
		keyNumPad4 =		0x4b,
		keyNumPad5 =		0x4c,
		keyNumPad6 =		0x4d,
		keyNumPadAdd =		0x4e,
		keyNumPad1 =		0x4f,
		keyNumPad2 =		0x50,
		keyNumPad3 =		0x51,
		keyNumPad0 =		0x52,
		keyNumPadDecimal =	0x53,

		keyLeftBackslash =	0x56,
		keyF11 =			0x57,
		keyF12 =			0x58,

		keyF13 =			0x64,
		keyF14 =			0x65,
		keyF15 =			0x66,

		keyKana =			0x70,

		keyAbntC1 =			0x73,

		keyConvert =		0x79,

		keyNoConvert =		0x7b,

		keyYen =			0x7d,
		keyNumPadAbntC2 =	0x7e,

		keyNumPadEquals98 =	0x8d,

		keyPrevTrack =		0x90,
		keyAtmark =			0x91,
		keyColon =			0x92,
		keyUnderLine98 =	0x93,
		keyKanji =			0x94,
		keyStop98 =			0x95,
		keyAx =				0x96,
		keyUnlabeled =		0x97,

		keyNextTrack =		0x99,

		keyNumPadEnter =	0x9c,
		keyRightControl =	0x9d,

		keyMute =			0xa0,
		keyCalculator =		0xa1,
		keyPlayPause =		0xa2,

		keyMediaStop =		0xa4,

		keyVolumeDown =		0xae,

		keyVolumeUp =		0xb0,

		keyWebHome =		0xb2,
		keyNumPadComma =	0xb3,

		keyNumPadDivide =	0xb5,

		keyPrintScreen =	0xb7,
		keyRightAlt =		0xb8,

		keyPause =			0xc5,

		keyHome =			0xc7,
		keyUp =				0xc8,
		keyPageUp =			0xc9,

		keyLeft =			0xcb,

		keyRight =			0xcd,

		keyEnd =			0xcf,
		keyDown =			0xd0,
		keyPageDown =		0xd1,
		keyInsert =			0xd2,
		keyDelete =			0xd3,

		keyLeftWin =		0xdb,
		keyRightWin =		0xdc,
		keyApps =			0xdd,
		keyPower =			0xde,
		keySleep =			0xdf,

		keyWake =			0xe3,

		keyWebSearch =		0xe5,
		keyWebFavorites =	0xe6,
		keyWebRefresh =		0xe7,
		keyWebStop =		0xe8,
		keyWebForward =		0xe9,
		keyWebBack =		0xea,
		keyMyComputer =		0xeb,
		keyMail =			0xec,
		keyMediaSelect =	0xed,
	};

	//--------------------------------------------------------------------------
	/**
	 * L[𕶎ɕϊ
	 * @param key ɕϊL[
	 * @return L[\
	 */
	virtual String keyToString(Key key) const{
		Assert((key >= 0) && (key < maxKeyCount));
		return keyName_[key];
	}

	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	KeyboardKey(){}

	/**
	 * fXgN^
	 */
	virtual ~KeyboardKey(){}

	//--------------------------------------------------------------------------
private:
	/**
	 * L[񏉊
	 */
	static void initializeKeyString();

	// L[
	static String keyName_[maxKeyCount];
	// tO
	static bool initialized_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of KEYBOARD_KEY_H_
//------------------------------------------------------------------------------

