//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * L[{[hfoCXwb_
 * @author Junpee
 */

#ifndef KEYBOARD_DEVICE_H_
#define KEYBOARD_DEVICE_H_

#include <Input/System/InputDevice.h>
#include <Input/Keyboard/KeyboardKey.h>
#include <Input/Keyboard/KeyboardState.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * L[{[hfoCX
 */
class KeyboardDevice : public InputDevice, public KeyboardKey{
friend class LampInput;
friend class BufferedInput;
public:
	/**
	 * L[{[hXe[g̎擾
	 * @return L[{[hXe[g
	 */
	virtual const KeyboardState& getKeyboardState() const{
		return keyboardState_;
	}

	/**
	 * x̐ݒ
	 * @param exclusive r[hȂtrue
	 * @param foreground tHAOEh[hȂtrue
	 * @return true
	 */
	virtual bool setCooperativeLevel(bool exclusive, bool foreground){
		// sȑgݍ킹`FbN
		Assert(!(exclusive && (!foreground)));
		return InputDevice::setCooperativeLevel(exclusive, foreground);
	}

	/**
	 * ւ̕ϊ
	 * @return 
	 */
	virtual String toString() const{
		return getInputDeviceString() + keyboardState_.toString();
	}

protected:
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	KeyboardDevice();

	/**
	 * fXgN^
	 */
	virtual ~KeyboardDevice();

	/**
	 * 
	 * @param inputDevice ̓foCX
	 * @param windowHandle EBhEnh
	 * @return true
	 */
	virtual bool initialize(DirectInputDevice* inputDevice, HWND windowHandle);

	/**
	 * |[O
	 * @return |[Ołtrue
	 */
	virtual bool polling();

	//--------------------------------------------------------------------------
private:
	// L[{[hXe[g
	KeyboardState keyboardState_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of KEYBOARD_DEVICE_H_
//------------------------------------------------------------------------------
