//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * L[{[hwb_
 * @author Junpee
 */

#ifndef KEYBOARD_H_
#define KEYBOARD_H_

#include <Input/Keyboard/KeyboardKey.h>
#include <Input/Keyboard/KeyboardState.h>
#include <Input/Keyboard/KeyboardDevice.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * L[{[h
 */
class Keyboard : public KeyboardKey{
friend class LampInput;
friend class BufferedInput;
public:
	//--------------------------------------------------------------------------
	/**
	 * L[̎擾
	 * @return L[
	 */
	virtual int getKeyCount() const{ return device_->getButtonCount(); }

	/**
	 * L[Ă邩
	 * @param key ΏۃL[
	 * @return L[Ătrue
	 */
	virtual bool pressed(Key key) const{ return state_.keyPressed(key); }

	/**
	 * L[
	 * @param key L[
	 * @return L[Ȃtrue
	 */
	virtual bool down(Key key) const{
		return (state_.keyPressed(key) && (!preState_.keyPressed(key)));
	}

	/**
	 * L[オ
	 * @param key L[
	 * @return L[オȂtrue
	 */
	virtual bool up(Key key) const{
		return ((!state_.keyPressed(key)) && preState_.keyPressed(key));
	}

	//--------------------------------------------------------------------------
	/**
	 * O̎擾
	 * @return O
	 */
	virtual String getName() const{ return device_->getProductName(); }

	/**
	 * A^b`Ă邩
	 * @return A^b`Ătrue
	 */
	virtual bool isAttached() const{ return device_->isAttached(); }

	/**
	 * |[OKv
	 * @return |[OKvȂtrue
	 */
	virtual bool isPolled() const{ return device_->isPolled(); }

	/**
	 * ւ̕ϊ
	 * @return 
	 */
	virtual String toString() const;

	/**
	 * NA
	 */
	virtual void clear(){
		state_.clear();
		preState_.clear();
	}

	/**
	 * x̐ݒ
	 * @param exclusive r[hȂtrue
	 * @param foreground tHAOEh[hȂtrue
	 * @return true
	 */
	virtual bool setCooperativeLevel(bool exclusive, bool foreground){
		return device_->setCooperativeLevel(exclusive, foreground);
	}

	/**
	 * r[h
	 * @return r[hȂtrue
	 */
	virtual bool isExclusive() const{ return device_->isExclusive(); }

	/**
	 * tHAOEh[h
	 * @return tHAOEh[hȂtrueAobNOEh[hȂfalse
	 */
	virtual bool isForeground() const{ return device_->isForeground(); }

protected:
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	Keyboard(KeyboardDevice* device);

	/**
	 * fXgN^
	 */
	virtual ~Keyboard();

	/**
	 * ̃Xe[gݒ
	 * @param state ̃Xe[g
	 */
	virtual void setNextState(const KeyboardState& state);

	/**
	 * Xe[g̎擾
	 * @return Xe[g
	 */
	virtual const KeyboardState& getState(){ return state_; }

private:
	//--------------------------------------------------------------------------
	// foCX
	KeyboardDevice* device_;
	// Xe[g
	KeyboardState state_;
	// ÕXe[g
	KeyboardState preState_;
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of KEYBOARD_H_
//------------------------------------------------------------------------------
