//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * WCXeBbNXe[gwb_
 * @author Junpee
 */

#ifndef JOYSTICK_STATE_H_
#define JOYSTICK_STATE_H_

namespace Lamp{

class BinaryWriter;
class BinaryReader;

//------------------------------------------------------------------------------
/**
 * WCXeBbNXe[g
 */
class JoystickState{
public:
	/// ő压_Rg[
	static const int maxPOVCount = 4;

	/// őXC_
	static const int maxSliderCount = 2;

	/// ő{^
	static const int maxButtonCount = 32;

	/// f[^ől
	static const int maxAxisValue = 10000;

	/// f[^ŏl
	static const int minAxisValue = -10000;

	/// _Rg[ől
	static const int maxPOVValue = 36000;

	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	JoystickState(){ clear(); }

	/**
	 * fXgN^
	 */
	virtual ~JoystickState(){}

	/**
	 * NA
	 */
	virtual void clear(){
		xAxis_ = yAxis_ = zAxis_ = 0;
		xRotation_ = yRotation_ = zRotation_ = 0;
		for(int i = 0; i < maxPOVCount; i++){ povs_[i] = -1; }
		for(int i = 0; i < maxSliderCount; i++){ sliders_[i] = 0; }
		for(int i = 0; i < maxButtonCount; i++){ buttons_[i] = false; }
	}

	//--------------------------------------------------------------------------
	/**
	 * X̐ݒ
	 * @param xAxis X
	 */
	virtual void setXAxis(int xAxis){ xAxis_ = xAxis; }

	/**
	 * X̎擾
	 * @return X
	 */
	virtual int getXAxis() const{ return xAxis_; }

	/**
	 * Y̐ݒ
	 * @param yAxis Y
	 */
	virtual void setYAxis(int yAxis){ yAxis_ = yAxis; }

	/**
	 * Y̎擾
	 * @return Y
	 */
	virtual int getYAxis() const{ return yAxis_; }

	/**
	 * Z̐ݒ
	 * @param zAxis Z
	 */
	virtual void setZAxis(int zAxis){ zAxis_ = zAxis; }

	/**
	 * Z̎擾
	 * @return Z
	 */
	virtual int getZAxis() const{ return zAxis_; }

	//--------------------------------------------------------------------------
	/**
	 * X]̐ݒ
	 * @param xRotation X]
	 */
	virtual void setXRotation(int xRotation){ xRotation_ = xRotation; }

	/**
	 * X]̎擾
	 * @return X]
	 */
	virtual int getXRotation() const{ return xRotation_; }

	/**
	 * Y]̐ݒ
	 * @param yRotation Y]
	 */
	virtual void setYRotation(int yRotation){ yRotation_ = yRotation; }

	/**
	 * Y]̎擾
	 * @return Y]
	 */
	virtual int getYRotation() const{ return yRotation_; }

	/**
	 * Z]̐ݒ
	 * @param zRotation Z]
	 */
	virtual void setZRotation(int zRotation){ zRotation_ = zRotation; }

	/**
	 * Z]̎擾
	 * @return Z]
	 */
	virtual int getZRotation() const{ return zRotation_; }

	//--------------------------------------------------------------------------
	/**
	 * _Rg[l̐ݒ
	 * @param id _Rg[ID
	 * @param pov _Rg[l
	 */
	virtual void setPOV(int id, int pov){
		Assert((id >= 0) && (id < maxPOVCount));
		povs_[id] = pov;
	}

	/**
	 * _Rg[l̎擾
	 * @param id _Rg[ID
	 * @return _Rg[l
	 */
	virtual int getPOV(int id) const{
		Assert((id >= 0) && (id < maxPOVCount));
		return povs_[id];
	}

	//--------------------------------------------------------------------------
	/**
	 * XC_l̐ݒ
	 * @param id XC_ID
	 * @param slider XC_l
	 */
	virtual void setSlider(int id, int slider){
		Assert((id >= 0) && (id < maxSliderCount));
		sliders_[id] = slider;
	}

	/**
	 * XC_l̎擾
	 * @param id XC_ID
	 * @return XC_l
	 */
	virtual int getSlider(int id) const{
		Assert((id >= 0) && (id < maxSliderCount));
		return sliders_[id];
	}

	//--------------------------------------------------------------------------
	/**
	 * {^̐ݒ
	 * @param id Ώۃ{^ID
	 * @param pressed trueȂ牟Ă
	 */
	virtual void setButtonPressed(int id, bool pressed){
		Assert((id >= 0) && (id < maxButtonCount));
		buttons_[id] = pressed;
	}

	/**
	 * {^Ă邩
	 * @param id Ώۃ{^ID
	 * @return {^Ătrue
	 */
	virtual bool buttonPressed(int id) const{
		Assert((id >= 0) && (id < maxButtonCount));
		return buttons_[id];
	}

	//--------------------------------------------------------------------------
	/**
	 * ւ̕ϊ
	 * @return 
	 */
	virtual String toString() const{
		String result;
		result.format("( XAxis = %4d , YAxis = %4d , ZAxis = %4d )\n"
			"( XRot = %4d , YRot = %4d , ZRot = %4d )\n"
			"POV %d %d %d %d\n"
			"Slider %d %d\n"
			"Buttons %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d "
			"%d %d %d %d %d %d %d %d %d %d %d %d %d %d %d %d\n",
			getXAxis(), getYAxis(), getZAxis(),
			getXRotation(), getYRotation(), getZRotation(),
			getPOV(0),getPOV(1),getPOV(2),getPOV(3),
			getSlider(0), getSlider(1),
			buttonPressed(0), buttonPressed(1), buttonPressed(2),
			buttonPressed(3), buttonPressed(4), buttonPressed(5), 
			buttonPressed(6), buttonPressed(7),
			buttonPressed(8), buttonPressed(9), buttonPressed(10),
			buttonPressed(11), buttonPressed(12), buttonPressed(13), 
			buttonPressed(14), buttonPressed(15),
			buttonPressed(16), buttonPressed(17), buttonPressed(18),
			buttonPressed(19), buttonPressed(20), buttonPressed(21), 
			buttonPressed(22), buttonPressed(23),
			buttonPressed(24), buttonPressed(25), buttonPressed(26),
			buttonPressed(27), buttonPressed(28), buttonPressed(29), 
			buttonPressed(30), buttonPressed(31));
		return result;
	}

	//--------------------------------------------------------------------------
	/**
	 * oCio
	 * @param binaryWriter oCiC^
	 */
	virtual void writeBinary(BinaryWriter* binaryWriter) const;

	/**
	 * oCiǂݍ
	 * @param binaryReader oCi[_
	 */
	virtual void readBinary(BinaryReader* binaryReader);

	//--------------------------------------------------------------------------
private:
	// X
	int xAxis_;
	// Y
	int yAxis_;
	// Z
	int zAxis_;
	// X]
	int xRotation_;
	// Y]
	int yRotation_;
	// Z]
	int zRotation_;
	// _Rg[
	int povs_[maxPOVCount];
	// XC_
	int sliders_[maxSliderCount];
	// {^f[^
	bool buttons_[maxButtonCount];

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of JOYSTICK_STATE_H_
//------------------------------------------------------------------------------
