//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * WCXeBbNfoCXwb_
 * @author Junpee
 */

#ifndef JOYSTICK_DEVICE_H_
#define JOYSTICK_DEVICE_H_

#include <Input/System/InputDevice.h>
#include <Input/Joystick/JoystickState.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * WCXeBbNfoCX
 */
class JoystickDevice : public InputDevice{
friend class LampInput;
friend class BufferedInput;
public:
	//--------------------------------------------------------------------------
	// 萔
	//--------------------------------------------------------------------------
	/// ő压_Rg[
	static const int maxPOVCount = JoystickState::maxPOVCount;

	/// őXC_
	static const int maxSliderCount = JoystickState::maxSliderCount;

	/// ő{^
	static const int maxButtonCount = JoystickState::maxButtonCount;

	/// f[^ől
	static const int maxAxisValue = JoystickState::maxAxisValue;

	/// f[^ŏl
	static const int minAxisValue = JoystickState::minAxisValue;

	/// _Rg[ől
	static const int maxPOVValue = JoystickState::maxPOVValue;

	//--------------------------------------------------------------------------
	/**
	 * WCXeBbNXe[g̎擾
	 * @return WCXeBbNXe[g
	 */
	virtual const JoystickState& getJoystickState() const{
		return joystickState_;
	}

	/**
	 * ւ̕ϊ
	 * @return 
	 */
	virtual String toString() const;

	//--------------------------------------------------------------------------
	/**
	 * X
	 * @return XĂtrue
	 */
	virtual bool hasXAxis() const{ return hasXAxis_; }

	/**
	 * Y
	 * @return YĂtrue
	 */
	virtual bool hasYAxis() const{ return hasYAxis_; }

	/**
	 * Z
	 * @return ZĂtrue
	 */
	virtual bool hasZAxis() const{ return hasZAxis_; }

	//--------------------------------------------------------------------------
	/**
	 * X]
	 * @return X]Ătrue
	 */
	virtual bool hasXRotation() const{ return hasXRotation_; }

	/**
	 * Y]
	 * @return Y]Ătrue
	 */
	virtual bool hasYRotation() const{ return hasYRotation_; }

	/**
	 * Z]
	 * @return Z]Ătrue
	 */
	virtual bool hasZRotation() const{ return hasZRotation_; }

	//--------------------------------------------------------------------------
	/**
	 * _Rg[̎擾
	 * @return _Rg[
	 */
	virtual int getPOVCount() const{ return povCount_; }

	/**
	 * XC_̎擾
	 * @return XC_
	 */
	virtual int getSliderCount() const{ return sliderCount_; }

	//--------------------------------------------------------------------------
	/**
	 * WCXeBbNIuWFNg̗񋓃R[obN
	 *
	 * [U͂̃\bhĂяoȂŉ
	 * @param instance foCXIuWFNgCX^X
	 * @param userData [Uf[^
	 * @return 񋓌ptO
	 */
	static int __stdcall joystickObjectEnumeration(
		const DIDEVICEOBJECTINSTANCE* instance, void* userData);

protected:
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	JoystickDevice();

	/**
	 * fXgN^
	 */
	virtual ~JoystickDevice();

	/**
	 * 
	 * @param inputDevice ̓foCX
	 * @param windowHandle EBhEnh
	 * @return true
	 */
	virtual bool initialize(DirectInputDevice* inputDevice, HWND windowHandle);

	/**
	 * WCXeBbNIuWFNg̃`FbN
	 * @param instance WCXeBbNIuWFNg
	 * @return true
	 */
	virtual bool checkJoystickObject(const DIDEVICEOBJECTINSTANCE* instance);

	/**
	 * |[O
	 * @return |[Ołtrue
	 */
	virtual bool polling();

private:
	// WCXeBbNXe[g
	JoystickState joystickState_;
	// _Rg[
	int povCount_;
	// XC_
	int sliderCount_;
	// XĂ邩
	bool hasXAxis_;
	// YĂ邩
	bool hasYAxis_;
	// ZĂ邩
	bool hasZAxis_;
	// X]Ă邩
	bool hasXRotation_;
	// Y]Ă邩
	bool hasYRotation_;
	// Z]Ă邩
	bool hasZRotation_;

	// fbh][
	static const int deadZone_ = 3000;
	// Oa][
	static const int saturationZone_ = 9500;
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of JOYSTICK_DEVICE_H_
//------------------------------------------------------------------------------
