//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * WCXeBbNwb_
 * @author Junpee
 */

#ifndef JOYSTICK_H_
#define JOYSTICK_H_

#include <Input/Joystick/JoystickAxis.h>
#include <Input/Joystick/JoystickState.h>
#include <Input/Joystick/JoystickDevice.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * WCXeBbN
 */
class Joystick : public JoystickAxis{
friend class LampInput;
friend class BufferedInput;
public:
	//--------------------------------------------------------------------------
	// 萔
	//--------------------------------------------------------------------------
	/// ő压_Rg[
	static const int maxPOVCount = JoystickState::maxPOVCount;

	/// őXC_
	static const int maxSliderCount = JoystickState::maxSliderCount;

	/// ő{^
	static const int maxButtonCount = JoystickState::maxButtonCount;

	/// f[^ől
	static const int maxAxisValue = JoystickState::maxAxisValue;

	/// f[^ŏl
	static const int minAxisValue = JoystickState::minAxisValue;

	/// _Rg[ől
	static const int maxPOVValue = JoystickState::maxPOVValue;

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * ̎擾
	 * @return 
	 */
	virtual int getAxisCount() const{ return device_->getAxisCount(); }

	/**
	 * XC_ȊO̎擾
	 * @return XC_ȊO̎
	 */
	virtual int getAxisCountWithoutSlider() const{
		return (device_->getAxisCount() - device_->getSliderCount());
	}

	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param axis 
	 * @return Ăture
	 */
	virtual bool hasAxis(Axis axis) const{
		if(axis == axisX){ return hasXAxis(); }
		if(axis == axisY){ return hasYAxis(); }
		if(axis == axisZ){ return hasZAxis(); }
		if(axis == axisRotationX){ return hasXRotation(); }
		if(axis == axisRotationY){ return hasYRotation(); }
		if(axis == axisRotationZ){ return hasZRotation(); }
		if(axis == axisSlider0){ return (getSliderCount() >= 1); }
		if(axis == axisSlider1){ return (getSliderCount() >= 2); }
		Assert(false);
		return false;
	}

	/**
	 * ̒l擾
	 * @return ̒l
	 */
	virtual float getAxis(Axis axis) const{
		if(axis == axisX){ return getXAxis(); }
		if(axis == axisY){ return getYAxis(); }
		if(axis == axisZ){ return getZAxis(); }
		if(axis == axisRotationX){ return getXRotation(); }
		if(axis == axisRotationY){ return getYRotation(); }
		if(axis == axisRotationZ){ return getZRotation(); }
		if(axis == axisSlider0){ return getSlider(0); }
		if(axis == axisSlider1){ return getSlider(1); }
		Assert(false);
		return 0.f;
	}

	//--------------------------------------------------------------------------
	/**
	 * X
	 * @return XĂtrue
	 */
	virtual bool hasXAxis() const{ return device_->hasXAxis(); }

	/**
	 * X̎擾
	 * @return 1-1̒lƂX
	 */
	virtual float getXAxis() const{
		return correctAxisValue(state_.getXAxis());
	}

	/**
	 * OX̎擾
	 * @return 1-1̒lƂX
	 */
	virtual float getPreXAxis() const{
		return correctAxisValue(preState_.getXAxis());
	}

	//--------------------------------------------------------------------------
	/**
	 * Y
	 * @return YĂtrue
	 */
	virtual bool hasYAxis() const{ return device_->hasYAxis(); }

	/**
	 * Y̎擾
	 * @return 1-1̒lƂY
	 */
	virtual float getYAxis() const{
		return correctAxisValue(state_.getYAxis());
	}

	/**
	 * OY̎擾
	 * @return 1-1̒lƂY
	 */
	virtual float getPreYAxis() const{
		return correctAxisValue(preState_.getYAxis());
	}

	//--------------------------------------------------------------------------
	/**
	 * Z
	 * @return ZĂtrue
	 */
	virtual bool hasZAxis() const{ return device_->hasZAxis(); }

	/**
	 * Z̎擾
	 * @return 1-1̒lƂZ
	 */
	virtual float getZAxis() const{
		return correctAxisValue(state_.getZAxis());
	}

	/**
	 * OZ̎擾
	 * @return 1-1̒lƂZ
	 */
	virtual float getPreZAxis() const{
		return correctAxisValue(preState_.getZAxis());
	}

	//--------------------------------------------------------------------------
	/**
	 * X]
	 * @return X]Ătrue
	 */
	virtual bool hasXRotation() const{ return device_->hasXRotation(); }

	/**
	 * X]̎擾
	 * @return 1-1̒lƂX]
	 */
	virtual float getXRotation() const{
		return correctAxisValue(state_.getXRotation());
	}

	/**
	 * OX]̎擾
	 * @return 1-1̒lƂX]
	 */
	virtual float getPreXRotation() const{
		return correctAxisValue(preState_.getXRotation());
	}

	//--------------------------------------------------------------------------
	/**
	 * Y]
	 * @return Y]Ătrue
	 */
	virtual bool hasYRotation() const{ return device_->hasYRotation(); }

	/**
	 * Y]̎擾
	 * @return 1-1̒lƂY]
	 */
	virtual float getYRotation() const{
		return correctAxisValue(state_.getYRotation());
	}

	/**
	 * OY]̎擾
	 * @return 1-1̒lƂY]
	 */
	virtual float getPreYRotation() const{
		return correctAxisValue(preState_.getYRotation());
	}

	//--------------------------------------------------------------------------
	/**
	 * Z]
	 * @return Z]Ătrue
	 */
	virtual bool hasZRotation() const{ return device_->hasZRotation(); }

	/**
	 * Z]̎擾
	 * @return 1-1̒lƂZ]
	 */
	virtual float getZRotation() const{
		return correctAxisValue(state_.getZRotation());
	}

	/**
	 * OZ]̎擾
	 * @return 1-1̒lƂZ]
	 */
	virtual float getPreZRotation() const{
		return correctAxisValue(preState_.getZRotation());
	}

	//--------------------------------------------------------------------------
	// _Rg[
	//--------------------------------------------------------------------------
	/**
	 * _Rg[̎擾
	 * @return _Rg[
	 */
	virtual int getPOVCount() const{ return device_->getPOVCount(); }

	/**
	 * _Rg[l̎擾
	 * @param id _Rg[ID
	 * @return _Rg[l
	 */
	virtual int getPOV(int id) const{ return state_.getPOV(id); }

	/**
	 * O̎_Rg[l̎擾
	 * @param id _Rg[ID
	 * @return _Rg[l
	 */
	virtual int getPrePOV(int id) const{ return preState_.getPOV(id); }

	/**
	 * _Rg[S
	 * @param id _Rg[ID
	 * @return _Rg[SȂtrue
	 */
	virtual bool isPOVCenter(int id) const{
		return ((state_.getPOV(id) & 0xffff) == 0xffff);
	}

	//--------------------------------------------------------------------------
	// XC_[
	//--------------------------------------------------------------------------
	/**
	 * XC_̎擾
	 * @return XC_
	 */
	virtual int getSliderCount() const{ return device_->getSliderCount(); }

	/**
	 * XC_l̎擾
	 * @param id XC_ID
	 * @return 1-1̒lƂXC_l
	 */
	virtual float getSlider(int id) const{
		return correctSliderValue(state_.getSlider(id));
	}

	//--------------------------------------------------------------------------
	// {^
	//--------------------------------------------------------------------------
	/**
	 * {^̎擾
	 * @return {^
	 */
	virtual int getButtonCount() const{ return device_->getButtonCount(); }

	/**
	 * {^Ă邩
	 * @param id Ώۃ{^ID
	 * @return {^Ătrue
	 */
	virtual bool buttonPressed(int id) const{
		return state_.buttonPressed(id);
	}

	/**
	 * {^
	 * @param id {^ID
	 * @return {^Ȃtrue
	 */
	virtual bool buttonDown(int id) const{
		return (state_.buttonPressed(id) && (!preState_.buttonPressed(id)));
	}

	/**
	 * {^オ
	 * @param id {^ID
	 * @return {^オȂtrue
	 */
	virtual bool buttonUp(int id) const{
		return ((!state_.buttonPressed(id)) && preState_.buttonPressed(id));
	}

	//--------------------------------------------------------------------------
	/**
	 * O̎擾
	 * @return O
	 */
	virtual String getName() const{ return device_->getProductName(); }

	/**
	 * A^b`Ă邩
	 * @return A^b`Ătrue
	 */
	virtual bool isAttached() const{ return device_->isAttached(); }

	/**
	 * |[OKv
	 * @return |[OKvȂtrue
	 */
	virtual bool isPolled() const{ return device_->isPolled(); }

	/**
	 * ւ̕ϊ
	 * @return 
	 */
	virtual String toString() const;

	/**
	 * NA
	 */
	virtual void clear(){
		state_.clear();
		preState_.clear();
	}

	/**
	 * x̐ݒ
	 * @param exclusive r[hȂtrue
	 * @param foreground tHAOEh[hȂtrue
	 * @return true
	 */
	virtual bool setCooperativeLevel(bool exclusive, bool foreground){
		return device_->setCooperativeLevel(exclusive, foreground);
	}

	/**
	 * r[h
	 * @return r[hȂtrue
	 */
	virtual bool isExclusive() const{ return device_->isExclusive(); }

	/**
	 * tHAOEh[h
	 * @return tHAOEh[hȂtrueAobNOEh[hȂfalse
	 */
	virtual bool isForeground() const{ return device_->isForeground(); }

protected:
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param device foCX
	 */
	Joystick(JoystickDevice* device);

	/**
	 * fXgN^
	 */
	virtual ~Joystick();

	/**
	 * ̃Xe[gݒ
	 * @param state ̃Xe[g
	 */
	virtual void setNextState(const JoystickState& state);

	/**
	 * Xe[g̎擾
	 * @return Xe[g
	 */
	virtual const JoystickState& getState(){ return state_; }

	/**
	 * ␳
	 * @param axisValue ␳l
	 * @return ␳ꂽl
	 */
	virtual float correctAxisValue(int axisValue) const{
		return (float)axisValue / (float)maxAxisValue;
	}

	/**
	 * XC_␳
	 * @param sliderValue ␳l
	 * @return ␳ꂽl
	 */
	virtual float correctSliderValue(int sliderValue) const{
		return (float)sliderValue / (float)maxAxisValue;
	}

private:
	//--------------------------------------------------------------------------
	// foCX
	JoystickDevice* device_;
	// Xe[g
	JoystickState state_;
	// ÕXe[g
	JoystickState preState_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of JOYSTICK_H_
//------------------------------------------------------------------------------
