//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * r[|[gXvCgXe[gwb_
 * @author Junpee
 */

#ifndef VIEWPORT_SPRITE_STATE_H_
#define VIEWPORT_SPRITE_STATE_H_

#include "Graphics2D/SpriteState/SpriteState.h"

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * r[|[gXvCgXe[g
 */
class ViewportSpriteState : public SpriteState{
public:
	//--------------------------------------------------------------------------
	// ev[gXe[g
	//--------------------------------------------------------------------------
	/// 
	static const ViewportSpriteState disableState;

	/// ftHg
	static const ViewportSpriteState defaultState;

	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	ViewportSpriteState();

	/**
	 * RXgN^
	 * @param rectangle `
	 */
	ViewportSpriteState(const RectangleI& rectangle);

	/**
	 * fXgN^
	 */
	virtual ~ViewportSpriteState();

	//--------------------------------------------------------------------------
	// ftHgXe[g
	//--------------------------------------------------------------------------
	/**
	 * ftHgXe[g̎擾
	 * @return ftHgXe[g
	 */
	virtual const SpriteRequest* getDefaultState() const{
		return &defaultState;
	}

	//--------------------------------------------------------------------------
	// `
	//--------------------------------------------------------------------------
	/**
	 * Kp
	 * @param renderState _[Xe[g
	 */
	virtual void apply(SpriteRenderState* renderState);

	//--------------------------------------------------------------------------
	// Nbv
	//--------------------------------------------------------------------------
	/**
	 * `̐ݒ
	 * @param rectangle ݒ肷`
	 */
	virtual void setRectangle(const RectangleI& rectangle){
		rectangle_ = rectangle;
	}

	/**
	 * `̐ݒ
	 * @param position ݒ肷`̈ʒu
	 * @param size ݒ肷`̃TCY
	 */
	virtual void setRectangle(
		const Point2i& position, const DimensionI& size){
		rectangle_.set(position.x, position.y, size.width, size.height);
	}

	/**
	 * `̐ݒ
	 * @param x ݒ肷`Xʒu
	 * @param y ݒ肷`Yʒu
	 * @param width ݒ肷`̕
	 * @param height ݒ肷`̍
	 */
	virtual void setRectangle(int x, int y, int width, int height){
		rectangle_.set(x, y, width, height);
	}

	/**
	 * `̎擾
	 * @return `
	 */
	virtual const RectangleI& getRectangle() const{
		return rectangle_;
	}

	/**
	 * NbvL
	 * @return NbvLȂtrue
	 */
	virtual bool isEnabled() const{
		return (rectangle_ != RectangleI::zero);
	}

	//--------------------------------------------------------------------------
	/**
	 * Nbvʒu̐ݒ
	 * @param position ݒ肷Nbvʒu
	 */
	virtual void setPosition(const Point2i& position){
		rectangle_.x = position.x;
		rectangle_.y = position.y;
	}

	/**
	 * Nbvʒu̐ݒ
	 * @param x XNbvʒu
	 * @param y YNbvʒu
	 */
	virtual void setPosition(int x, int y){
		rectangle_.x = x;
		rectangle_.y = y;
	}

	/**
	 * Nbvʒu̎擾
	 * @return Nbvʒu
	 */
	virtual Point2i getPosition() const{
		return Point2i(rectangle_.x, rectangle_.y);
	}

	//--------------------------------------------------------------------------
	/**
	 * TCY̐ݒ
	 * @param size ݒ肷TCY
	 */
	virtual void setSize(const DimensionI& size){
		rectangle_.width = size.width;
		rectangle_.height = size.height;
	}

	/**
	 * TCY̐ݒ
	 * @param width 
	 * @param height 
	 */
	virtual void setSize(int width, int height){
		rectangle_.width = width;
		rectangle_.height = height;
	}

	/**
	 * TCY̎擾
	 * @return TCY
	 */
	virtual DimensionI getSize() const{
		return DimensionI(rectangle_.width, rectangle_.height);
	}

private:
	//--------------------------------------------------------------------------
	// `
	RectangleI rectangle_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of VIEWPORT_SPRITE_STATE_H_
//------------------------------------------------------------------------------
