//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * XvCgXe[gubNwb_
 * @author Junpee
 */

#ifndef SPRITE_STATE_BLOCK_H_
#define SPRITE_STATE_BLOCK_H_

#include <Core/Container/ArrayList.h>

namespace Lamp{

class SpriteRenderer;
class SpriteState;

//------------------------------------------------------------------------------
/**
 * XvCgXe[gubN
 */
class SpriteStateBlock{
public:
	/**
	 * RXgN^
	 * @param spriteRenderer XvCg_
	 * @param priority Dx
	 */
	SpriteStateBlock(SpriteRenderer* spriteRenderer, int priority);

	/**
	 * RXgN^
	 * @param spriteRenderer XvCg_
	 */
	SpriteStateBlock(SpriteRenderer* spriteRenderer);

	/**
	 * Xe[g̒ǉ
	 * @param spriteState XvCgXe[g
	 */
	virtual void addState(const SpriteState* spriteState);

	/**
	 * fXgN^
	 */
	virtual ~SpriteStateBlock();

private:
	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	SpriteStateBlock(const SpriteStateBlock& copy);

	// Rs[̉B
	void operator =(const SpriteStateBlock& copy);

	// XvCg_
	SpriteRenderer* spriteRenderer_;
	// XvCgXe[g
	ArrayList<const SpriteState*> states_;
	// Dx
	int priority_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SPRITE_STATE_BLOCK_H_
//------------------------------------------------------------------------------
