//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * FXvCgXe[gwb_
 * @author Junpee
 */

#ifndef COLOR_SPRITE_STATE_H_
#define COLOR_SPRITE_STATE_H_

#include "Graphics2D/SpriteState/SpriteState.h"

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * FXvCgXe[g
 */
class ColorSpriteState : public SpriteState{
public:
	//--------------------------------------------------------------------------
	// ev[gXe[g
	//--------------------------------------------------------------------------
	/// 
	static const ColorSpriteState whiteState;

	/// DF
	static const ColorSpriteState grayState;

	/// 
	static const ColorSpriteState blackState;

	/// 
	static const ColorSpriteState redState;

	/// 
	static const ColorSpriteState greenState;

	/// 
	static const ColorSpriteState blueState;

	/// 
	static const ColorSpriteState yellowState;

	/// 
	static const ColorSpriteState cyanState;

	/// Ԏ
	static const ColorSpriteState magentaState;

	/// ftHg
	static const ColorSpriteState defaultState;

	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	ColorSpriteState();

	/**
	 * RXgN^
	 * @param color F
	 */
	ColorSpriteState(const Color4f& color);

	/**
	 * fXgN^
	 */
	virtual ~ColorSpriteState();

	//--------------------------------------------------------------------------
	// ftHgXe[g
	//--------------------------------------------------------------------------
	/**
	 * ftHgXe[g̎擾
	 * @return ftHgXe[g
	 */
	virtual const SpriteRequest* getDefaultState() const{
		return &defaultState;
	}

	//--------------------------------------------------------------------------
	// `
	//--------------------------------------------------------------------------
	/**
	 * Kp
	 * @param renderState _[Xe[g
	 */
	virtual void apply(SpriteRenderState* renderState);

	//--------------------------------------------------------------------------
	// F
	//--------------------------------------------------------------------------
	/**
	 * F̐ݒ
	 * @param color F
	 */
	virtual void setColor(const Color4f& color){ color_ = color; }

	/**
	 * F̎擾
	 * @return F
	 */
	virtual const Color4f& getColor() const{ return color_; }

private:
	//--------------------------------------------------------------------------
	// F
	Color4f color_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of COLOR_SPRITE_STATE_H_
//------------------------------------------------------------------------------
