//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * uhXvCgXe[gwb_
 * @author Junpee
 */

#ifndef BLEND_SPRITE_STATE_H_
#define BLEND_SPRITE_STATE_H_

#include "Graphics2D/SpriteState/SpriteState.h"

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * uhXvCgXe[g
 */
class BlendSpriteState : public SpriteState{
public:
	//--------------------------------------------------------------------------
	// ev[gXe[g
	//--------------------------------------------------------------------------
	/// 
	static const BlendSpriteState translucent;

	/// Z
	static const BlendSpriteState addState;

	/// ftHg
	static const BlendSpriteState defaultState;

	//--------------------------------------------------------------------------
	// uh[h
	//--------------------------------------------------------------------------
	/// uh[h
	enum BlendMode{
		blendModeDisable = 0,
		blendModeAdd,
		blendModeSubtract,
		blendModeInverseSubtract,
		blendModeMinimum,
		blendModeMaximum,
		blendModeMax,
	};

	/**
	 * uh[h當ւ̕ϊ
	 * @param blendMode uh[h
	 * @return uh[h
	 */
	static const String& blendModeToString(BlendMode blendMode);

	/**
	 * 񂩂uh[hւ̕ϊ
	 * @param blendModeString uh[h
	 * @return uh[h
	 */
	static BlendMode blendModeFromString(const String& blendModeString);

	//--------------------------------------------------------------------------
	// uhXe[g
	//--------------------------------------------------------------------------
	/// uhXe[g
	enum BlendState{
		blendStateZero = 0,
		blendStateOne,
		blendStateSourceColor,
		blendStateInverseSourceColor,
		blendStateSourceAlpha,
		blendStateInverseSourceAlpha,
		blendStateSourceAlphaSaturate,
		blendStateDestinationColor,
		blendStateInverseDestinationColor,
		blendStateDestinationAlpha,
		blendStateInverseDestinationAlpha,
		blendStateMax,
	};

	/**
	 * uhXe[g當ւ̕ϊ
	 * @param blendState uhXe[g
	 * @return uhXe[g
	 */
	static const String& blendStateToString(BlendState blendState);

	/**
	 * 񂩂uhXe[gւ̕ϊ
	 * @param blendStateString uhXe[g
	 * @return uhXe[g
	 */
	static BlendState blendStateFromString(const String& blendStateString);

	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	BlendSpriteState();

	/**
	 * RXgN^
	 * @param blendMode uh[h
	 * @param blendSource uh\[X
	 * @param blendDestination uhfXeBl[V
	 */
	BlendSpriteState(BlendMode blendMode,
		BlendState blendSource, BlendState blendDestination);

	/**
	 * fXgN^
	 */
	virtual ~BlendSpriteState();

	//--------------------------------------------------------------------------
	// ftHgXe[g
	//--------------------------------------------------------------------------
	/**
	 * ftHgXe[g̎擾
	 * @return ftHgXe[g
	 */
	virtual const SpriteRequest* getDefaultState() const{
		return &defaultState;
	}

	//--------------------------------------------------------------------------
	// `
	//--------------------------------------------------------------------------
	/**
	 * Kp
	 * @param renderState _[Xe[g
	 */
	virtual void apply(SpriteRenderState* renderState);

	//--------------------------------------------------------------------------
	// uh
	//--------------------------------------------------------------------------
	/**
	 * uh[h̐ݒ
	 * @param blendMode uh[h
	 */
	virtual void setBlendMode(BlendMode blendMode){
		Assert((blendMode >= 0) && (blendMode < blendModeMax));
		blendMode_ = blendMode;
	}

	/**
	 * uh[h̎擾
	 * @return uh[h
	 */
	virtual BlendMode getBlendMode() const{ return blendMode_; }

	/**
	 * uhL
	 * @return uhLȂtrue
	 */
	virtual bool isBlendEnabled() const{
		return (blendMode_ != blendModeDisable);
	}

	//--------------------------------------------------------------------------
	/**
	 * uh\[X̐ݒ
	 * @param blendSource uh\[X
	 */
	virtual void setBlendSource(BlendState blendSource){
		Assert((blendSource >= 0) && (blendSource < blendStateMax));
		blendSource_ = blendSource;
	}

	/**
	 * uh\[X̎擾
	 * @return uh\[X
	 */
	virtual BlendState getBlendSource() const{ return blendSource_; }

	//--------------------------------------------------------------------------
	/**
	 * uhfXeBl[V̐ݒ
	 * @param blendDestination uhfXeBl[V
	 */
	virtual void setBlendDestination(BlendState blendDestination){
		Assert((blendDestination >= 0) && (blendDestination < blendStateMax));
		blendDestination_ = blendDestination;
	}

	/**
	 * uhfXeBl[V̎擾
	 * @return uhfXeBl[V
	 */
	virtual BlendState getBlendDestination() const{ return blendDestination_; }

private:
	//--------------------------------------------------------------------------
	// uh[h
	BlendMode blendMode_;
	// uh\[X
	BlendState blendSource_;
	// uhfXeBl[V
	BlendState blendDestination_;

	// uh[he[u
	static const String blendModeStringTable[];
	// uhXe[ge[u
	static const String blendStateStringTable[];

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of BLEND_SPRITE_STATE_H_
//------------------------------------------------------------------------------
