//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * AhX[hXvCgXe[gwb_
 * @author Junpee
 */

#ifndef ADDRESS_MODE_SPRITE_STATE_H_
#define ADDRESS_MODE_SPRITE_STATE_H_

#include "Graphics2D/SpriteState/SpriteState.h"

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * AhX[hXvCgXe[g
 */
class AddressModeSpriteState : public SpriteState{
public:
	//--------------------------------------------------------------------------
	// ev[gXe[g
	//--------------------------------------------------------------------------
	/// Nv
	static const AddressModeSpriteState clampState;

	/// bv
	static const AddressModeSpriteState wrapState;

	/// ~[
	static const AddressModeSpriteState mirrorState;

	/// ftHg
	static const AddressModeSpriteState defaultState;

	//--------------------------------------------------------------------------
	// AhX[h
	//--------------------------------------------------------------------------
	/// AhX[h
	enum AddressMode{
		addressModeWrap = 0,
		addressModeClamp,
		addressModeMirror,
		addressModeMax,
	};

	/**
	 * AhX[h當ւ̕ϊ
	 * @param addressMode AhX[h
	 * @return AhX[h
	 */
	static const String& addressModeToString(AddressMode addressMode);

	/**
	 * 񂩂AhX[hւ̕ϊ
	 * @param addressModeString AhX[h
	 * @return AhX[h
	 */
	static AddressMode addressModeFromString(const String& addressModeString);

	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	AddressModeSpriteState();

	/**
	 * RXgN^
	 * @param addressModeU AhX[hU
	 * @param addressModeV AhX[hV
	 */
	AddressModeSpriteState(AddressMode addressModeU, AddressMode addressModeV);

	/**
	 * fXgN^
	 */
	virtual ~AddressModeSpriteState();

	//--------------------------------------------------------------------------
	// ftHgXe[g
	//--------------------------------------------------------------------------
	/**
	 * ftHgXe[g̎擾
	 * @return ftHgXe[g
	 */
	virtual const SpriteRequest* getDefaultState() const{
		return &defaultState;
	}

	//--------------------------------------------------------------------------
	// `
	//--------------------------------------------------------------------------
	/**
	 * Kp
	 * @param renderState _[Xe[g
	 */
	virtual void apply(SpriteRenderState* renderState);

	//--------------------------------------------------------------------------
	// AhX
	//--------------------------------------------------------------------------
	/**
	 * AhX[h̐ݒ
	 * @param addressModeU AhX[hU
	 * @param addressModeV AhX[hV
	 */
	virtual void setAddressMode(
		AddressMode addressModeU, AddressMode addressModeV){
		Assert((addressModeU >= 0) && (addressModeU < addressModeMax));
		Assert((addressModeV >= 0) && (addressModeV < addressModeMax));
		addressModeU_ = addressModeU;
		addressModeV_ = addressModeV;
	}

	//--------------------------------------------------------------------------
	/**
	 * AhX[hU̐ݒ
	 * @param addressModeU AhX[hU
	 */
	virtual void setAddressModeU(AddressMode addressModeU){
		Assert((addressModeU >= 0) && (addressModeU < addressModeMax));
		addressModeU_ = addressModeU;
	}

	/**
	 * AhX[hU̎擾
	 * @return AhX[hU
	 */
	virtual AddressMode getAddressModeU() const{ return addressModeU_; }

	//--------------------------------------------------------------------------
	/**
	 * AhX[hV̐ݒ
	 * @param addressModeV AhX[hV
	 */
	virtual void setAddressModeV(AddressMode addressModeV){
		Assert((addressModeV >= 0) && (addressModeV < addressModeMax));
		addressModeV_ = addressModeV;
	}

	/**
	 * AhX[hV̎擾
	 * @return AhX[hV
	 */
	virtual AddressMode getAddressModeV() const{ return addressModeV_; }

private:
	//--------------------------------------------------------------------------
	// AhX[hU
	AddressMode addressModeU_;
	// AhX[hV
	AddressMode addressModeV_;

	// AhX[he[u
	static const String addressModeStringTable[];

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of ADDRESS_MODE_SPRITE_STATE_H_
//------------------------------------------------------------------------------
