//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * XvCgsN`RGB8wb_
 * @author Junpee
 */

#ifndef SPRITE_PICTURE_RGB8_H_
#define SPRITE_PICTURE_RGB8_H_

#include <Graphics2D/Sprite/SpritePicture.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * XvCgsN`RGB8
 */
class SpritePictureRGB8 : public SpritePicture{
public:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	SpritePictureRGB8();

	/**
	 * fXgN^
	 */
	virtual ~SpritePictureRGB8();

	//--------------------------------------------------------------------------
	// TCY
	//--------------------------------------------------------------------------
	/**
	 * TCY̐ݒ
	 * @param size TCY
	 */
	virtual void setSize(const DimensionI& size);

	//--------------------------------------------------------------------------
	// C[W
	//--------------------------------------------------------------------------
	/**
	 * C[Wobt@̎擾
	 * @return C[Wobt@
	 */
	virtual Color3c* getImageBuffer(){ return image_; }

protected:
	//--------------------------------------------------------------------------
	// Direct3DeNX`
	//--------------------------------------------------------------------------
	/**
	 * D3DeNX`̃RpC
	 * @return trueԂ
	 */
	virtual bool compileD3DTexture();

	/**
	 * C[W̃RpC
	 */
	virtual bool compileImage(
		const Color3c* image, const DimensionI& size, int mipmapLevel);

	/**
	 * ~bv}bṽRpC
	 */
	virtual bool compileMipmap(
		const Color3c* image, const DimensionI& size, int mipmapLevel);

private:
	//--------------------------------------------------------------------------
	// C[W
	Color3c* image_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SPRITE_PICTURE_RGB8_H_
//------------------------------------------------------------------------------
