//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * XvCgsN`wb_
 * @author Junpee
 */

#ifndef SPRITE_PICTURE_H_
#define SPRITE_PICTURE_H_

#include <Graphics/System/GraphicsDeviceObjectHolder.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * XvCgsN`
 */
class SpritePicture : public GraphicsDeviceObjectHolder{
friend class SpriteRenderState;
friend class Sprite;
public:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	SpritePicture();

	/**
	 * fXgN^
	 */
	virtual ~SpritePicture();

	//--------------------------------------------------------------------------
	// TCY
	//--------------------------------------------------------------------------
	/**
	 * TCY̐ݒ
	 * @param size TCY
	 */
	virtual void setSize(const DimensionI& size){
		Assert((size.width > 0) && (size.height > 0));
		size_ = size;
	}

	/**
	 * TCY̎擾
	 * @return TCY
	 */
	virtual const DimensionI& getSize() const{ return size_; }

	//--------------------------------------------------------------------------
	// QƃJE^
	//--------------------------------------------------------------------------
	/**
	 * QƃJEg̎擾
	 */
	virtual int getReferenceCount() const{ return referenceCount_; }

	//--------------------------------------------------------------------------
	// OtBbNfoCXIuWFNg
	//--------------------------------------------------------------------------
	/**
	 * foCXIuWFNg̏
	 * @return trueԂ
	 */
	virtual bool initializeGraphicsDeviceObjects(){ return true; }

	/**
	 * foCXIuWFNg̍폜
	 */
	virtual void deleteGraphicsDeviceObjects(){ SafeRelease(d3dTexture_); }

	/**
	 * foCXIuWFNg̃XgA
	 * @return trueԂ
	 */
	virtual bool restoreGraphicsDeviceObjects(){ return true; }

	/**
	 * foCXIuWFNg̖
	 */
	virtual void invalidateGraphicsDeviceObjects(){}

protected:
	//--------------------------------------------------------------------------
	// Direct3DeNX`
	//--------------------------------------------------------------------------
	/**
	 * D3DeNX`̎擾
	 * @return D3DeNX`̎擾
	 */
	virtual Direct3DTexture* getD3DTexture();

	/**
	 * D3DeNX`̐ݒ
	 * @param d3dTexture D3DeNX`
	 */
	virtual void setD3DTexture(Direct3DTexture* d3dTexture){
		SafeRelease(d3dTexture_);
		d3dTexture_ = d3dTexture;
	}

	/**
	 * D3DeNX`̃RpC
	 * @return trueԂ
	 */
	virtual bool compileD3DTexture() = 0;

	//--------------------------------------------------------------------------
	// QƃJE^
	//--------------------------------------------------------------------------
	/**
	 * QƂ̒ǉ
	 * @return QƃJEg
	 */
	virtual int addReference(){
		referenceCount_++;
		return referenceCount_;
	}

	/**
	 * QƂ̍폜
	 * @return QƃJEg
	 */
	virtual int removeReference(){
		referenceCount_--;
		Assert(referenceCount_ >= 0);
		return referenceCount_;
	}

private:
	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	SpritePicture(const SpritePicture& copy);

	// Rs[̉B
	void operator =(const SpritePicture& copy);

	//--------------------------------------------------------------------------
	// TCY
	DimensionI size_;
	// Direct3DeNX`
	Direct3DTexture* d3dTexture_;
	// QƃJEg
	int referenceCount_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SPRITE_PICTURE_H_
//------------------------------------------------------------------------------
