//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * XvCgwb_
 * @author Junpee
 */

#ifndef SPRITE_H_
#define SPRITE_H_

#include <Graphics2D/Renderer/SpriteRequest.h>

namespace Lamp{

class SpritePicture;

//------------------------------------------------------------------------------
/**
 * XvCg
 */
class Sprite : public SpriteRequest{
public:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	Sprite();

	/**
	 * Rs[RXgN^
	 * @param copy Rs[
	 */
	explicit Sprite(const Sprite& copy);

	/**
	 * Rs[
	 * @param copy Rs[
	 */
	Sprite& operator =(const Sprite& copy);

	/**
	 * fXgN^
	 */
	virtual ~Sprite();

	//--------------------------------------------------------------------------
	// _O
	//--------------------------------------------------------------------------
	/**
	 * _O
	 * @param renderState _[Xe[g
	 */
	virtual void render(SpriteRenderState* renderState);

	//--------------------------------------------------------------------------
	// sN`
	//--------------------------------------------------------------------------
	/**
	 * sN`̃[h
	 * @param fileName t@C
	 * @return true
	 */
	virtual bool loadPicture(const String& fileName);

	/**
	 * sN`̐ݒ
	 * @param picture sN`
	 */
	virtual void setPicture(SpritePicture* picture);

	/**
	 * sN`̎擾
	 * @return sN`
	 */
	virtual SpritePicture* getPicture(){ return picture_; }

	//--------------------------------------------------------------------------
	// `
	//--------------------------------------------------------------------------
	/**
	 * `̐ݒ
	 * @param rectangle ݒ肷`
	 */
	virtual void setRectangle(const RectangleF& rectangle){
		rectangle_ = rectangle;
	}

	/**
	 * `̐ݒ
	 * @param position ݒ肷`̈ʒu
	 * @param size ݒ肷`̃TCY
	 */
	virtual void setRectangle(const Point2f& position, const DimensionF& size){
		rectangle_.set(position.x, position.y, size.width, size.height);
	}

	/**
	 * `̐ݒ
	 * @param x ݒ肷`Xʒu
	 * @param y ݒ肷`Yʒu
	 * @param width ݒ肷`̕
	 * @param height ݒ肷`̍
	 */
	virtual void setRectangle(float x, float y, float width, float height){
		rectangle_.set(x, y, width, height);
	}

	/**
	 * `̎擾
	 * @return `
	 */
	virtual const RectangleF& getRectangle() const{ return rectangle_; }

	//--------------------------------------------------------------------------
	/**
	 * ʒu̐ݒ
	 * @param position ݒ肷ʒu
	 */
	virtual void setPosition(const Point2f& position){
		rectangle_.x = position.x;
		rectangle_.y = position.y;
	}

	/**
	 * ʒu̐ݒ
	 * @param x Xʒu
	 * @param y Yʒu
	 */
	virtual void setPosition(float x, float y){
		rectangle_.x = x;
		rectangle_.y = y;
	}

	/**
	 * ʒu̎擾
	 * @return ʒu
	 */
	virtual Point2f getPosition() const{
		return Point2f(rectangle_.x, rectangle_.y);
	}

	//--------------------------------------------------------------------------
	/**
	 * TCY̐ݒ
	 * @param size ݒ肷TCY
	 */
	virtual void setSize(const DimensionF& size){
		rectangle_.width = size.width;
		rectangle_.height = size.height;
	}

	/**
	 * TCY̐ݒ
	 * @param width 
	 * @param height 
	 */
	virtual void setSize(float width, float height){
		rectangle_.width = width;
		rectangle_.height = height;
	}

	/**
	 * TCY̎擾
	 * @return TCY
	 */
	virtual DimensionF getSize() const{
		return DimensionF(rectangle_.width, rectangle_.height);
	}

	//--------------------------------------------------------------------------
	// C[W`
	//--------------------------------------------------------------------------
	/**
	 * C[W`̐ݒ
	 * @param imageRectangle ݒ肷C[W`
	 */
	virtual void setImageRectangle(const RectangleF& imageRectangle){
		imageRectangle_ = imageRectangle;
	}

	/**
	 * C[W`̐ݒ
	 * @param position ݒ肷C[W`̈ʒu
	 * @param size ݒ肷C[W`̃TCY
	 */
	virtual void setImageRectangle(
		const Point2f& position, const DimensionF& size){
		imageRectangle_.set(position.x, position.y, size.width, size.height);
	}

	/**
	 * C[W`̐ݒ
	 * @param x ݒ肷C[W`Xʒu
	 * @param y ݒ肷C[W`Yʒu
	 * @param width ݒ肷C[W`̕
	 * @param height ݒ肷C[W`̍
	 */
	virtual void setImageRectangle(
		float x, float y, float width, float height){
		imageRectangle_.set(x, y, width, height);
	}

	/**
	 * C[W`̎擾
	 * @return C[W`
	 */
	virtual const RectangleF& getImageRectangle() const{
		return imageRectangle_;
	}

	//--------------------------------------------------------------------------
	/**
	 * C[Wʒu̐ݒ
	 * @param position ݒ肷C[Wʒu
	 */
	virtual void setImagePosition(const Point2f& position){
		imageRectangle_.x = position.x;
		imageRectangle_.y = position.y;
	}

	/**
	 * C[Wʒu̐ݒ
	 * @param x XC[Wʒu
	 * @param y YC[Wʒu
	 */
	virtual void setImagePosition(float x, float y){
		imageRectangle_.x = x;
		imageRectangle_.y = y;
	}

	/**
	 * C[Wʒu̎擾
	 * @return C[Wʒu
	 */
	virtual Point2f getImagePosition() const{
		return Point2f(imageRectangle_.x, imageRectangle_.y);
	}

	//--------------------------------------------------------------------------
	/**
	 * C[WTCY̐ݒ
	 * @param size ݒ肷C[WTCY
	 */
	virtual void setImageSize(const DimensionF& size){
		imageRectangle_.width = size.width;
		imageRectangle_.height = size.height;
	}

	/**
	 * C[WTCY̐ݒ
	 * @param width C[W
	 * @param height C[W
	 */
	virtual void setImageSize(float width, float height){
		imageRectangle_.width = width;
		imageRectangle_.height = height;
	}

	/**
	 * C[WTCY̎擾
	 * @return C[WTCY
	 */
	virtual DimensionF getImageSize() const{
		return DimensionF(imageRectangle_.width, imageRectangle_.height);
	}

	//--------------------------------------------------------------------------
	/**
	 * Aj[V̐ݒ
	 * @param animationDivision Aj[V
	 * @param animation Aj[V
	 * @param imageRectangle C[W`
	 */
	virtual void setAnimation(const DimensionI& animationDivision,
		int animation, const RectangleF& imageRectangle = RectangleF::unit);

	//--------------------------------------------------------------------------
	// AC
	//--------------------------------------------------------------------------
	/// AC
	enum Align{
		alignNone = 0,
		alignTopLeft,
		alignTop,
		alignTopRight,
		alignLeft,
		alignCenter,
		alignRight,
		alignBottomLeft,
		alignBottom,
		alignBottomRight,
		alignMax,
	};

	/**
	 * AC̐ݒ
	 * @param align AC
	 */
	virtual void setAlign(Align align){
		Assert((align >= 0) && (align < alignMax));
		align_ = align;
	}

	/**
	 * AC̎擾
	 * @return AC
	 */
	virtual Align getAlign() const{ return align_; }

	//--------------------------------------------------------------------------
	// tBbg
	//--------------------------------------------------------------------------
	/// tBbg
	enum Fit{
		fitNone = 0,
		fitScreen,
		fitScreenWidth,
		fitScreenHeight,
		fitMax,
	};

	/**
	 * tBbg̐ݒ
	 * @param fit tBbg
	 */
	virtual void setFit(Fit fit){
		Assert((fit >= 0) && (fit < fitMax));
		fit_ = fit;
	}

	/**
	 * tBbg̎擾
	 * @return tBbg
	 */
	virtual Fit getFit() const{ return fit_; }

	//--------------------------------------------------------------------------
	// LA
	//--------------------------------------------------------------------------
	/**
	 * LA̐ݒ
	 * @param enabled trueȂLAfalseȂ疳
	 */
	virtual void setEnabled(bool enabled){ enabled_ = enabled; }

	/**
	 * LA̎擾
	 * @return trueȂLAfalseȂ疳
	 */
	virtual bool isEnabled() const{ return enabled_; }

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * XvCgǂ
	 * @return XvCgȂtrue
	 */
	virtual bool isSprite() const{ return true; }

protected:
	//--------------------------------------------------------------------------
	// _O
	//--------------------------------------------------------------------------
	/**
	 * tBbg̓Kp
	 * @param rectangle `
	 * @param renderTargetSize _[^[QbgTCY
	 * @return `
	 */
	virtual RectangleF applyFit(const RectangleF& rectangle,
		const DimensionF& renderTargetSize);

	/**
	 * AC̓Kp
	 * @param rectangle `
	 * @param renderTargetSize _[^[QbgTCY
	 * @return `
	 */
	virtual RectangleF applyAlign(const RectangleF& rectangle,
		const DimensionF& renderTargetSize);

private:
	//--------------------------------------------------------------------------
	// sN`
	SpritePicture* picture_;
	// `
	RectangleF rectangle_;
	// C[W`
	RectangleF imageRectangle_;
	// AC
	Align align_;
	// tBbg
	Fit fit_;
	// LA
	bool enabled_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SPRITE_H_
//------------------------------------------------------------------------------
