//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * XvCgNGXgwb_
 * @author Junpee
 */

#ifndef SPRITE_REQUEST_H_
#define SPRITE_REQUEST_H_

namespace Lamp{

class Sprite;
class SpriteState;
class SpriteRenderState;

//------------------------------------------------------------------------------
/**
 * XvCgNGXg
 */
class SpriteRequest{
public:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	SpriteRequest(){}

	/**
	 * fXgN^
	 */
	virtual ~SpriteRequest(){}

	//--------------------------------------------------------------------------
	// _O
	//--------------------------------------------------------------------------
	/**
	 * _O
	 * @param renderState _[Xe[g
	 */
	virtual void render(SpriteRenderState* renderState) = 0;

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * XvCgǂ
	 * @return XvCgȂtrue
	 */
	virtual bool isSprite() const{ return false; }

	/**
	 * XvCgւ̃LXg
	 * @return XvCgB^ႦNULLԂB
	 */
	virtual Sprite* castSprite() const{
		if(isSprite()){ return (Sprite*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * XvCgXe[gǂ
	 * @return XvCgXe[gȂtrue
	 */
	virtual bool isSpriteState() const{ return false; }

	/**
	 * XvCgXe[gւ̃LXg
	 * @return XvCgXe[gB^ႦNULLԂB
	 */
	virtual SpriteState* castSpriteState() const{
		if(isSpriteState()){ return (SpriteState*)this; }
		return NULL;
	}

private:
	//--------------------------------------------------------------------------

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SPRITE_REQUEST_H_
//------------------------------------------------------------------------------

