//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * XvCg_wb_
 * @author Junpee
 */

#ifndef SPRITE_RENDERER_H_
#define SPRITE_RENDERER_H_

#include <Core/Container/ArrayList.h>

namespace Lamp{

class SpriteRequest;
class SpriteRenderState;
class SpriteGraphicsBuffer;

//------------------------------------------------------------------------------
/**
 * XvCg_
 */
class SpriteRenderer{
public:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param maxPriority őDx
	 * @param defaultPriority ftHgDx
	 */
	SpriteRenderer(int maxPriority = 16, int defaultPriority = 8);

	/**
	 * fXgN^
	 */
	virtual ~SpriteRenderer();

	//--------------------------------------------------------------------------
	// NGXg
	//--------------------------------------------------------------------------
	/**
	 * NGXg
	 * @param spriteRequest XvCgNGXg
	 */
	virtual void request(SpriteRequest* spriteRequest){
		request(spriteRequest, defaultPriority_);
	}

	/**
	 * NGXg
	 * @param spriteRequest XvCgNGXg
	 * @param priority Dx
	 */
	virtual void request(SpriteRequest* spriteRequest, int priority);

	//--------------------------------------------------------------------------
	/**
	 * NGXg
	 * @param spriteRequest XvCgNGXg
	 */
	virtual void request(const SpriteRequest* spriteRequest){
		// C^[tF[XōœKs߂const͂
		// O̕ϐ̂̓_OɂȂ
		request((SpriteRequest*)spriteRequest);
	}

	/**
	 * NGXg
	 * @param spriteRequest XvCgNGXg
	 * @param priority Dx
	 */
	virtual void request(const SpriteRequest* spriteRequest, int priority){
		// C^[tF[XōœKs߂const͂
		// O̕ϐ̂̓_OɂȂ
		request((SpriteRequest*)spriteRequest, priority);
	}

	//--------------------------------------------------------------------------
	/**
	 * ftHgXe[g̃NGXg
	 */
	virtual void requestDefaultState(){ requestDefaultState(defaultPriority_); }

	/**
	 * ftHgXe[g̃NGXg
	 * @param priority Dx
	 */
	virtual void requestDefaultState(int priority);

	//--------------------------------------------------------------------------
	// _O
	//--------------------------------------------------------------------------
	/**
	 * _O
	 */
	virtual void render(){ render(0, (maxPriority_ - 1)); }

	/**
	 * _O
	 * @param startPriority JnDx
	 * @param endPriority IDx
	 */
	virtual void render(int startPriority, int endPriority);

	//--------------------------------------------------------------------------
	// Dx
	//--------------------------------------------------------------------------
	/**
	 * őDx̎擾
	 */
	virtual int getMaxPriority() const{ return maxPriority_; }

	/**
	 * ftHgDx̐ݒ
	 * @param defaultPriority ftHgDx
	 */
	virtual void setDefaultPriority(int defaultPriority){
		Assert((defaultPriority >= 0) && (defaultPriority < maxPriority_));
		defaultPriority_ = defaultPriority;
	}

	/**
	 * ftHgDx̎擾
	 * @return ftHgDx
	 */
	virtual int getDefaultPriority() const{ return defaultPriority_; }

protected:
	//--------------------------------------------------------------------------
	/**
	 * ftHgXe[g̓Kp
	 */
	virtual void applyDefaultState(SpriteRenderState* renderState);

	/**
	 * _Xe[g̓Kp
	 */
	virtual void applyRendererState();

private:
	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	SpriteRenderer(const SpriteRenderer& copy);

	// Rs[̉B
	void operator =(const SpriteRenderer& copy);

	//--------------------------------------------------------------------------
	// NGXg
	ArrayList<SpriteRequest*>* requests_;
	// OtBbNXobt@
	SpriteGraphicsBuffer* graphicsBuffer_;
	// őDx
	int maxPriority_;
	// ftHgDx
	int defaultPriority_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SPRITE_RENDERER_H_
//------------------------------------------------------------------------------
