//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * XvCg_[Xe[gwb_
 * @author Junpee
 */

#ifndef SPRITE_RENDER_STATE_H_
#define SPRITE_RENDER_STATE_H_

namespace Lamp{

class SpriteGraphicsBuffer;
class SpritePicture;

//------------------------------------------------------------------------------
/**
 * XvCg_[Xe[g
 */
class SpriteRenderState{
friend class SpriteRenderer;
public:
	//--------------------------------------------------------------------------
	// `
	//--------------------------------------------------------------------------
	/**
	 * NGXg
	 * @param picture sN`
	 * @param minPosition ŏʒu
	 * @param maxPosition őʒu
	 * @param minUV ŏUV
	 * @param maxUV őUV
	 */
	virtual void request(SpritePicture* picture,
		const Point2f& minPosition, const Point2f& maxPosition,
		const TexCoord2& minUV, const TexCoord2& maxUV);

	/**
	 * _O
	 */
	virtual void render();

	/**
	 * _[^[QbgTCY̎擾
	 * @return _[^[QbgTCY
	 */
	virtual const DimensionF& getRenderTargetSize(){
		return renderTargetSize_;
	}
protected:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	SpriteRenderState(SpriteGraphicsBuffer* graphicsBuffer);

	/**
	 * fXgN^
	 */
	virtual ~SpriteRenderState();

private:
	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	SpriteRenderState(const SpriteRenderState& copy);

	// Rs[̉B
	void operator =(const SpriteRenderState& copy);

	// OtBbNXobt@
	SpriteGraphicsBuffer* graphicsBuffer_;
	// sN`
	SpritePicture* picture_;
	// _[^[QbgTCY
	DimensionF renderTargetSize_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SPRITE_RENDER_STATE_H_
//------------------------------------------------------------------------------

