//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * XvCgOtBbNXobt@wb_
 * @author Junpee
 */

#ifndef SPRITE_GRAPHICS_BUFFER_H_
#define SPRITE_GRAPHICS_BUFFER_H_

#include <Graphics/System/GraphicsDeviceObjectHolder.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * XvCgOtBbNXobt@
 */
class SpriteGraphicsBuffer : public GraphicsDeviceObjectHolder{
friend class SpriteRenderer;
public:
	//--------------------------------------------------------------------------
	// `
	//--------------------------------------------------------------------------
	/**
	 * NGXg
	 * @param minPosition ŏʒu
	 * @param maxPosition őʒu
	 * @param minUV ŏUV
	 * @param maxUV őUV
	 */
	virtual void request(
		const Point2f& minPosition, const Point2f& maxPosition,
		const TexCoord2& minUV, const TexCoord2& maxUV);

	/**
	 * _O
	 */
	virtual void render();

	//--------------------------------------------------------------------------
	// foCXIuWFNg
	//--------------------------------------------------------------------------
	/**
	 * foCXIuWFNg̏
	 * @return trueԂ
	 */
	virtual bool initializeGraphicsDeviceObjects(){ return true; }

	/**
	 * foCXIuWFNg̍폜
	 */
	virtual void deleteGraphicsDeviceObjects(){}

	/**
	 * foCXIuWFNg̃XgA
	 * @return trueԂ
	 */
	virtual bool restoreGraphicsDeviceObjects(){ return true; }

	/**
	 * foCXIuWFNg̖
	 */
	virtual void invalidateGraphicsDeviceObjects(){
		SafeRelease(vertexDeclaration_);
		SafeRelease(vertexBuffer_);
		SafeRelease(indexBuffer_);
	}

protected:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	SpriteGraphicsBuffer();

	/**
	 * fXgN^
	 */
	virtual ~SpriteGraphicsBuffer();

	//--------------------------------------------------------------------------
	// `
	//--------------------------------------------------------------------------
	/**
	 * ZbgAbv
	 */
	virtual void setup();

	/**
	 * CfbNXobt@̍\z
	 */
	virtual void buildIndexBuffer();

private:
	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	SpriteGraphicsBuffer(const SpriteGraphicsBuffer& copy);

	// Rs[̉B
	void operator =(const SpriteGraphicsBuffer& copy);

	//--------------------------------------------------------------------------
	// 萔
	//--------------------------------------------------------------------------
	// _TCY
	static const int vertexSize_ = (sizeof(Vector3) + sizeof(TexCoord2));
	// CfbNXTCY
	static const int indexSize_ = sizeof(u_short);
	// őXvCg
	static const int maxSpriteCount_ = 256;
	// XvCg̒_
	static const int vertexPerSprite_ = 4;
	// _obt@TCY
	static const int vertexBufferSize_ = maxSpriteCount_ * vertexPerSprite_;
	// XvCg̃CfbNX
	static const int indexPerSprite_ = 6;
	// CfbNXobt@TCY
	static const int indexBufferSize_ = maxSpriteCount_ * indexPerSprite_;

	//--------------------------------------------------------------------------
#pragma pack(1)
	/// XvCgf[^
	class SpriteData{
	public:
		Vector3 position0;
		TexCoord2 uv0;
		Vector3 position1;
		TexCoord2 uv1;
		Vector3 position2;
		TexCoord2 uv2;
		Vector3 position3;
		TexCoord2 uv3;
	};
#pragma pack()

	//--------------------------------------------------------------------------
	// o
	//--------------------------------------------------------------------------
	// CfbNXobt@
	Direct3DIndexBuffer* indexBuffer_;
	// _obt@
	Direct3DVertexBuffer* vertexBuffer_;
	// _Lq
	Direct3DVertexDeclaration* vertexDeclaration_;
	// f[^obt@
	SpriteData dataBuffer_[maxSpriteCount_];
	// 擪CfbNX
	int topIndex_;
	// CfbNX
	int bottomIndex_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SPRITE_GRAPHICS_BUFFER_H_
//------------------------------------------------------------------------------
