//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * eNX`}l[Wwb_
 * @author Junpee
 */

#ifndef TEXTURE_MANAGER_H_
#define TEXTURE_MANAGER_H_

#include <Graphics/Scene/SceneObjectManagerTemplate.h>
#include <Graphics/Texture/SurfaceTexture.h>

namespace Lamp{
//------------------------------------------------------------------------------
/**
 * eNX`}l[W
 */
class TextureManager : public SceneObjectManagerTemplate<Texture>{
friend class Scene;
public:
	/**
	 * T[tF[XeNX`̍쐬
	 *
	 * łɓeNX`̃eNX`݂ƃG[ɂȂ܂B
	 * 󕶎𖼑OɎw肷ƃG[ɂȂ܂B
	 * @param textureName eNX`
	 * @return 쐬ꂽeNX`
	 */
	virtual SurfaceTexture* createSurfaceTexture(const String& textureName);

protected:
	/**
	 * RXgN^
	 * @param scene V[
	 */
	TextureManager(Scene* scene);

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of TEXTURE_MANAGER_H_
//------------------------------------------------------------------------------
