//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * eNX`wb_
 * @author Junpee
 */

#ifndef TEXTURE_H_
#define TEXTURE_H_

#include <Graphics/Scene/SceneObject.h>
#include <Core/Container/ArrayList.h>

namespace Lamp{

class Picture;
class SurfaceTexture;

//------------------------------------------------------------------------------
/**
 * eNX`
 */
class Texture : public SceneObject{
friend class SceneObjectManagerTemplate<Texture>;
friend class TextureManager;
friend class Material;
friend class RenderingDevice;
public:
	/**
	 * t@XJEg̎擾
	 * @return t@XJEg
	 */
	virtual int getReferenceCount() const{ return parents_.getCount(); }

	//--------------------------------------------------------------------------
	/**
	 * Rs[
	 * @param copyMask Rs[}XN
	 * @return Rs[ꂽeNX`
	 */
	virtual Texture* copy(u_int copyMask = 0) const = 0;

	/**
	 * ċAIj
	 * @param texture jeNX`
	 * @return jIuWFNg
	 */
	static int recursiveDestroy(Texture* texture);

	//--------------------------------------------------------------------------
	/**
	 * Xe[gύXtO𗧂Ă
	 */
	virtual void stateChanged();

	//--------------------------------------------------------------------------
	/**
	 * ẽTCY擾
	 * @return ẽTCY
	 */
	virtual int getParentCount() const{ return parents_.getCount(); }

	/**
	 * e̎擾
	 * @param index ẽCfbNX
	 * @return e
	 */
	virtual Material* getParent(int index) const{
		Assert(index >= 0);
		Assert(index < getParentCount());
		return parents_.get(index);
	}

	//--------------------------------------------------------------------------
	// AhX[h
	//--------------------------------------------------------------------------
	/// AhX[h
	enum AddressMode{
		addressModeWrap = 0,
		addressModeClamp,
		addressModeMirror,
		addressModeMax,
	};

	/**
	 * AhX[h當ւ̕ϊ
	 * @param addressMode AhX[h
	 * @return AhX[h
	 */
	static const String& addressModeToString(AddressMode addressMode);

	/**
	 * 񂩂AhX[hւ̕ϊ
	 * @param addressModeString AhX[h
	 * @return AhX[h
	 */
	static AddressMode addressModeFromString(const String& addressModeString);

	//--------------------------------------------------------------------------
	// sN`C^[tF[X
	//--------------------------------------------------------------------------
	/**
	 * sN`̒ǉ
	 * @param picture ǉsN`
	 */
	virtual void addPicture(Picture* picture) = 0;

	/**
	 * sN`̍폜
	 * @param picture 폜sN`
	 */
	virtual void removePicture(Picture* picture) = 0;

	/**
	 * sN`̎擾
	 * @return sN`
	 */
	virtual int getPictureCount() const = 0;

	/**
	 * sN`̎擾
	 * @param index CfbNX
	 * @return sN`
	 */
	virtual Picture* getPicture(int index) const = 0;

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * eNX`ǂ
	 * @return eNX`Ȃtrue
	 */
	virtual bool isTexture() const{ return true; }

	//--------------------------------------------------------------------------
	/**
	 * T[tF[XeNX`ǂ
	 * @return T[tF[XeNX`Ȃtrue
	 */
	virtual bool isSurfaceTexture() const{ return false; }

	/**
	 * T[tF[XeNX`ւ̃LXg
	 * @return T[tF[XeNX`B^ႦNULLԂB
	 */
	virtual SurfaceTexture* castSurfaceTexture() const{
		if(isSurfaceTexture()){ return (SurfaceTexture*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 * @param name O
	 * @param scene V[
	 */
	Texture(const String& name, Scene* scene);

	/**
	 * fXgN^
	 */
	virtual ~Texture();

	/**
	 * eNX`̒lRs[
	 * @param destination Rs[eNX`
	 * @param copyMask Rs[}XN
	 */
	virtual void copyTextureValue(Texture* destination, u_int copyMask) const;

	/**
	 * QƂ̒ǉ
	 * @param parent e
	 * @return QƃJEg
	 */
	virtual int addReference(Material* parent){
		parents_.add(parent);
		return getParentCount();
	}

	/**
	 * QƂ̍폜
	 * @param parent e
	 * @return QƃJEg
	 */
	virtual int removeReference(Material* parent){
		parents_.removeByValue(parent);
		return getParentCount();
	}

	/**
	 * sN`t@X̒ǉ
	 * @param picture t@XǉsN`
	 */
	virtual void addPictureReference(Picture* picture);

	/**
	 * sN`t@X̍폜
	 * @param picture t@X폜sN`
	 */
	virtual void removePictureReference(Picture* picture);

	/**
	 * D3DeNX`̎擾
	 * @return D3DeNX`̎擾
	 */
	virtual Direct3DTexture* getD3DTexture() = 0;

	//--------------------------------------------------------------------------
private:
	// ez
	ArrayList<Material*> parents_;

	// AhX[he[u
	static const String addressModeStringTable[];

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of TEXTURE_H_
//------------------------------------------------------------------------------

