//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * T[tF[XeNX`wb_
 * @author Junpee
 */

#ifndef SURFACE_TEXTURE_H_
#define SURFACE_TEXTURE_H_

#include <Graphics/Texture/Texture.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * T[tF[XeNX`
 */
class SurfaceTexture : public Texture{
friend class TextureManager;
public:
	/**
	 * T[tF[XeNX`ǂ
	 * @return T[tF[XeNX`Ȃtrue
	 */
	virtual bool isSurfaceTexture() const{ return true; }

	//--------------------------------------------------------------------------
	/**
	 * Rs[
	 * @param copyMask Rs[}XN
	 * @return Rs[ꂽeNX`
	 */
	virtual Texture* copy(u_int copyMask = 0) const{
		return copySurfaceTexture(copyMask);
	}

	/**
	 * T[tF[XeNX`̃Rs[
	 * @param copyMask Rs[}XN
	 * @return Rs[ꂽT[tF[XeNX`
	 */
	virtual SurfaceTexture* copySurfaceTexture(u_int copyMask = 0) const;

	//--------------------------------------------------------------------------
	// sN`C^[tF[X
	//--------------------------------------------------------------------------
	/**
	 * sN`̒ǉ
	 * @param picture ǉsN`
	 */
	virtual void addPicture(Picture* picture){
		Assert(picture_ == NULL);
		Assert(picture != NULL);
		picture_ = picture;
		addPictureReference(picture_);
		stateChanged();
	}

	/**
	 * sN`̍폜
	 * @param picture 폜sN`
	 */
	virtual void removePicture(Picture* picture){
		Assert(picture_ == picture);
		removePictureReference(picture_);
		picture_ = NULL;
		stateChanged();
	}

	/**
	 * sN`̎擾
	 * @return sN`
	 */
	virtual int getPictureCount() const{
		if(picture_ == NULL){ return 0; }
		return 1;
	}

	/**
	 * sN`̎擾
	 * @param index CfbNX
	 * @return sN`
	 */
	virtual Picture* getPicture(int index) const{
		Assert(picture_ != NULL);
		Assert(index == 0);
		return picture_;
	}

	//--------------------------------------------------------------------------
	/**
	 * AhX[hU̐ݒ
	 * @param addressModeU AhX[hU
	 */
	virtual void setAddressModeU(AddressMode addressModeU){
		addressModeU_ = addressModeU;
		stateChanged();
	}

	/**
	 * AhX[hU̎擾
	 * @return AhX[hU
	 */
	virtual AddressMode getAddressModeU() const{ return addressModeU_; }

	//--------------------------------------------------------------------------
	/**
	 * AhX[hV̐ݒ
	 * @param addressModeV AhX[hV
	 */
	virtual void setAddressModeV(AddressMode addressModeV){
		addressModeV_ = addressModeV;
		stateChanged();
	}

	/**
	 * AhX[hV̎擾
	 * @return AhX[hV
	 */
	virtual AddressMode getAddressModeV() const{ return addressModeV_; }

	//--------------------------------------------------------------------------
	/**
	 * s[gUV̐ݒ
	 * @param repeatUV s[gUV
	 */
	virtual void setRepeatUV(const TexCoord2& repeatUV){
		repeatUV_ = repeatUV;
		stateChanged();
	}

	/**
	 * s[gUV̎擾
	 * @return s[gUV
	 */
	virtual const TexCoord2& getRepeatUV() const{ return repeatUV_; }

	//--------------------------------------------------------------------------
	/**
	 * ItZbgUV̐ݒ
	 * @param offsetUV ItZbgUV
	 */
	virtual void setOffsetUV(const TexCoord2& offsetUV){
		offsetUV_ = offsetUV;
		stateChanged();
	}

	/**
	 * ItZbgUV̎擾
	 * @return ItZbgUV
	 */
	virtual const TexCoord2& getOffsetUV() const{ return offsetUV_; }

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 * @param name O
	 * @param scene V[
	 */
	SurfaceTexture(const String& name, Scene* scene);

	/**
	 * fXgN^
	 */
	virtual ~SurfaceTexture();

	/**
	 * D3DeNX`̎擾
	 * @return D3DeNX`̎擾
	 */
	virtual Direct3DTexture* getD3DTexture();

	//--------------------------------------------------------------------------
private:
	// sN`
	Picture* picture_;
	// AhX[hU
	AddressMode addressModeU_;
	// AhX[hV
	AddressMode addressModeV_;
	// s[gUV
	TexCoord2 repeatUV_;
	// ItZbgUV
	TexCoord2 offsetUV_;
	// bvU
	bool wrapU_;
	// bvV
	bool wrapV_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SURFACE_TEXTURE_H_
//------------------------------------------------------------------------------

