//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * LampOtBbNXwb_
 * @author Junpee
 */

#ifndef LAMP_GRAPHICS_H_
#define LAMP_GRAPHICS_H_

#include <Core/Container/ArrayList.h>
#include <Core/Container/HashMap.h>
#include <Graphics/Scene/Scene.h>

namespace Lamp{

class GraphicsDeviceEnumeration;
class GraphicsDeviceSelector;
class GraphicsDeviceSettings;
class GraphicsDevice;
class GraphicsDeviceCapacity;
class RenderingDevice;
class ShaderManager;
class GraphicsDeviceObjectHolder;
class Scene;

//------------------------------------------------------------------------------
/**
 * LampOtBbNX
 */
class LampGraphics{
friend class LampCore;
friend class GraphicsDevice;
public:
	/**
	 * 
	 */
	static void initialize();

	/**
	 * foCX̏
	 *
	 * 񋓂̏ݒ̓foCXOɍsKvB
	 * foCXZN^̐ݒ̓foCXOɍsKvB
	 * @param windowHandle EBhEnh
	 * @param startFullscreen tXN[D悵ďȂtrue
	 * @return foCX̏ɐtrue
	 */
	static bool initializeDevice(HWND windowHandle, bool startFullscreen);

	/**
	 * n
	 */
	static void finalize();

	//--------------------------------------------------------------------------
	/**
	 * OtBbNXfoCXZN^̐ݒ
	 *
	 * ݒ肵ZN^LampGraphicsɂdelete܂
	 * @param selector OtBbNXfoCXZN^
	 */
	static void setDeviceSelector(GraphicsDeviceSelector* selector);

	/**
	 * OtBbNXfoCXZN^̎擾
	 * @return OtBbNXfoCXZN^
	 */
	static GraphicsDeviceSelector* getDeviceSelector(){ return selector_; }

	//--------------------------------------------------------------------------
	/**
	 * EBhEnh̎擾
	 * @return EBhEnh
	 */
	static HWND getWindowHandle(){ return windowHandle_; }

	/**
	 * Direct3D̎擾
	 * @return Direct3D
	 */
	static Direct3D* getDirect3D(){ return direct3D_; }

	/**
	 * Direct3DfoCX̎擾
	 * @return Direct3DfoCX
	 */
	static Direct3DDevice* getDirect3DDevice(){ return direct3DDevice_; }

	//--------------------------------------------------------------------------
	// foCXIuWFNgz_
	//--------------------------------------------------------------------------
	/**
	 * foCXIuWFNgz_̒ǉ
	 * @param objectHolder ǉfoCXIuWFNgz_
	 */
	static void addDeviceObjectHolder(GraphicsDeviceObjectHolder* objectHolder){
		deviceObjectHolders_.add(objectHolder);
	}

	/**
	 * foCXIuWFNgz_̍폜
	 * @param objectHolder 폜foCXIuWFNgz_
	 */
	static void removeDeviceObjectHolder(
		GraphicsDeviceObjectHolder* objectHolder){
		deviceObjectHolders_.removeByValue(objectHolder);
	}

	/**
	 * foCXIuWFNgz_̎擾
	 * @return foCXIuWFNgz_
	 */
	static int getDeviceObjectHolderCount(){
		return deviceObjectHolders_.getCount();
	}

	/**
	 * foCXIuWFNgz_̎擾
	 * @param index foCXIuWFNgz_̃CfNX
	 * @return foCXIuWFNgz_
	 */
	static GraphicsDeviceObjectHolder* getDeviceObjectHolder(int index){
		return deviceObjectHolders_.get(index);
	}

	//--------------------------------------------------------------------------
	// V[֌WAŃANZX\
	//--------------------------------------------------------------------------
	/**
	 * V[̍쐬
	 * @param name O
	 * @return 쐬ꂽV[
	 */
	static Scene* createScene(const String& name);

	/**
	 * V[̔j
	 * @param scene jV[
	 */
	static void destroyScene(Scene* scene);

	/**
	 * V[̎擾
	 * @return V[
	 */
	static int getSceneCount(){ return sceneArray_.getCount(); }

	/**
	 * V[̎擾
	 * @param index V[̃CfNX
	 * @return V[
	 */
	static Scene* getScene(int index){ return sceneArray_.get(index); }

	/**
	 * V[̌
	 * @param name V[
	 * @return V[
	 */
	static Scene* search(String name){ return sceneDatabase_.get(name); }

	//--------------------------------------------------------------------------
protected:
	/**
	 * EBhEvV[W
	 * @param windowHandle EBhEnh
	 * @param message bZ[W
	 * @param wParam wbZ[Wp[^
	 * @param lParam lbZ[Wp[^
	 * @return bZ[WAȏ̏KvȂ0ȊOԂB
	 */
	static LRESULT windowProcedure(
		HWND windowHandle, u_int message, WPARAM wParam, LPARAM lParam);

	//--------------------------------------------------------------------------
	/**
	 * foCXZbgꂽ
	 */
	static void deviceReset();

	/**
	 * foCXIuWFNg̏
	 * @return trueԂ
	 */
	static bool initializeDeviceObjects();

	/**
	 * foCXIuWFNg̍폜
	 */
	static void deleteDeviceObjects();

	/**
	 * foCXIuWFNg̃XgA
	 * @return trueԂ
	 */
	static bool restoreDeviceObjects();

	/**
	 * foCXIuWFNg̖
	 */
	static void invalidateDeviceObjects();

	//--------------------------------------------------------------------------
private:
	// RXgN^̉B
	LampGraphics();

	// EBhEnh
	static HWND windowHandle_;
	// OtBbNXfoCX̗
	static GraphicsDeviceEnumeration* enumeration_;
	// OtBbNXfoCXZN^
	static GraphicsDeviceSelector* selector_;
	// OtBbNXfoCXݒ
	static GraphicsDeviceSettings* settings_;
	// OtBbNXfoCX
	static GraphicsDevice* device_;
	// Direct3DfoCX
	static Direct3DDevice* direct3DDevice_;
	// OtBbNXfoCX\
	static GraphicsDeviceCapacity* deviceCapacity_;
	// _OfoCX
	static RenderingDevice* renderingDevice_;
	// VF[_}l[W
	static ShaderManager* shaderManager_;
	// Direct3D
	static Direct3D* direct3D_;
	// foCXIuWFNgz_
	static ArrayList<GraphicsDeviceObjectHolder*> deviceObjectHolders_;

	// V[z
	static ArrayList<Scene*> sceneArray_;
	// V[f[^x[X
	static HashMap<String, Scene*> sceneDatabase_;
	// V[LpVeB
	static const int scenesCapacity_ = 16;

	// tO
	static bool isInitialized_;
	// foCXtO
	static bool deviceInitialized_;
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of LAMP_GRAPHICS_H_
//------------------------------------------------------------------------------

