//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * OtBbNXfoCXݒwb_
 * @author Junpee
 */

#ifndef GRAPHICS_DEVICE_SETTINGS_H_
#define GRAPHICS_DEVICE_SETTINGS_H_

#include <Graphics/Enumeration/GraphicsDeviceComboInformation.h>

namespace Lamp{

class GraphicsAdapterInformation;
class GraphicsDeviceInformation;

//------------------------------------------------------------------------------
/**
 * OtBbNXfoCXݒ
 */
class GraphicsDeviceSettings{
public:
	//--------------------------------------------------------------------------
	/**
	 * CX^X擾
	 * @return CX^X
	 */
	static GraphicsDeviceSettings* getInstance(){
		Assert(instance_ != NULL);
		return instance_;
	}

	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	GraphicsDeviceSettings(){
		Assert(instance_ == NULL);
		instance_ = this;
		isWindowed_ = true;
		// EBhE[h
		windowedAdapterInformation_ = NULL;
		windowedDeviceInformation_ = NULL;
		windowedDeviceComboInformation_ = NULL;
		windowedDisplayMode_.Width = 0;
		windowedDisplayMode_.Height = 0;
		windowedDisplayMode_.Format = D3DFMT_UNKNOWN;
		windowedDisplayMode_.RefreshRate = 0;
		windowedDepthStencilFormat_ = D3DFMT_UNKNOWN;
		windowedMultiSampleType_ = D3DMULTISAMPLE_NONE;
		windowedMultiSampleQuality_ = 0;
		windowedVertexProcessingType_ = VertexProcessingType::software;
		windowedPresentationInterval_ = 0;
		windowSize_.set(0, 0);
		// tXN[[h
		fullscreenAdapterInformation_ = NULL;
		fullscreenDeviceInformation_ = NULL;
		fullscreenDeviceComboInformation_ = NULL;
		fullscreenDisplayMode_.Width = 0;
		fullscreenDisplayMode_.Height = 0;
		fullscreenDisplayMode_.Format = D3DFMT_UNKNOWN;
		fullscreenDisplayMode_.RefreshRate = 0;
		fullscreenDepthStencilFormat_ = D3DFMT_UNKNOWN;
		fullscreenMultiSampleType_ = D3DMULTISAMPLE_NONE;
		fullscreenMultiSampleQuality_ = 0;
		fullscreenVertexProcessingType_ = VertexProcessingType::software;
		fullscreenPresentationInterval_ = 0;
	}

	/**
	 * fXgN^
	 */
	~GraphicsDeviceSettings(){
		Assert(instance_ == this);
		instance_ = NULL;
	}
	/**
	 * v[e[Vp[^̍\z
	 * @param parameters [out] v[e[Vp[^ւ̃|C^
	 * @param windowHandle EBhEnh
	 */
	virtual void buildPresentationParameters(
		D3DPRESENT_PARAMETERS* parameters, HWND windowHandle){
		// EBhE[h̐ݒ
		parameters->Windowed = isWindowed();
		// EBhEnh̐ݒ
		parameters->hDeviceWindow = windowHandle;
		// obNobt@1
		parameters->BackBufferCount = 1;
		// }`Tv̐ݒ
		parameters->MultiSampleType = getMultiSampleType();
		parameters->MultiSampleQuality = getMultiSampleQuality();
		// Xbv̓hCoɔC
		parameters->SwapEffect = D3DSWAPEFFECT_DISCARD;
		// [xAXeVtH[}bgLłΎgpB
		bool useDepthBuffer = getDepthStencilEnabled();
		parameters->EnableAutoDepthStencil = useDepthBuffer;
		parameters->AutoDepthStencilFormat = getDepthStencilFormat();
		parameters->Flags = 0;
		if(useDepthBuffer){
			parameters->Flags |= D3DPRESENTFLAG_DISCARD_DEPTHSTENCIL;
		}
		// obNobt@̐ݒ
		DimensionI backBufferSize = getBackBufferSize();
		parameters->BackBufferWidth = backBufferSize.width;
		parameters->BackBufferHeight = backBufferSize.height;
		parameters->BackBufferFormat = getBackBufferFormat();
		parameters->PresentationInterval = getPresentationInterval();
		if(isWindowed()){
			parameters->FullScreen_RefreshRateInHz = 0;
		}else{
			parameters->FullScreen_RefreshRateInHz =
				getDisplayMode().RefreshRate;
		}
	}

	//--------------------------------------------------------------------------
	/**
	 * EBhE[h̐ݒ
	 * @param isWindowed EBhE[hȂtrue
	 */
	virtual void setWindowed(bool isWindowed){ isWindowed_ = isWindowed; }

	/**
	 * EBhE[h̎擾
	 * @return EBhE[hȂtrue
	 */
	virtual bool isWindowed(){ return isWindowed_; }

	//--------------------------------------------------------------------------
	/**
	 * obNobt@TCY̎擾
	 * @return obNobt@TCY
	 */
	virtual DimensionI getBackBufferSize(){
		DimensionI backBufferSize;
		if(isWindowed()){
			backBufferSize.set(windowSize_.width, windowSize_.height);
		}else{
			backBufferSize.set(getDisplayMode().Width, getDisplayMode().Height);
		}
		return backBufferSize;
	}

	/**
	 * obNobt@tH[}bg̎擾
	 * @return obNobt@tH[}bg
	 */
	virtual D3DFORMAT getBackBufferFormat(){
		return getDeviceComboInformation()->getBackBufferFormat();
	}

	//--------------------------------------------------------------------------
	/**
	 * A_v^̐ݒ
	 * @param adapterInformation A_v^
	 */
	virtual void setAdapterInformation(
		GraphicsAdapterInformation* adapterInformation){
		if(isWindowed_){ windowedAdapterInformation_ = adapterInformation;; }
		else{ fullscreenAdapterInformation_ = adapterInformation; }
	}

 	/**
	 * A_v^̎擾
	 * @return A_v^
	 */
	virtual GraphicsAdapterInformation* getAdapterInformation(){
		if(isWindowed_){ return windowedAdapterInformation_; }
		else{ return fullscreenAdapterInformation_; }
	}

	//--------------------------------------------------------------------------
	/**
	 * foCX̐ݒ
	 * @param deviceInformation foCX
	 */
	virtual void setDeviceInformation(
		GraphicsDeviceInformation* deviceInformation){
		if(isWindowed_){ windowedDeviceInformation_ = deviceInformation;; }
		else{ fullscreenDeviceInformation_ = deviceInformation; }
	}

 	/**
	 * foCX̎擾
	 * @return foCX
	 */
	virtual GraphicsDeviceInformation* getDeviceInformation(){
		if(isWindowed_){ return windowedDeviceInformation_; }
		else{ return fullscreenDeviceInformation_; }
	}

	//--------------------------------------------------------------------------
	/**
	 * foCXR{̐ݒ
	 * @param deviceComboInformation foCXR{
	 */
	virtual void setDeviceComboInformation(
		GraphicsDeviceComboInformation* deviceComboInformation){
		if(isWindowed_){
			windowedDeviceComboInformation_ = deviceComboInformation;
		}else{
			fullscreenDeviceComboInformation_ = deviceComboInformation;
		}
	}

 	/**
	 * foCXR{̎擾
	 * @return foCXR{
	 */
	virtual GraphicsDeviceComboInformation* getDeviceComboInformation(){
		if(isWindowed_){ return windowedDeviceComboInformation_; }
		else{ return fullscreenDeviceComboInformation_; }
	}

	//--------------------------------------------------------------------------
	/**
	 * fBXvC[h̐ݒ
	 * @param displayMode fBXvC[h
	 */
	virtual void setDisplayMode(D3DDISPLAYMODE displayMode){
		if(isWindowed_){ windowedDisplayMode_ = displayMode; }
		else{ fullscreenDisplayMode_ = displayMode; }
	}

 	/**
	 * fBXvC[h̎擾
	 * @return fBXvC[h
	 */
	virtual D3DDISPLAYMODE getDisplayMode(){
		if(isWindowed_){ return windowedDisplayMode_; }
		else{ return fullscreenDisplayMode_; }
	}

	//--------------------------------------------------------------------------
	/**
	 * [xAXeVL
	 * @return [xAXeVLȂtrue
	 */
	virtual bool getDepthStencilEnabled(){
		return (getDepthStencilFormat() != D3DFMT_UNKNOWN);
	}

	/**
	 * [xAXeVtH[}bg̐ݒ
	 * @param depthStencilFormat [xAXeVtH[}bg
	 */
	virtual void setDepthStencilFormat(D3DFORMAT depthStencilFormat){
		if(isWindowed_){ windowedDepthStencilFormat_ = depthStencilFormat; }
		else{ fullscreenDepthStencilFormat_ = depthStencilFormat; }
	}

 	/**
	 * [xAXeVtH[}bg̎擾
	 * @return [xAXeVtH[}bg
	 */
	virtual D3DFORMAT getDepthStencilFormat(){
		if(isWindowed_){ return windowedDepthStencilFormat_; }
		else{ return fullscreenDepthStencilFormat_; }
	}

	//--------------------------------------------------------------------------
	/**
	 * }`Tv^Cv̐ݒ
	 * @param multiSampleType }`Tv^Cv
	 */
	virtual void setMultiSampleType(D3DMULTISAMPLE_TYPE multiSampleType){
		if(isWindowed_){ windowedMultiSampleType_ = multiSampleType; }
		else{ fullscreenMultiSampleType_ = multiSampleType; }
	}

 	/**
	 * }`Tv^Cv̎擾
	 * @return }`Tv^Cv
	 */
	virtual D3DMULTISAMPLE_TYPE getMultiSampleType(){
		if(isWindowed_){ return windowedMultiSampleType_; }
		else{ return fullscreenMultiSampleType_; }
	}

	//--------------------------------------------------------------------------
	/**
	 * }`TvNHeB̐ݒ
	 * @param multiSampleQuality }`TvNHeB
	 */
	virtual void setMultiSampleQuality(u_int multiSampleQuality){
		if(isWindowed_){ windowedMultiSampleQuality_ = multiSampleQuality; }
		else{ fullscreenMultiSampleQuality_ = multiSampleQuality; }
	}

 	/**
	 * }`TvNHeB̎擾
	 * @return }`TvNHeB
	 */
	virtual u_int getMultiSampleQuality(){
		if(isWindowed_){ return windowedMultiSampleQuality_; }
		else{ return fullscreenMultiSampleQuality_; }
	}

	//--------------------------------------------------------------------------
	/**
	 * _vZX^Cv̐ݒ
	 * @param vertexProcessingType _vZX^Cv
	 */
	virtual void setVertexProcessingType(
		VertexProcessingType vertexProcessingType){
		if(isWindowed_){ windowedVertexProcessingType_ = vertexProcessingType; }
		else{ fullscreenVertexProcessingType_ = vertexProcessingType; }
	}

 	/**
	 * _vZX^Cv̎擾
	 * @return _vZX^Cv
	 */
	virtual VertexProcessingType getVertexProcessingType(){
		if(isWindowed_){ return windowedVertexProcessingType_; }
		else{ return fullscreenVertexProcessingType_; }
	}

	//--------------------------------------------------------------------------
	/**
	 * v[e[VԊu̐ݒ
	 * @param presentationInterval v[e[VԊu
	 */
	virtual void setPresentationInterval(u_int presentationInterval){
		if(isWindowed_){ windowedPresentationInterval_ = presentationInterval; }
		else{ fullscreenPresentationInterval_ = presentationInterval; }
	}

 	/**
	 * v[e[VԊu̎擾
	 * @return v[e[VԊu
	 */
	virtual u_int getPresentationInterval(){
		if(isWindowed_){ return windowedPresentationInterval_; }
		else{ return fullscreenPresentationInterval_; }
	}

	//--------------------------------------------------------------------------
	// EBhE[h
	//--------------------------------------------------------------------------
	/**
	 * EBhE[hA_v^̐ݒ
	 * @param adapterInformation EBhE[hA_v^
	 */
	virtual void setWindowedAdapterInformation(
		GraphicsAdapterInformation* adapterInformation){
		windowedAdapterInformation_ = adapterInformation;
	}

 	/**
	 * EBhE[hA_v^̎擾
	 * @return EBhE[hA_v^
	 */
	virtual GraphicsAdapterInformation* getWindowedAdapterInformation(){
		return windowedAdapterInformation_;
	}

	//--------------------------------------------------------------------------
	/**
	 * EBhE[hfoCX̐ݒ
	 * @param deviceInformation EBhE[hfoCX
	 */
	virtual void setWindowedDeviceInformation(
		GraphicsDeviceInformation* deviceInformation){
		windowedDeviceInformation_ = deviceInformation;
	}

 	/**
	 * EBhE[hfoCX̎擾
	 * @return EBhE[hfoCX
	 */
	virtual GraphicsDeviceInformation* getWindowedDeviceInformation(){
		return windowedDeviceInformation_;
	}

	//--------------------------------------------------------------------------
	/**
	 * EBhE[hfoCXR{̐ݒ
	 * @param deviceComboInformation EBhE[hfoCXR{
	 */
	virtual void setWindowedDeviceComboInformation(
		GraphicsDeviceComboInformation* deviceComboInformation){
		windowedDeviceComboInformation_ = deviceComboInformation;
	}

 	/**
	 * EBhE[hfoCXR{̎擾
	 * @return EBhE[hfoCXR{
	 */
	virtual GraphicsDeviceComboInformation* getWindowedDeviceComboInformation(){
		return windowedDeviceComboInformation_;
	}

	//--------------------------------------------------------------------------
	/**
	 * EBhE[hfBXvC[h̐ݒ
	 * @param displayMode EBhE[hfBXvC[h
	 */
	virtual void setWindowedDisplayMode(D3DDISPLAYMODE displayMode){
		windowedDisplayMode_ = displayMode;
	}

 	/**
	 * EBhE[hfBXvC[h̎擾
	 * @return EBhE[hfBXvC[h
	 */
	virtual D3DDISPLAYMODE getWindowedDisplayMode(){
		return windowedDisplayMode_;
	}

	//--------------------------------------------------------------------------
	/**
	 * EBhE[h[xAXeVtH[}bg̐ݒ
	 * @param depthStencilFormat EBhE[h[xAXeVtH[}bg
	 */
	virtual void setWindowedDepthStencilFormat(D3DFORMAT depthStencilFormat){
		windowedDepthStencilFormat_ = depthStencilFormat;
	}

 	/**
	 * EBhE[h[xAXeVtH[}bg̎擾
	 * @return EBhE[h[xAXeVtH[}bg
	 */
	virtual D3DFORMAT getWindowedDepthStencilFormat(){
		return windowedDepthStencilFormat_;
	}

	//--------------------------------------------------------------------------
	/**
	 * EBhE[h}`Tv^Cv̐ݒ
	 * @param multiSampleType EBhE[h}`Tv^Cv
	 */
	virtual void setWindowedMultiSampleType(
		D3DMULTISAMPLE_TYPE multiSampleType){
		windowedMultiSampleType_ = multiSampleType;
	}

 	/**
	 * EBhE[h}`Tv^Cv̎擾
	 * @return EBhE[h}`Tv^Cv
	 */
	virtual D3DMULTISAMPLE_TYPE getWindowedMultiSampleType(){
		return windowedMultiSampleType_;
	}

	//--------------------------------------------------------------------------
	/**
	 * EBhE[h}`TvNHeB̐ݒ
	 * @param multiSampleQuality EBhE[h}`TvNHeB
	 */
	virtual void setWindowedMultiSampleQuality(u_int multiSampleQuality){
		windowedMultiSampleQuality_ = multiSampleQuality;
	}

 	/**
	 * EBhE[h}`TvNHeB̎擾
	 * @return EBhE[h}`TvNHeB
	 */
	virtual u_int getWindowedMultiSampleQuality(){
		return windowedMultiSampleQuality_;
	}

	//--------------------------------------------------------------------------
	/**
	 * EBhE[h_vZX^Cv̐ݒ
	 * @param vertexProcessingType EBhE[h_vZX^Cv
	 */
	virtual void setWindowedVertexProcessingType(
		VertexProcessingType vertexProcessingType){
		windowedVertexProcessingType_ = vertexProcessingType;
	}

 	/**
	 * EBhE[h_vZX^Cv̎擾
	 * @return EBhE[h_vZX^Cv
	 */
	virtual VertexProcessingType getWindowedVertexProcessingType(){
		return windowedVertexProcessingType_;
	}

	//--------------------------------------------------------------------------
	/**
	 * EBhE[hv[e[VԊu̐ݒ
	 * @param presentationInterval EBhE[hv[e[VԊu
	 */
	virtual void setWindowedPresentationInterval(u_int presentationInterval){
		windowedPresentationInterval_ = presentationInterval;
	}

 	/**
	 * EBhE[hv[e[VԊu̎擾
	 * @return EBhE[hv[e[VԊu
	 */
	virtual u_int getWindowedPresentationInterval(){
		return windowedPresentationInterval_;
	}

	//--------------------------------------------------------------------------
	/**
	 * EBhETCY̐ݒ
	 * @param size EBhETCY
	 */
	virtual void setWindowSize(DimensionI size){ windowSize_ = size; }

 	/**
	 * EBhETCY̎擾
	 * @return EBhETCY
	 */
	virtual const DimensionI& getWindowSize(){ return windowSize_; }

	//--------------------------------------------------------------------------
	// tXN[[h
	//--------------------------------------------------------------------------
	/**
	 * tXN[[hA_v^̐ݒ
	 * @param adapterInformation tXN[[hA_v^
	 */
	virtual void setFullscreenAdapterInformation(
		GraphicsAdapterInformation* adapterInformation){
		fullscreenAdapterInformation_ = adapterInformation;
	}

 	/**
	 * tXN[[hA_v^̎擾
	 * @return tXN[[hA_v^
	 */
	virtual GraphicsAdapterInformation* getFullscreenAdapterInformation(){
		return fullscreenAdapterInformation_;
	}

	//--------------------------------------------------------------------------
	/**
	 * tXN[[hfoCX̐ݒ
	 * @param deviceInformation tXN[[hfoCX
	 */
	virtual void setFullscreenDeviceInformation(
		GraphicsDeviceInformation* deviceInformation){
		fullscreenDeviceInformation_ = deviceInformation;
	}

 	/**
	 * tXN[[hfoCX̎擾
	 * @return tXN[[hfoCX
	 */
	virtual GraphicsDeviceInformation* getFullscreenDeviceInformation(){
		return fullscreenDeviceInformation_;
	}

	//--------------------------------------------------------------------------
	/**
	 * tXN[[hfoCXR{̐ݒ
	 * @param deviceComboInformation tXN[[hfoCXR{
	 */
	virtual void setFullscreenDeviceComboInformation(
		GraphicsDeviceComboInformation* deviceComboInformation){
		fullscreenDeviceComboInformation_ = deviceComboInformation;
	}

 	/**
	 * tXN[[hfoCXR{̎擾
	 * @return tXN[[hfoCXR{
	 */
	virtual GraphicsDeviceComboInformation*
		getFullscreenDeviceComboInformation(){
		return fullscreenDeviceComboInformation_;
	}

	//--------------------------------------------------------------------------
	/**
	 * tXN[[hfBXvC[h̐ݒ
	 * @param displayMode tXN[[hfBXvC[h
	 */
	virtual void setFullscreenDisplayMode(D3DDISPLAYMODE displayMode){
		fullscreenDisplayMode_ = displayMode;
	}

 	/**
	 * tXN[[hfBXvC[h̎擾
	 * @return tXN[[hfBXvC[h
	 */
	virtual D3DDISPLAYMODE getFullscreenDisplayMode(){
		return fullscreenDisplayMode_;
	}

	//--------------------------------------------------------------------------
	/**
	 * tXN[[h[xAXeVtH[}bg̐ݒ
	 * @param depthStencilFormat tXN[[h[xAXeVtH[}bg
	 */
	virtual void setFullscreenDepthStencilFormat(D3DFORMAT depthStencilFormat){
		fullscreenDepthStencilFormat_ = depthStencilFormat;
	}

 	/**
	 * tXN[[h[xAXeVtH[}bg̎擾
	 * @return tXN[[h[xAXeVtH[}bg
	 */
	virtual D3DFORMAT getFullscreenDepthStencilFormat(){
		return fullscreenDepthStencilFormat_;
	}

	//--------------------------------------------------------------------------
	/**
	 * tXN[[h}`Tv^Cv̐ݒ
	 * @param multiSampleType tXN[[h}`Tv^Cv
	 */
	virtual void setFullscreenMultiSampleType(
		D3DMULTISAMPLE_TYPE multiSampleType){
		fullscreenMultiSampleType_ = multiSampleType;
	}

 	/**
	 * tXN[[h}`Tv^Cv̎擾
	 * @return tXN[[h}`Tv^Cv
	 */
	virtual D3DMULTISAMPLE_TYPE getFullscreenMultiSampleType(){
		return fullscreenMultiSampleType_;
	}

	//--------------------------------------------------------------------------
	/**
	 * tXN[[h}`TvNHeB̐ݒ
	 * @param multiSampleQuality tXN[[h}`TvNHeB
	 */
	virtual void setFullscreenMultiSampleQuality(u_int multiSampleQuality){
		fullscreenMultiSampleQuality_ = multiSampleQuality;
	}

 	/**
	 * tXN[[h}`TvNHeB̎擾
	 * @return tXN[[h}`TvNHeB
	 */
	virtual u_int getFullscreenMultiSampleQuality(){
		return fullscreenMultiSampleQuality_;
	}

	//--------------------------------------------------------------------------
	/**
	 * tXN[[h_vZX^Cv̐ݒ
	 * @param vertexProcessingType tXN[[h_vZX^Cv
	 */
	virtual void setFullscreenVertexProcessingType(
		VertexProcessingType vertexProcessingType){
		fullscreenVertexProcessingType_ = vertexProcessingType;
	}

 	/**
	 * tXN[[h_vZX^Cv̎擾
	 * @return tXN[[h_vZX^Cv
	 */
	virtual VertexProcessingType getFullscreenVertexProcessingType(){
		return fullscreenVertexProcessingType_;
	}

	//--------------------------------------------------------------------------
	/**
	 * tXN[[hv[e[VԊu̐ݒ
	 * @param presentationInterval tXN[[hv[e[VԊu
	 */
	virtual void setFullscreenPresentationInterval(u_int presentationInterval){
		fullscreenPresentationInterval_ = presentationInterval;
	}

 	/**
	 * tXN[[hv[e[VԊu̎擾
	 * @return tXN[[hv[e[VԊu
	 */
	virtual u_int getFullscreenPresentationInterval(){
		return fullscreenPresentationInterval_;
	}

private:
	// EBhE[h
	bool isWindowed_;

	//--------------------------------------------------------------------------
	// EBhE[h
	//--------------------------------------------------------------------------

	// A_v^
	GraphicsAdapterInformation* windowedAdapterInformation_;
	// foCX
	GraphicsDeviceInformation* windowedDeviceInformation_;
	// foCXR{
	GraphicsDeviceComboInformation* windowedDeviceComboInformation_;
	// fBXvC[h
	D3DDISPLAYMODE windowedDisplayMode_;
	// [xAXeVtH[}bg
	D3DFORMAT windowedDepthStencilFormat_;
	// }`Tv^Cv
	D3DMULTISAMPLE_TYPE windowedMultiSampleType_;
	// }`TvNHeB
	u_int windowedMultiSampleQuality_;
	// _vZX^Cv
	VertexProcessingType windowedVertexProcessingType_;
	// v[e[VԊu
	u_int windowedPresentationInterval_;
	// EBhETCY
	DimensionI windowSize_;

	//--------------------------------------------------------------------------
	// tXN[[h
	//--------------------------------------------------------------------------

	// A_v^
	GraphicsAdapterInformation* fullscreenAdapterInformation_;
	// foCX
	GraphicsDeviceInformation* fullscreenDeviceInformation_;
	// foCXR{
	GraphicsDeviceComboInformation* fullscreenDeviceComboInformation_;
	// fBXvC[h
	D3DDISPLAYMODE fullscreenDisplayMode_;
	// [xAXeVtH[}bg
	D3DFORMAT fullscreenDepthStencilFormat_;
	// }`Tv^Cv
	D3DMULTISAMPLE_TYPE fullscreenMultiSampleType_;
	// }`TvNHeB
	u_int fullscreenMultiSampleQuality_;
	// _vZX^Cv
	VertexProcessingType fullscreenVertexProcessingType_;
	// v[e[VԊu
	u_int fullscreenPresentationInterval_;

	// CX^X
	static GraphicsDeviceSettings* instance_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of GRAPHICS_DEVICE_SETTINGS_H_
//------------------------------------------------------------------------------
