//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * OtBbNXfoCX\̓wb_
 * @author Junpee
 */

#ifndef GRAPHICS_DEVICE_CAPACITY_H_
#define GRAPHICS_DEVICE_CAPACITY_H_

#include <Graphics/Primitive/VertexProcessingType.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * OtBbNXfoCX\
 */
class GraphicsDeviceCapacity{
friend class LampGraphics;
public:
	//--------------------------------------------------------------------------
	/**
	 * CX^X擾
	 * @return CX^X
	 */
	static GraphicsDeviceCapacity* getInstance(){
		Assert(instance_ != NULL);
		return instance_;
	}

	//--------------------------------------------------------------------------
	/**
	 * foCX\͂̎擾
	 * @return foCX\
	 */
	virtual const D3DCapacity& getCapacity() const{ return capacity_; }

	/**
	 * ւ̕ϊ
	 * @return OtBbNXfoCX\͕
	 */
	virtual String toString() const;

	//--------------------------------------------------------------------------
	// foCX
	//--------------------------------------------------------------------------
	/**
	 * foCX̎擾
	 * @return foCX
	 */
	virtual const String& getDeviceName() const{ return deviceName_; }

	/**
	 * hCo̎擾
	 * @return hCo
	 */
	virtual const String& getDriverName() const{ return driverName_; }

	/**
	 * foCXԍ̎擾
	 * @return foCXԍ
	 */
	virtual int getDeviceOrdinal() const{ return deviceOrdinal_; }

	/**
	 * foCX^Cv̎擾
	 * @return foCX^Cv
	 */
	virtual D3DDEVTYPE getDeviceType() const{ return deviceType_; }

	/**
	 * EBhE[h̎擾
	 * @return EBhE[hȂtrue
	 */
	virtual bool isWindowed() const{ return isWindowed_; }

	/**
	 * _vZX^Cv̎擾
	 * @return _vZX^Cv
	 */
	virtual VertexProcessingType getVertexProcessingType() const{
		return vertexProcessingType_;
	}

	/**
	 * A_v^tH[}bg̎擾
	 * @return A_v^tH[}bg
	 */
	virtual D3DFORMAT getAdapterFormat() const{ return adapterFormat_; }

	/**
	 * obNobt@tH[}bg̎擾
	 * @return obNobt@tH[}bg
	 */
	virtual D3DFORMAT getBackBufferFormat() const{ return backBufferFormat_; }

	/**
	 * obNobt@TCY̎擾
	 * @return obNobt@TCY
	 */
	virtual const DimensionI& getBackBufferSize() const{
		return backBufferSize_;
	}

	/**
	 * obNobt@AXyNg̎擾
	 * @return obNobt@AXyNg
	 */
	virtual float getBackBufferAspectRate() const{
		return ((float)backBufferSize_.width / (float)backBufferSize_.height);
	}

	/**
	 * tbV[g̎擾
	 * @return tbV[g
	 */
	virtual int getRefreshRate() const{ return refreshRate_; }

	/**
	 * [xAXeVobt@͗L
	 * @return [xAXeVobt@LȂtrue
	 */
	virtual bool getDepthStencilEnabled() const{ return depthStencilEnabled_; }

	/**
	 * [xAXeVtH[}bg̎擾
	 * @return [xAXeVtH[}bg
	 */
	virtual D3DFORMAT getDepthStencilFormat() const{
		return depthStencilFormat_;
	}

	/**
	 * v[e[VԊu̎擾
	 * @return v[e[VԊu
	 */
	virtual int getPresentationInterval() const{ return presentationInterval_; }

	/**
	 * }`Tv^Cv̎擾
	 * @return }`Tv^Cv
	 */
	virtual D3DMULTISAMPLE_TYPE getMultiSampleType() const{
		return multiSampleType_;
	}

	/**
	 * }`TvNHeB̎擾
	 * @return }`TvNHeB
	 */
	virtual u_int getMultiSampleQuality() const{ return multiSampleQuality_; }

	//--------------------------------------------------------------------------
	// foCX\
	//--------------------------------------------------------------------------
	/**
	 * }`_[^[Qbg̎擾
	 * @return }`_[^[Qbg
	 */
	virtual u_int getNumSimultaneousRTs() const{ return numSimultaneousRTs_; }

	/**
	 * VXeŎs̓T|[gĂ邩
	 * @return VXeŎsT|[gĂȂtrue
	 */
	virtual bool supportedExecuteSystemMemory() const{
		return executeSystemMemory_;
	}

	/**
	 * rfIŎs̓T|[gĂ邩
	 * @return rfIŎsT|[gĂȂtrue
	 */
	virtual bool supportedExecuteVideoMemory() const{
		return executeVideoMemory_;
	}

	/**
	 * VXeTL_̓T|[gĂ邩
	 * @return VXeTL_T|[gĂȂtrue
	 */
	virtual bool supportedTlVertexSystemMemory() const{
		return tlVertexSystemMemory_;
	}

	/**
	 * rfITL_̓T|[gĂ邩
	 * @return rfITL_T|[gĂȂtrue
	 */
	virtual bool supportedTlVertexVideoMemory() const{
		return tlVertexVideoMemory_;
	}

	/**
	 * VXẽeNX`̓T|[gĂ邩
	 * @return VXẽeNX`T|[gĂȂtrue
	 */
	virtual bool supportedTextureSystemMemory() const{
		return textureSystemMemory_;
	}

	/**
	 * rfĨeNX`̓T|[gĂ邩
	 * @return rfĨeNX`T|[gĂȂtrue
	 */
	virtual bool supportedTextureVideoMemory() const{
		return textureVideoMemory_;
	}

	/**
	 * TL_̕`̓T|[gĂ邩
	 * @return TL_̕`悪T|[gĂȂtrue
	 */
	virtual bool supportedDrawPrimTlVertex() const{
		return drawPrimTlVertex_;
	}

	/**
	 * tbṽ_O̓T|[gĂ邩
	 * @return tbṽ_OT|[gĂȂtrue
	 */
	virtual bool supportedCanRenderAfterFlip() const{
		return canRenderAfterFlip_;
	}

	/**
	 * 񃍁[JrfI̓T|[gĂ邩
	 * @return 񃍁[JrfIT|[gĂȂtrue
	 */
	virtual bool supportedTextureNonLocalVidedMemory() const{
		return textureNonLocalVidedMemory_;
	}

	/**
	 * DrawPrivitives2̓T|[gĂ邩
	 * @return DrawPrivitives2T|[gĂȂtrue
	 */
	virtual bool supportedDrawPrimitives2() const{ return drawPrimitives2_; }

	/**
	 * ƗeNX`v[̓T|[gĂ邩
	 * @return ƗeNX`v[T|[gĂȂtrue
	 */
	virtual bool supportedSeparateTextureMemories() const{
		return separateTextureMemories_;
	}

	/**
	 * DrawPrimitives2EX̓T|[gĂ邩
	 * @return DrawPrimitives2EXT|[gĂȂtrue
	 */
	virtual bool supportedDrawPrimitives2EX() const{
		return drawPrimitives2EX_;
	}

	/**
	 * n[hEFAT&L̓T|[gĂ邩
	 * @return n[hEFAT&LT|[gĂȂtrue
	 */
	virtual bool supportedHwTransformAndLight() const{
		return hwTransformAndLight_;
	}

	/**
	 * VXerfIւBLT̓T|[gĂ邩
	 * @return VXerfIւBLTT|[gĂȂtrue
	 */
	virtual bool supportedCanBltSystemToNonLocal() const{
		return canBltSystemToNonLocal_;
	}

	/**
	 * n[hEFAX^CY̓T|[gĂ邩
	 * @return n[hEFAX^CYT|[gĂȂtrue
	 */
	virtual bool supportedHwRasterization() const{ return hwRasterization_; }

	/**
	 * sAfoCX̓T|[gĂ邩
	 * @return sAfoCXT|[gĂȂtrue
	 */
	virtual bool supportedPureDevice() const{ return pureDevice_; }

	/**
	 * xWFABXvC̓T|[gĂ邩
	 * @return xWFABXvCT|[gĂȂtrue
	 */
	virtual bool supportedQuinticRtPatches() const{ return quinticRtPatches_; }

	/**
	 * `AOp`pb`̓T|[gĂ邩
	 * @return `AOp`pb`T|[gĂȂtrue
	 */
	virtual bool supportedRtPatches() const{ return rtPatches_; }

	/**
	 * Iȃnh0pb`̓T|[gĂ邩
	 * @return Iȃnh0pb`T|[gĂȂtrue
	 */
	virtual bool supportedRtPatchHanldeZero() const{
		return rtPatchHanldeZero_;
	}

	/**
	 * Npb`̓T|[gĂ邩
	 * @return Npb`T|[gĂȂtrue
	 */
	virtual bool supportedNPatches() const{ return nPatches_; }

	/**
	 * v[e[VԊu̓T|[gĂ邩
	 * @return v[e[VԊuT|[gĂȂtrue
	 */
	virtual bool supportedPresentationIntervalImmediate() const{
		return presentationIntervalImmediate_;
	}

	/**
	 * v[e[VԊu1̓T|[gĂ邩
	 * @return v[e[VԊu1T|[gĂȂtrue
	 */
	virtual bool supportedPresentationIntervalOne() const{
		return presentationIntervalOne_;
	}

	/**
	 * v[e[VԊu2̓T|[gĂ邩
	 * @return v[e[VԊu2T|[gĂȂtrue
	 */
	virtual bool supportedPresentationIntervalTwo() const{
		return presentationIntervalTwo_;
	}

	/**
	 * v[e[VԊu3̓T|[gĂ邩
	 * @return v[e[VԊu3T|[gĂȂtrue
	 */
	virtual bool supportedPresentationIntervalThree() const{
		return presentationIntervalThree_;
	}

	/**
	 * v[e[VԊu4̓T|[gĂ邩
	 * @return v[e[VԊu4T|[gĂȂtrue
	 */
	virtual bool supportedPresentationIntervalFour() const{
		return presentationIntervalFour_;
	}

	/**
	 * n[hEFAJ[\̓T|[gĂ邩
	 * @return n[hEFAJ[\T|[gĂȂtrue
	 */
	virtual bool supportedCursorColor() const{ return cursorColor_; }

	/**
	 * 𑜓xn[hEFAJ[\̓T|[gĂ邩
	 * @return 𑜓xn[hEFAJ[\T|[gĂȂtrue
	 */
	virtual bool supportedCursorLowRes() const{ return cursorLowRes_; }

	/**
	 * StretchRectMinPointtB^̓T|[gĂ邩
	 * @return StretchRectMinPointtB^T|[gĂȂtrue
	 */
	virtual bool supportedStretchRectMinPoint() const{
		return stretchRectMinPoint_;
	}

	/**
	 * StretchRectMagPointtB^̓T|[gĂ邩
	 * @return StretchRectMagPointtB^T|[gĂȂtrue
	 */
	virtual bool supportedStretchRectMagPoint() const{
		return stretchRectMagPoint_;
	}

	/**
	 * StretchRectMinLineartB^̓T|[gĂ邩
	 * @return StretchRectMinLineartB^T|[gĂȂtrue
	 */
	virtual bool supportedStretchRectMinLinear() const{
		return stretchRectMinLinear_;
	}

	/**
	 * StretchRectMagLineartB^̓T|[gĂ邩
	 * @return StretchRectMagLineartB^T|[gĂȂtrue
	 */
	virtual bool supportedStretchRectMagLinear() const{
		return stretchRectMagLinear_;
	}

	//--------------------------------------------------------------------------
	// foCX̑
	//--------------------------------------------------------------------------
	/**
	 * }X^[A_v^ԍ̎擾
	 * @return }X^[A_v^ԍ
	 */
	virtual u_int getMasterAdapterOrdinal() const{
		return masterAdapterOrdinal_;
	}

	/**
	 * O[ṽA_v^ԍ̎擾
	 * @return O[ṽA_v^ԍ
	 */
	virtual u_int getAdapterOrdinalInGroup() const{
		return adapterOrdinalInGroup_;
	}

	/**
	 * O[ṽA_v^̎擾
	 * @return O[ṽA_v^
	 */
	virtual u_int getNumberOfAdaptersInGroup() const{
		return numberOfAdaptersInGroup_;
	}

	/**
	 * Z}XN̓T|[gĂ邩
	 * @return Z}XNT|[gĂȂtrue
	 */
	virtual bool supportedMaskZ() const{ return maskZ_; }

	/**
	 * JO̓T|[gĂ邩
	 * @return JOT|[gĂȂtrue
	 */
	virtual bool supportedCullNone() const{ return cullNone_; }

	/**
	 * vJO̓T|[gĂ邩
	 * @return vJOT|[gĂȂtrue
	 */
	virtual bool supportedCullCW() const{ return cullCW_; }

	/**
	 * vJO̓T|[gĂ邩
	 * @return vJOT|[gĂȂtrue
	 */
	virtual bool supportedCullCCW() const{ return cullCCW_; }

	/**
	 * J[`l݂̓T|[gĂ邩
	 * @return J[`l݂T|[gĂȂtrue
	 */
	virtual bool supportedColorWriteEnable() const{ return colorWriteEnable_; }

	/**
	 * mȃ|CgNbv̓T|[gĂ邩
	 * @return mȃ|CgNbvT|[gĂȂtrue
	 */
	virtual bool supportedClipPlaneScaledPoints() const{
		return clipPlaneScaledPoints_;
	}

	/**
	 * _Nbv̓T|[gĂ邩
	 * @return _NbvT|[gĂȂtrue
	 */
	virtual bool supportedClipTlVerts() const{ return clipTlVerts_; }

	/**
	 * e|eNX`̓T|[gĂ邩
	 * @return e|eNX`T|[gĂȂtrue
	 */
	virtual bool supportedTssArgTemp() const{ return tssArgTemp_; }

	/**
	 * At@ufBO̓T|[gĂ邩
	 * @return At@ufBOT|[gĂȂtrue
	 */
	virtual bool supportedBlendOp() const{ return blendOp_; }

	/**
	 * kt@X̓T|[gĂ邩
	 * @return kt@XT|[gĂȂtrue
	 */
	virtual bool supportedNullReference() const{ return nullReference_; }

	/**
	 * Ɨ݃}XN̓T|[gĂ邩
	 * @return Ɨ݃}XNT|[gĂȂtrue
	 */
	virtual bool supportedIndependentWriteMasks() const{
		return independentWriteMasks_;
	}

	/**
	 * eNX`Xe[W萔̓T|[gĂ邩
	 * @return eNX`Xe[W萔T|[gĂȂtrue
	 */
	virtual bool supportedPerStageConstant() const{ return perStageConstant_; }

	/**
	 * tHOƃXyLAt@̓T|[gĂ邩
	 * @return tHOƃXyLAt@T|[gĂȂtrue
	 */
	virtual bool supportedFogAndSpecularAlpha() const{
		return fogAndSpecularAlpha_;
	}

	/**
	 * At@puh̓T|[gĂ邩
	 * @return At@puhT|[gĂȂtrue
	 */
	virtual bool supportedSeparateAlphaBlend() const{
		return separateAlphaBlend_;
	}

	/**
	 * MRTɈႤZ[x̓T|[gĂ邩
	 * @return MRTɈႤZ[xT|[gĂȂtrue
	 */
	virtual bool supportedMrtIndependentBitDepth() const{
		return mrtIndependentBitDepth_;
	}

	/**
	 * MRTɃsNZVF[_㏈̓T|[gĂ邩
	 * @return MRTɃsNZVF[_㏈T|[gĂȂtrue
	 */
	virtual bool supportedMrtPostPixelShaderBlending() const{
		return mrtPostPixelShaderBlending_;
	}

	/**
	 * _tHÕNv̓T|[gĂ邩
	 * @return _tHÕNvT|[gĂȂtrue
	 */
	virtual bool supportedFogVertexClamped() const{ return fogVertexClamped_; }

	//--------------------------------------------------------------------------
	// hCo\
	//--------------------------------------------------------------------------
	/**
	 * XLC̓ǂݍ݂̓T|[gĂ邩
	 * @return XLC̓ǂݍ݂T|[gĂȂtrue
	 */
	virtual bool supportedReadScanLine() const{ return readScanLine_; }

	/**
	 * tXN[K}̓T|[gĂ邩
	 * @return tXN[K}T|[gĂȂtrue
	 */
	virtual bool supportedFullscreenGamma() const{ return fullscreenGamma_; }

	/**
	 * Lu[gK}̓T|[gĂ邩
	 * @return Lu[gK}T|[gĂȂtrue
	 */
	virtual bool supportedCanCalibrateGamma() const{
		return canCalibrateGamma_;
	}

	/**
	 * }l[Wh\[X̓T|[gĂ邩
	 * @return }l[Wh\[XT|[gĂȂtrue
	 */
	virtual bool supportedCanManageResource() const{
		return canManageResource_;
	}

	/**
	 * IeNX`̓T|[gĂ邩
	 * @return IeNX`T|[gĂȂtrue
	 */
	virtual bool supportedDynamicTextures() const{ return dynamicTextures_; }

	/**
	 * ~bv}bv̓T|[gĂ邩
	 * @return ~bv}bvT|[gĂȂtrue
	 */
	virtual bool supportedCanAutogenMipmap() const{ return canAutogenMipmap_; }

	/**
	 * tXN[At@uh̓T|[gĂ邩
	 * @return tXN[At@uhT|[gĂȂtrue
	 */
	virtual bool supportedAlphaFullscreenFlipOrDiscard() const{
		return alphaFullscreenFlipOrDiscard_;
	}

	/**
	 * sRGBv[e[V̓T|[gĂ邩
	 * @return sRGBv[e[VT|[gĂȂtrue
	 */
	virtual bool supportedLinerToSrgbPresentation() const{
		return linerToSrgbPresentation_;
	}

	/**
	 * rfIւ̃Rs[̓T|[gĂ邩
	 * @return rfIւ̃Rs[T|[gĂȂtrue
	 */
	virtual bool supportedCopyToVideoMemory() const{
		return copyToVideoMemory_;
	}

	/**
	 * VXeւ̃Rs[̓T|[gĂ邩
	 * @return VXeւ̃Rs[T|[gĂȂtrue
	 */
	virtual bool supportedCopyToSystemMemory() const{
		return copyToSystemMemory_;
	}

	//--------------------------------------------------------------------------
	// v~eBu
	//--------------------------------------------------------------------------
	/**
	 * ő_TCY̎擾
	 * @return ő_TCY
	 */
	virtual float getMaxPointSize() const{ return maxPointSize_; }

	/**
	 * CeNX`̓T|[gĂ邩
	 * @return CeNX`T|[gĂȂtrue
	 */
	virtual bool supportedLineTexture() const{ return lineTexture_; }

	/**
	 * CZeXg̓T|[gĂ邩
	 * @return CZeXgT|[gĂȂtrue
	 */
	virtual bool supportedLineZTest() const{ return lineZTest_; }

	/**
	 * Cuh̓T|[gĂ邩
	 * @return CuhT|[gĂȂtrue
	 */
	virtual bool supportedLineBlend() const{ return lineBlend_; }

	/**
	 * CtHO̓T|[gĂ邩
	 * @return CtHOT|[gĂȂtrue
	 */
	virtual bool supportedLineFog() const{ return lineFog_; }

	/**
	 * CAt@r̓T|[gĂ邩
	 * @return CAt@rT|[gĂȂtrue
	 */
	virtual bool supportedLineAlphaCompare() const{ return lineAlphaCompare_; }

	/**
	 * CA`GCAX̓T|[gĂ邩
	 * @return CA`GCAXT|[gĂȂtrue
	 */
	virtual bool supportedLineAntialias() const{ return lineAntialias_; }

	//--------------------------------------------------------------------------
	// _
	//--------------------------------------------------------------------------
	/**
	 * őv~eBu̎擾
	 * @return őv~eBu
	 */
	virtual u_int getMaxPrimitiveCount() const{ return maxPrimitiveCount_; }

	/**
	 * őCfbNX̎擾
	 * @return őCfbNX
	 */
	virtual u_int getMaxVertexIndex() const{ return maxVertexIndex_; }

	/**
	 * őXg[̎擾
	 * @return őXg[
	 */
	virtual u_int getMaxStreams() const{ return maxStreams_; }

	/**
	 * ő僉Cg̎擾
	 * @return ő僉Cg
	 */
	virtual u_int getMaxActiveLights() const{ return maxActiveLights_; }

	/**
	 * őWl̎擾
	 * @return őWl
	 */
	virtual float getMaxVertexW() const{ return maxVertexW_; }

	/**
	 * őuhs񐔂̎擾
	 * @return őuhs
	 */
	virtual u_int getMaxVertexBlendMatrices() const{
		return maxVertexBlendMatrices_;
	}

	/**
	 * őuhsCfbNX̎擾
	 * @return őuhsCfbNX
	 */
	virtual u_int getMaxVertexBlendMatrixIndex() const{
		return maxVertexBlendMatrixIndex_;
	}

	/**
	 * K[hoh̎擾
	 * @return K[hoh
	 */
	virtual float getGuardBandLeft() const{ return guardBandLeft_; }

	/**
	 * K[hoh̎擾
	 * @return K[hoh
	 */
	virtual float getGuardBandTop() const{ return guardBandTop_; }

	/**
	 * K[hohE̎擾
	 * @return K[hohE
	 */
	virtual float getGuardBandRight() const{ return guardBandRight_; }

	/**
	 * K[hoh̎擾
	 * @return K[hoh
	 */
	virtual float getGuardBandBottom() const{ return guardBandBottom_; }

	/**
	 * ő僆[UNbvʂ̎擾
	 * @return ő僆[UNbv
	 */
	virtual u_int getMaxUserCliplanes() const{ return maxUserCliplanes_; }

	/**
	 * Texgen̓T|[gĂ邩
	 * @return TexgenT|[gĂȂtrue
	 */
	virtual bool supportedTexGen() const{ return texGen_; }

	/**
	 * J[}eA\[X̓T|[gĂ邩
	 * @return J[}eA\[XT|[gĂȂtrue
	 */
	virtual bool supportedMaterialSource() const{ return materialSource_; }

	/**
	 * fBNViCg̓T|[gĂ邩
	 * @return fBNViCgT|[gĂȂtrue
	 */
	virtual bool supportedDirectionalLights() const{
		return directionalLights_;
	}

	/**
	 * |WVCg̓T|[gĂ邩
	 * @return |WVCgT|[gĂȂtrue
	 */
	virtual bool supportedPositionalLights() const{ return positionalLights_; }

	/**
	 * [Jr[̓T|[gĂ邩
	 * @return [Jr[T|[gĂȂtrue
	 */
	virtual bool supportedLocalViewer() const{ return localViewer_; }

	/**
	 * _gDC[jO̓T|[gĂ邩
	 * @return _gDC[jOT|[gĂȂtrue
	 */
	virtual bool supportedTweening() const{ return tweening_; }

	/**
	 * XtBA}bv̓T|[gĂ邩
	 * @return XtBA}bvT|[gĂȂtrue
	 */
	virtual bool supportedTexgenSpheremap() const{ return texgenSpheremap_; }

	/**
	 * [Jr[OTexgens̓T|[gĂ邩
	 * @return [Jr[OTexgensT|[gĂȂtrue
	 */
	virtual bool supportedNoTexgenNonLocalViewer() const{
		return noTexgenNonLocalViewer_;
	}

	//--------------------------------------------------------------------------
	// _tH[}bg
	//--------------------------------------------------------------------------
	/**
	 * FVFeNX`WJEg}XN̓T|[gĂ邩
	 * @return FVFeNX`WJEg}XNT|[gĂȂtrue
	 */
	virtual bool supportedFvfTexCoordCountMask() const{
		return fvfTexCoordCountMask_;
	}

	/**
	 * FVF_ɗ]ȗvf܂߂̓T|[gĂ邩
	 * @return FVF_ɗ]ȗvf܂߂邪T|[gĂȂtrue
	 */
	virtual bool supportedFvfDoNotStripElements() const{
		return fvfDoNotStripElements_;
	}

	/**
	 * FVF_TCY̓T|[gĂ邩
	 * @return FVF_TCYT|[gĂȂtrue
	 */
	virtual bool supportedFvfPSize() const{ return fvfPSize_; }

	/**
	 * u_byte4錾̓T|[gĂ邩
	 * @return u_byte4錾T|[gĂȂtrue
	 */
	virtual bool supportedDeclUByte4() const{ return declUByte4_; }

	/**
	 * u_byte4N錾̓T|[gĂ邩
	 * @return u_byte4N錾T|[gĂȂtrue
	 */
	virtual bool supportedDeclUByte4N() const{ return declUByte4N_; }

	/**
	 * short2N錾̓T|[gĂ邩
	 * @return short2N錾T|[gĂȂtrue
	 */
	virtual bool supportedDeclShort2N() const{ return declShort2N_; }

	/**
	 * short4N錾̓T|[gĂ邩
	 * @return short4N錾T|[gĂȂtrue
	 */
	virtual bool supportedDeclShort4N() const{ return declShort4N_; }

	/**
	 * u_short2N錾̓T|[gĂ邩
	 * @return u_short2N錾T|[gĂȂtrue
	 */
	virtual bool supportedDeclUShort2N() const{ return declUShort2N_; }

	/**
	 * u_short4N錾̓T|[gĂ邩
	 * @return u_short4N錾T|[gĂȂtrue
	 */
	virtual bool supportedDeclUShort4N() const{ return declUShort4N_; }

	/**
	 * uDec3錾̓T|[gĂ邩
	 * @return uDec3錾T|[gĂȂtrue
	 */
	virtual bool supportedDeclUDec3() const{ return declUDec3_; }

	/**
	 * dec3錾̓T|[gĂ邩
	 * @return dec3錾T|[gĂȂtrue
	 */
	virtual bool supportedDeclDec3() const{ return declDec3_; }

	/**
	 * float16_2錾̓T|[gĂ邩
	 * @return float16_2錾T|[gĂȂtrue
	 */
	virtual bool supportedDeclFloat16_2() const{ return declFloat16_2_; }

	/**
	 * float16_4錾̓T|[gĂ邩
	 * @return float16_4錾T|[gĂȂtrue
	 */
	virtual bool supportedDeclFloat16_4() const{ return declFloat16_4_; }

	//--------------------------------------------------------------------------
	// ebZ[V
	//--------------------------------------------------------------------------
	/**
	 * Npb`ő啪x̎擾
	 * @return Npb`ő啪x
	 */
	virtual float getMaxNPatchTesselationLevel() const{
		return maxNPatchTesselationLevel_;
	}

	/**
	 * Xg[ItZbg̓T|[gĂ邩
	 * @return Xg[ItZbgT|[gĂȂtrue
	 */
	virtual bool supportedStreamOffset() const{ return streamOffset_; }

	/**
	 * fBXv[XgNpb`̓T|[gĂ邩
	 * @return fBXv[XgNpb`T|[gĂȂtrue
	 */
	virtual bool supportedDmapNPatch() const{ return dmapNPatch_; }

	/**
	 *K^RTpb` ̓T|[gĂ邩
	 * @return K^RTpb`T|[gĂȂtrue
	 */
	virtual bool supportedAdaptiveTessRTPatch() const{
		return adaptiveTessRTPatch_;
	}

	/**
	 * K^Npb`̓T|[gĂ邩
	 * @return K^Npb`T|[gĂȂtrue
	 */
	virtual bool supportedAdaptiveTessNPatch() const{
		return adaptiveTessNPatch_;
	}

	/**
	 * eNX`StretchRect̓T|[gĂ邩
	 * @return eNX`StretchRectT|[gĂȂtrue
	 */
	virtual bool supportedCanStretchRectFromTextures() const{
		return canStretchRectFromTextures_;
	}

	/**
	 * vfBXv[XhNpb`̓T|[gĂ邩
	 * @return vfBXv[XhNpb`T|[gĂȂtrue
	 */
	virtual bool supportedPreSampledDmapNPatch() const{
		return preSampledDmapNPatch_;
	}

	/**
	 * Xg[ItZbgL̓T|[gĂ邩
	 * @return Xg[ItZbgLT|[gĂȂtrue
	 */
	virtual bool supportedVertexElementsCanShareStreamOffset() const{
		return vertexElementsCanShareStreamOffset_;
	}

	//--------------------------------------------------------------------------
	// VF[fBO
	//--------------------------------------------------------------------------
	/**
	 * J[O[̓T|[gĂ邩
	 * @return J[O[T|[gĂȂtrue
	 */
	virtual bool supportedShadeColorGouraudRGB() const{
		return shadeColorGouraudRGB_;
	}

	/**
	 * XyLO[̓T|[gĂ邩
	 * @return XyLO[T|[gĂȂtrue
	 */
	virtual bool supportedShadeSpecularGouraudRGB() const{
		return shadeSpecularGouraudRGB_;
	}

	/**
	 * At@O[̓T|[gĂ邩
	 * @return At@O[T|[gĂȂtrue
	 */
	virtual bool supportedShadeAlphaGouraudBlend() const{
		return shadeAlphaGouraudBlend_;
	}

	/**
	 * tHOO[̓T|[gĂ邩
	 * @return tHOO[T|[gĂȂtrue
	 */
	virtual bool supportedShadeFogGouraud() const{ return shadeFogGouraud_; }

	//--------------------------------------------------------------------------
	// eNX`
	//--------------------------------------------------------------------------
	/**
	 * őeNX`TCY̎擾
	 * @return őeNX`TCY
	 */
	virtual const DimensionI& getMaxTextureSize() const{
		return maxTextureSize_;
	}

	/**
	 * ő{[eNX`ӂ̎擾
	 * @return ő{[eNX`
	 */
	virtual u_int getMaxVolumeExtent() const{ return maxVolumeExtent_; }

	/**
	 * őeNX`s[g̎擾
	 * @return őeNX`s[g
	 */
	virtual u_int getMaxTextureRepeat() const{ return maxTextureRepeat_; }

	/**
	 * őٕtB^l̎擾
	 * @return őٕtB^l
	 */
	virtual u_int getMaxAnisotropy() const{ return maxAnisotropy_; }

	/**
	 * őeNX`AXyNg̎擾
	 * @return őeNX`AXyNg
	 */
	virtual u_int getMaxTextureAspectRaito() const{
		return maxTextureAspectRaito_;
	}

	/**
	 * p[XyNeBu␳̓T|[gĂ邩
	 * @return p[XyNeBu␳T|[gĂȂtrue
	 */
	virtual bool supportedTexturePerspective() const{
		return texturePerspective_;
	}

	/**
	 * ӂ2̗ݏ݂̂̓T|[gĂ邩
	 * @return ӂ2̗ݏ݂̂T|[gĂȂtrue
	 */
	virtual bool supportedTexturePow2() const{ return texturePow2_; }

	/**
	 * At@̓T|[gĂ邩
	 * @return At@T|[gĂȂtrue
	 */
	virtual bool supportedTextureAlpha() const{ return textureAlpha_; }

	/**
	 * `݂̂̓T|[gĂ邩
	 * @return `݂̂T|[gĂȂtrue
	 */
	virtual bool supportedTextureSquareOnly() const{
		return textureSquareOnly_;
	}

	/**
	 * s[gXP[̓T|[gĂ邩
	 * @return s[gXP[T|[gĂȂtrue
	 */
	virtual bool supportedTextureRepeatNotScaledBySize() const{
		return textureRepeatNotScaledBySize_;
	}

	/**
	 * At@pbg̓T|[gĂ邩
	 * @return At@pbgT|[gĂȂtrue
	 */
	virtual bool supportedTextureAlphaPalette() const{
		return textureAlphaPalette_;
	}

	/**
	 * ӂ2̗ݏŖĂ悢̓T|[gĂ邩
	 * @return ӂ2̗ݏŖĂ悢T|[gĂȂtrue
	 */
	virtual bool supportedTextureNonPow2Conditional() const{
		return textureNonPow2Conditional_;
	}

	/**
	 * ˉe̓T|[gĂ邩
	 * @return ˉeT|[gĂȂtrue
	 */
	virtual bool supportedTextureProjected() const{ return textureProjected_; }

	/**
	 * L[u}bv̓T|[gĂ邩
	 * @return L[u}bvT|[gĂȂtrue
	 */
	virtual bool supportedTextureCubemap() const{ return textureCubemap_; }

	/**
	 * {[}bv̓T|[gĂ邩
	 * @return {[}bvT|[gĂȂtrue
	 */
	virtual bool supportedTextureVolumemap() const{ return textureVolumemap_; }

	/**
	 * ~bv}bv̓T|[gĂ邩
	 * @return ~bv}bvT|[gĂȂtrue
	 */
	virtual bool supportedTextureMipmap() const{ return textureMipmap_; }

	/**
	 * L[u~bv}bv̓T|[gĂ邩
	 * @return L[u~bv}bvT|[gĂȂtrue
	 */
	virtual bool supportedTextureMipmapCubemap() const{
		return textureMipmapCubemap_;
	}

	/**
	 * {[~bv}bv̓T|[gĂ邩
	 * @return {[~bv}bvT|[gĂȂtrue
	 */
	virtual bool supportedTextureMipmapVolumemap() const{
		return textureMipmapVolumemap_;
	}

	/**
	 * L[u}bvӂ2̗ݏ݂̂̓T|[gĂ邩
	 * @return L[u}bvӂ2̗ݏ݂̂T|[gĂȂtrue
	 */
	virtual bool supportedTextureCubemapPow2() const{
		return textureCubemapPow2_;
	}

	/**
	 * {[}bvӂ2̗ݏ݂̂̓T|[gĂ邩
	 * @return {[}bvӂ2̗ݏ݂̂T|[gĂȂtrue
	 */
	virtual bool supportedTextureVolumemapPow2() const{
		return textureVolumemapPow2_;
	}

	/**
	 * ˉeov}bv̓T|[gĂ邩
	 * @return ˉeov}bvT|[gĂȂtrue
	 */
	virtual bool supportedTextureNoProjectedBumpEnvironment() const{
		return textureNoProjectedBumpEnvironment_;
	}

	//--------------------------------------------------------------------------
	// eNX`AhX
	//--------------------------------------------------------------------------
	/**
	 * bv̓T|[gĂ邩
	 * @return bvT|[gĂȂtrue
	 */
	virtual bool supportedTextureAddressWrap() const{
		return textureAddressWrap_;
	}

	/**
	 * ~[̓T|[gĂ邩
	 * @return ~[T|[gĂȂtrue
	 */
	virtual bool supportedTextureAddressMirror() const{
		return textureAddressMirror_;
	}

	/**
	 * UṼNv̓T|[gĂ邩
	 * @return UṼNvT|[gĂȂtrue
	 */
	virtual bool supportedTextureAddressClamp() const{
		return textureAddressClamp_;
	}

	/**
	 * EF̐ݒ̓T|[gĂ邩
	 * @return EF̐ݒ肪T|[gĂȂtrue
	 */
	virtual bool supportedTextureAddressBorder() const{
		return textureAddressBorder_;
	}

	/**
	 * ƗUV[h̓T|[gĂ邩
	 * @return ƗUV[hT|[gĂȂtrue
	 */
	virtual bool supportedTextureAddressIndependentUV() const{
		return textureAddressIndependentUV_;
	}

	/**
	 * 1~[̓T|[gĂ邩
	 * @return 1~[T|[gĂȂtrue
	 */
	virtual bool supportedTextureAddressMirrorOnce() const{
		return textureAddressMirrorOnce_;
	}

	/**
	 * {[bv̓T|[gĂ邩
	 * @return {[bvT|[gĂȂtrue
	 */
	virtual bool supportedVolumeTextureAddressWrap() const{
		return volumeTextureAddressWrap_;
	}

	/**
	 * {[~[̓T|[gĂ邩
	 * @return {[~[T|[gĂȂtrue
	 */
	virtual bool supportedVolumeTextureAddressMirror() const{
		return volumeTextureAddressMirror_;
	}

	/**
	 * {[UṼNv̓T|[gĂ邩
	 * @return {[UṼNvT|[gĂȂtrue
	 */
	virtual bool supportedVolumeTextureAddressClamp() const{
		return volumeTextureAddressClamp_;
	}

	/**
	 * {[EF̐ݒ̓T|[gĂ邩
	 * @return {[EF̐ݒ肪T|[gĂȂtrue
	 */
	virtual bool supportedVolumeTextureAddressBorder() const{
		return volumeTextureAddressBorder_;
	}

	/**
	 * {[ƗUV[h̓T|[gĂ邩
	 * @return {[ƗUV[hT|[gĂȂtrue
	 */
	virtual bool supportedVolumeTextureAddressIndependentUV() const{
		return volumeTextureAddressIndependentUV_;
	}

	/**
	 * {[1~[̓T|[gĂ邩
	 * @return {[1~[T|[gĂȂtrue
	 */
	virtual bool supportedVolumeTextureAddressMirrorOnce() const{
		return volumeTextureAddressMirrorOnce_;
	}

	//--------------------------------------------------------------------------
	// eNX`tB^
	//--------------------------------------------------------------------------
	/**
	 * k|Cg̓T|[gĂ邩
	 * @return k|CgT|[gĂȂtrue
	 */
	virtual bool supportedTextureFilterMinPoint() const{
		return textureFilterMinPoint_;
	}

	/**
	 * k`̓T|[gĂ邩
	 * @return k`T|[gĂȂtrue
	 */
	virtual bool supportedTextureFilterMinLiner() const{
		return textureFilterMinLiner_;
	}

	/**
	 * kٕ̓T|[gĂ邩
	 * @return kٕT|[gĂȂtrue
	 */
	virtual bool supportedTextureFilterMinAnisotropic() const{
		return textureFilterMinAnisotropic_;
	}

	/**
	 * ks~bh̓T|[gĂ邩
	 * @return ks~bhT|[gĂȂtrue
	 */
	virtual bool supportedTextureFilterMinPyramidalQuad() const{
		return textureFilterMinPyramidalQuad_;
	}

	/**
	 * k2KEX̓T|[gĂ邩
	 * @return k2KEXT|[gĂȂtrue
	 */
	virtual bool supportedTextureFilterMinGaussianQuad() const{
		return textureFilterMinGaussianQuad_;
	}

	/**
	 * g|Cg̓T|[gĂ邩
	 * @return g|CgT|[gĂȂtrue
	 */
	virtual bool supportedTextureFilterMagPoint() const{
		return textureFilterMagPoint_;
	}

	/**
	 * g`̓T|[gĂ邩
	 * @return g`T|[gĂȂtrue
	 */
	virtual bool supportedTextureFilterMagLiner() const{
		return textureFilterMagLiner_;
	}

	/**
	 * gٕ̓T|[gĂ邩
	 * @return gٕT|[gĂȂtrue
	 */
	virtual bool supportedTextureFilterMagAnisotropic() const{
		return textureFilterMagAnisotropic_;
	}

	/**
	 * gs~bh̓T|[gĂ邩
	 * @return gs~bhT|[gĂȂtrue
	 */
	virtual bool supportedTextureFilterMagPyramidalQuad() const{
		return textureFilterMagPyramidalQuad_;
	}

	/**
	 * g2KEX̓T|[gĂ邩
	 * @return g2KEXT|[gĂȂtrue
	 */
	virtual bool supportedTextureFilterMagGaussianQuad() const{
		return textureFilterMagGaussianQuad_;
	}

	/**
	 * ~bv}bv|Cg̓T|[gĂ邩
	 * @return ~bv}bv|CgT|[gĂȂtrue
	 */
	virtual bool supportedTextureFilterMipmapPoint() const{
		return textureFilterMipmapPoint_;
	}

	/**
	 * ~bv}bv`̓T|[gĂ邩
	 * @return ~bv}bv`T|[gĂȂtrue
	 */
	virtual bool supportedTextureFilterMipmapLiner() const{
		return textureFilterMipmapLiner_;
	}

	//--------------------------------------------------------------------------
	/**
	 * L[uk|Cg̓T|[gĂ邩
	 * @return L[uk|CgT|[gĂȂtrue
	 */
	virtual bool supportedCubeTextureFilterMinPoint() const{
		return cubeTextureFilterMinPoint_;
	}

	/**
	 * L[uk`̓T|[gĂ邩
	 * @return L[uk`T|[gĂȂtrue
	 */
	virtual bool supportedCubeTextureFilterMinLiner() const{
		return cubeTextureFilterMinLiner_;
	}

	/**
	 * L[ukٕ̓T|[gĂ邩
	 * @return L[ukٕT|[gĂȂtrue
	 */
	virtual bool supportedCubeTextureFilterMinAnisotropic() const{
		return cubeTextureFilterMinAnisotropic_;
	}

	/**
	 * L[uks~bh̓T|[gĂ邩
	 * @return L[uks~bhT|[gĂȂtrue
	 */
	virtual bool supportedCubeTextureFilterMinPyramidalQuad() const{
		return cubeTextureFilterMinPyramidalQuad_;
	}

	/**
	 * L[uk2KEX̓T|[gĂ邩
	 * @return L[uk2KEXT|[gĂȂtrue
	 */
	virtual bool supportedCubeTextureFilterMinGaussianQuad() const{
		return cubeTextureFilterMinGaussianQuad_;
	}

	/**
	 * L[ug|Cg̓T|[gĂ邩
	 * @return L[ug|CgT|[gĂȂtrue
	 */
	virtual bool supportedCubeTextureFilterMagPoint() const{
		return cubeTextureFilterMagPoint_;
	}

	/**
	 * L[ug`̓T|[gĂ邩
	 * @return L[ug`T|[gĂȂtrue
	 */
	virtual bool supportedCubeTextureFilterMagLiner() const{
		return cubeTextureFilterMagLiner_;
	}

	/**
	 * L[ugٕ̓T|[gĂ邩
	 * @return L[ugٕT|[gĂȂtrue
	 */
	virtual bool supportedCubeTextureFilterMagAnisotropic() const{
		return cubeTextureFilterMagAnisotropic_;
	}

	/**
	 * L[ugs~bh̓T|[gĂ邩
	 * @return L[ugs~bhT|[gĂȂtrue
	 */
	virtual bool supportedCubeTextureFilterMagPyramidalQuad() const{
		return cubeTextureFilterMagPyramidalQuad_;
	}

	/**
	 * L[ug2KEX̓T|[gĂ邩
	 * @return L[ug2KEXT|[gĂȂtrue
	 */
	virtual bool supportedCubeTextureFilterMagGaussianQuad() const{
		return cubeTextureFilterMagGaussianQuad_;
	}

	/**
	 * L[u~bv}bv|Cg̓T|[gĂ邩
	 * @return L[u~bv}bv|CgT|[gĂȂtrue
	 */
	virtual bool supportedCubeTextureFilterMipmapPoint() const{
		return cubeTextureFilterMipmapPoint_;
	}

	/**
	 * L[u~bv}bv`̓T|[gĂ邩
	 * @return L[u~bv}bv`T|[gĂȂtrue
	 */
	virtual bool supportedCubeTextureFilterMipmapLiner() const{
		return cubeTextureFilterMipmapLiner_;
	}

	//--------------------------------------------------------------------------
	/**
	 * {[k|Cg̓T|[gĂ邩
	 * @return {[k|CgT|[gĂȂtrue
	 */
	virtual bool supportedVolumeTextureFilterMinPoint() const{
		return volumeTextureFilterMinPoint_;
	}

	/**
	 * {[k`̓T|[gĂ邩
	 * @return {[k`T|[gĂȂtrue
	 */
	virtual bool supportedVolumeTextureFilterMinLiner() const{
		return volumeTextureFilterMinLiner_;
	}

	/**
	 * {[kٕ̓T|[gĂ邩
	 * @return {[kٕT|[gĂȂtrue
	 */
	virtual bool supportedVolumeTextureFilterMinAnisotropic() const{
		return volumeTextureFilterMinAnisotropic_;
	}

	/**
	 * {[ks~bh̓T|[gĂ邩
	 * @return {[ks~bhT|[gĂȂtrue
	 */
	virtual bool supportedVolumeTextureFilterMinPyramidalQuad() const{
		return volumeTextureFilterMinPyramidalQuad_;
	}

	/**
	 * {[k2KEX̓T|[gĂ邩
	 * @return {[k2KEXT|[gĂȂtrue
	 */
	virtual bool supportedVolumeTextureFilterMinGaussianQuad() const{
		return volumeTextureFilterMinGaussianQuad_;
	}

	/**
	 * {[g|Cg̓T|[gĂ邩
	 * @return {[g|CgT|[gĂȂtrue
	 */
	virtual bool supportedVolumeTextureFilterMagPoint() const{
		return volumeTextureFilterMagPoint_;
	}

	/**
	 * {[g`̓T|[gĂ邩
	 * @return {[g`T|[gĂȂtrue
	 */
	virtual bool supportedVolumeTextureFilterMagLiner() const{
		return volumeTextureFilterMagLiner_;
	}

	/**
	 * {[gٕ̓T|[gĂ邩
	 * @return {[gٕT|[gĂȂtrue
	 */
	virtual bool supportedVolumeTextureFilterMagAnisotropic() const{
		return volumeTextureFilterMagAnisotropic_;
	}

	/**
	 * {[gs~bh̓T|[gĂ邩
	 * @return {[gs~bhT|[gĂȂtrue
	 */
	virtual bool supportedVolumeTextureFilterMagPyramidalQuad() const{
		return volumeTextureFilterMagPyramidalQuad_;
	}

	/**
	 * {[g2KEX̓T|[gĂ邩
	 * @return {[g2KEXT|[gĂȂtrue
	 */
	virtual bool supportedVolumeTextureFilterMagGaussianQuad() const{
		return volumeTextureFilterMagGaussianQuad_;
	}

	/**
	 * {[~bv}bv|Cg̓T|[gĂ邩
	 * @return {[~bv}bv|CgT|[gĂȂtrue
	 */
	virtual bool supportedVolumeTextureFilterMipmapPoint() const{
		return volumeTextureFilterMipmapPoint_;
	}

	/**
	 * {[~bv}bv`̓T|[gĂ邩
	 * @return {[~bv}bv`T|[gĂȂtrue
	 */
	virtual bool supportedVolumeTextureFilterMipmapLiner() const{
		return volumeTextureFilterMipmapLiner_;
	}

	//--------------------------------------------------------------------------
	/**
	 * _k|Cg̓T|[gĂ邩
	 * @return _k|CgT|[gĂȂtrue
	 */
	virtual bool supportedVertexTextureFilterMinPoint() const{
		return vertexTextureFilterMinPoint_;
	}

	/**
	 * _k`̓T|[gĂ邩
	 * @return _k`T|[gĂȂtrue
	 */
	virtual bool supportedVertexTextureFilterMinLiner() const{
		return vertexTextureFilterMinLiner_;
	}

	/**
	 * _kٕ̓T|[gĂ邩
	 * @return _kٕT|[gĂȂtrue
	 */
	virtual bool supportedVertexTextureFilterMinAnisotropic() const{
		return vertexTextureFilterMinAnisotropic_;
	}

	/**
	 * _ks~bh̓T|[gĂ邩
	 * @return _ks~bhT|[gĂȂtrue
	 */
	virtual bool supportedVertexTextureFilterMinPyramidalQuad() const{
		return vertexTextureFilterMinPyramidalQuad_;
	}

	/**
	 * _k2KEX̓T|[gĂ邩
	 * @return _k2KEXT|[gĂȂtrue
	 */
	virtual bool supportedVertexTextureFilterMinGaussianQuad() const{
		return vertexTextureFilterMinGaussianQuad_;
	}

	/**
	 * _g|Cg̓T|[gĂ邩
	 * @return _g|CgT|[gĂȂtrue
	 */
	virtual bool supportedVertexTextureFilterMagPoint() const{
		return vertexTextureFilterMagPoint_;
	}

	/**
	 * _g`̓T|[gĂ邩
	 * @return _g`T|[gĂȂtrue
	 */
	virtual bool supportedVertexTextureFilterMagLiner() const{
		return vertexTextureFilterMagLiner_;
	}

	/**
	 * _gٕ̓T|[gĂ邩
	 * @return _gٕT|[gĂȂtrue
	 */
	virtual bool supportedVertexTextureFilterMagAnisotropic() const{
		return vertexTextureFilterMagAnisotropic_;
	}

	/**
	 * _gs~bh̓T|[gĂ邩
	 * @return _gs~bhT|[gĂȂtrue
	 */
	virtual bool supportedVertexTextureFilterMagPyramidalQuad() const{
		return vertexTextureFilterMagPyramidalQuad_;
	}

	/**
	 * _g2KEX̓T|[gĂ邩
	 * @return _g2KEXT|[gĂȂtrue
	 */
	virtual bool supportedVertexTextureFilterMagGaussianQuad() const{
		return vertexTextureFilterMagGaussianQuad_;
	}

	/**
	 * _~bv}bv|Cg̓T|[gĂ邩
	 * @return _~bv}bv|CgT|[gĂȂtrue
	 */
	virtual bool supportedVertexTextureFilterMipmapPoint() const{
		return vertexTextureFilterMipmapPoint_;
	}

	/**
	 * _~bv}bv`̓T|[gĂ邩
	 * @return _~bv}bv`T|[gĂȂtrue
	 */
	virtual bool supportedVertexTextureFilterMipmapLiner() const{
		return vertexTextureFilterMipmapLiner_;
	}

	//--------------------------------------------------------------------------
	// eNX`Xe[W
	//--------------------------------------------------------------------------
	/**
	 * őeNX`Xe[W̎擾
	 * @return őeNX`Xe[W
	 */
	virtual u_int getMaxTextureBlendStages() const{
		return maxTextureBlendStages_;
	}

	/**
	 * ő}`eNX`̎擾
	 * @return ő}`eNX`
	 */
	virtual u_int getMaxSimultaneousTextures() const{
		return maxSimultaneousTextures_;
	}

	/**
	 * DisableIy[V̓T|[gĂ邩
	 * @return DisableIy[VT|[gĂȂtrue
	 */
	virtual bool supportedTextureOperationDisable() const{
		return textureOperationDisable_;
	}

	/**
	 * SelectArg1Iy[V̓T|[gĂ邩
	 * @return SelectArg1Iy[VT|[gĂȂtrue
	 */
	virtual bool supportedTextureOperationSelectArg1() const{
		return textureOperationSelectArg1_;
	}

	/**
	 * SelectArg2Iy[V̓T|[gĂ邩
	 * @return SelectArg2Iy[VT|[gĂȂtrue
	 */
	virtual bool supportedTextureOperationSelectArg2() const{
		return textureOperationSelectArg2_;
	}

	/**
	 * ModulateIy[V̓T|[gĂ邩
	 * @return ModulateIy[VT|[gĂȂtrue
	 */
	virtual bool supportedTextureOperationModulate() const{
		return textureOperationModulate_;
	}

	/**
	 * Modulate2xIy[V̓T|[gĂ邩
	 * @return Modulate2xIy[VT|[gĂȂtrue
	 */
	virtual bool supportedTextureOperationModulate2x() const{
		return textureOperationModulate2x_;
	}

	/**
	 * Modulate4xIy[V̓T|[gĂ邩
	 * @return Modulate4xIy[VT|[gĂȂtrue
	 */
	virtual bool supportedTextureOperationModulate4x() const{
		return textureOperationModulate4x_;
	}

	/**
	 * AddIy[V̓T|[gĂ邩
	 * @return AddIy[VT|[gĂȂtrue
	 */
	virtual bool supportedTextureOperationAdd() const{
		return textureOperationAdd_;
	}

	/**
	 * AddSignedIy[V̓T|[gĂ邩
	 * @return AddSignedIy[VT|[gĂȂtrue
	 */
	virtual bool supportedTextureOperationAddSigned() const{
		return textureOperationAddSigned_;
	}

	/**
	 * AddSigned2xIy[V̓T|[gĂ邩
	 * @return AddSigned2xIy[VT|[gĂȂtrue
	 */
	virtual bool supportedTextureOperationAddSigned2x() const{
		return textureOperationAddSigned2x_;
	}

	/**
	 * SubtractIy[V̓T|[gĂ邩
	 * @return SubtractIy[VT|[gĂȂtrue
	 */
	virtual bool supportedTextureOperationSubtract() const{
		return textureOperationSubtract_;
	}

	/**
	 * AddSmoothIy[V̓T|[gĂ邩
	 * @return AddSmoothIy[VT|[gĂȂtrue
	 */
	virtual bool supportedTextureOperationAddSmooth() const{
		return textureOperationAddSmooth_;
	}

	/**
	 * BlendDiffuseAlphaIy[V̓T|[gĂ邩
	 * @return BlendDiffuseAlphaIy[VT|[gĂȂtrue
	 */
	virtual bool supportedTextureOperationBlendDiffuseAlpha() const{
		return textureOperationBlendDiffuseAlpha_;
	}

	/**
	 * BlendTextureAlphaIy[V̓T|[gĂ邩
	 * @return BlendTextureAlphaIy[VT|[gĂȂtrue
	 */
	virtual bool supportedTextureOperationBlendTextureAlpha() const{
		return textureOperationBlendTextureAlpha_;
	}

	/**
	 * BlendFactorAlphaIy[V̓T|[gĂ邩
	 * @return BlendFactorAlphaIy[VT|[gĂȂtrue
	 */
	virtual bool supportedTextureOperationBlendFactorAlpha() const{
		return textureOperationBlendFactorAlpha_;
	}

	/**
	 * BlendTextureAlphaPMIy[V̓T|[gĂ邩
	 * @return BlendTextureAlphaPMIy[VT|[gĂȂtrue
	 */
	virtual bool supportedTextureOperationBlendTextureAlphaPM() const{
		return textureOperationBlendTextureAlphaPM_;
	}

	/**
	 * BlendCurrentAlphaIy[V̓T|[gĂ邩
	 * @return BlendCurrentAlphaIy[VT|[gĂȂtrue
	 */
	virtual bool supportedTextureOperationBlendCurrentAlpha() const{
		return textureOperationBlendCurrentAlpha_;
	}

	/**
	 * PreModulateIy[V̓T|[gĂ邩
	 * @return PreModulateIy[VT|[gĂȂtrue
	 */
	virtual bool supportedTextureOperationPreModulate() const{
		return textureOperationPreModulate_;
	}

	/**
	 * ModulateAlphaAddColorIy[V̓T|[gĂ邩
	 * @return ModulateAlphaAddColorIy[VT|[gĂȂtrue
	 */
	virtual bool supportedTextureOperationModulateAlphaAddColor() const{
		return textureOperationModulateAlphaAddColor_;
	}

	/**
	 * ModulateColorAddAlphaIy[V̓T|[gĂ邩
	 * @return ModulateColorAddAlphaIy[VT|[gĂȂtrue
	 */
	virtual bool supportedTextureOperationModulateColorAddAlpha() const{
		return textureOperationModulateColorAddAlpha_;
	}

	/**
	 * ModulateInvAlphaAddColorIy[V̓T|[gĂ邩
	 * @return ModulateInvAlphaAddColorIy[VT|[gĂȂtrue
	 */
	virtual bool supportedTextureOperationModulateInvAlphaAddColor() const{
		return textureOperationModulateInvAlphaAddColor_;
	}

	/**
	 * ModulateInvColorAddAlphaIy[V̓T|[gĂ邩
	 * @return ModulateInvColorAddAlphaIy[VT|[gĂȂtrue
	 */
	virtual bool supportedTextureOperationModulateInvColorAddAlpha() const{
		return textureOperationModulateInvColorAddAlpha_;
	}

	/**
	 * BumpEnvMapIy[V̓T|[gĂ邩
	 * @return BumpEnvMapIy[VT|[gĂȂtrue
	 */
	virtual bool supportedTextureOperationBumpEnvMap() const{
		return textureOperationBumpEnvMap_;
	}

	/**
	 * BumpEnvMapLuminanceIy[V̓T|[gĂ邩
	 * @return BumpEnvMapLuminanceIy[VT|[gĂȂtrue
	 */
	virtual bool supportedTextureOperationBumpEnvMapLuminance() const{
		return textureOperationBumpEnvMapLuminance_;
	}

	/**
	 * DotProduct3Iy[V̓T|[gĂ邩
	 * @return DotProduct3Iy[VT|[gĂȂtrue
	 */
	virtual bool supportedTextureOperationDotProduct3() const{
		return textureOperationDotProduct3_;
	}

	/**
	 * MultiplyAddIy[V̓T|[gĂ邩
	 * @return MultiplyAddIy[VT|[gĂȂtrue
	 */
	virtual bool supportedTextureOperationMultiplyAdd() const{
		return textureOperationMultiplyAdd_;
	}

	/**
	 * LerpIy[V̓T|[gĂ邩
	 * @return LerpIy[VT|[gĂȂtrue
	 */
	virtual bool supportedTextureOperationLerp() const{
		return textureOperationLerp_;
	}

	//--------------------------------------------------------------------------
	// r
	//--------------------------------------------------------------------------
	/**
	 * ZrNever̓T|[gĂ邩
	 * @return ZrNeverT|[gĂȂtrue
	 */
	virtual bool supportedZCompareNever() const{ return zCompareNever_; }

	/**
	 * ZrLess̓T|[gĂ邩
	 * @return ZrLessT|[gĂȂtrue
	 */
	virtual bool supportedZCompareLess() const{ return zCompareLess_; }

	/**
	 * ZrEqual̓T|[gĂ邩
	 * @return ZrEqualT|[gĂȂtrue
	 */
	virtual bool supportedZCompareEqual() const{ return zCompareEqual_; }

	/**
	 * ZrLessEqual̓T|[gĂ邩
	 * @return ZrLessEqualT|[gĂȂtrue
	 */
	virtual bool supportedZCompareLessEqual() const{
		return zCompareLessEqual_;
	}

	/**
	 * ZrGreater̓T|[gĂ邩
	 * @return ZrGreaterT|[gĂȂtrue
	 */
	virtual bool supportedZCompareGreater() const{ return zCompareGreater_; }

	/**
	 * ZrNotEqual̓T|[gĂ邩
	 * @return ZrNotEqualT|[gĂȂtrue
	 */
	virtual bool supportedZCompareNotEqual() const{ return zCompareNotEqual_; }

	/**
	 * ZrGreaterEqual̓T|[gĂ邩
	 * @return ZrGreaterEqualT|[gĂȂtrue
	 */
	virtual bool supportedZCompareGreaterEqual() const{
		return zCompareGreaterEqual_;
	}

	/**
	 * ZrAlways̓T|[gĂ邩
	 * @return ZrAlwaysT|[gĂȂtrue
	 */
	virtual bool supportedZCompareAlways() const{ return zCompareAlways_; }

	//--------------------------------------------------------------------------
	/**
	 * XeVKeep̓T|[gĂ邩
	 * @return XeVKeepT|[gĂȂtrue
	 */
	virtual bool supportedStencilKeep() const{ return stencilKeep_; }

	/**
	 * XeVZero̓T|[gĂ邩
	 * @return XeVZeroT|[gĂȂtrue
	 */
	virtual bool supportedStencilZero() const{ return stencilZero_; }

	/**
	 * XeVReplace̓T|[gĂ邩
	 * @return XeVReplaceT|[gĂȂtrue
	 */
	virtual bool supportedStencilReplace() const{ return stencilReplace_; }

	/**
	 * XeVIncrSat̓T|[gĂ邩
	 * @return XeVIncrSatT|[gĂȂtrue
	 */
	virtual bool supportedStencilIncrSat() const{ return stencilIncrSat_; }

	/**
	 * XeVDecrSat̓T|[gĂ邩
	 * @return XeVDecrSatT|[gĂȂtrue
	 */
	virtual bool supportedStencilDecrSat() const{ return stencilDecrSat_; }

	/**
	 * XeVInvert̓T|[gĂ邩
	 * @return XeVInvertT|[gĂȂtrue
	 */
	virtual bool supportedStencilInvert() const{ return stencilInvert_; }

	/**
	 * XeVIncr̓T|[gĂ邩
	 * @return XeVIncrT|[gĂȂtrue
	 */
	virtual bool supportedStencilIncr() const{ return stencilIncr_; }

	/**
	 * XeVDecr̓T|[gĂ邩
	 * @return XeVDecrT|[gĂȂtrue
	 */
	virtual bool supportedStencilDecr() const{ return stencilDecr_; }

	/**
	 * XeVTwoSided̓T|[gĂ邩
	 * @return XeVTwoSidedT|[gĂȂtrue
	 */
	virtual bool supportedStencilTwoSided() const{ return stencilTwoSided_; }

	//--------------------------------------------------------------------------
	/**
	 * At@rNever̓T|[gĂ邩
	 * @return At@rNeverT|[gĂȂtrue
	 */
	virtual bool supportedAlphaCompareNever() const{
		return alphaCompareNever_;
	}

	/**
	 * At@rLess̓T|[gĂ邩
	 * @return At@rLessT|[gĂȂtrue
	 */
	virtual bool supportedAlphaCompareLess() const{ return alphaCompareLess_; }

	/**
	 * At@rEqual̓T|[gĂ邩
	 * @return At@rEqualT|[gĂȂtrue
	 */
	virtual bool supportedAlphaCompareEqual() const{
		return alphaCompareEqual_;
	}

	/**
	 * At@rLessEqual̓T|[gĂ邩
	 * @return At@rLessEqualT|[gĂȂtrue
	 */
	virtual bool supportedAlphaCompareLessEqual() const{
		return alphaCompareLessEqual_;
	}

	/**
	 * At@rGreater̓T|[gĂ邩
	 * @return At@rGreaterT|[gĂȂtrue
	 */
	virtual bool supportedAlphaCompareGreater() const{
		return alphaCompareGreater_;
	}

	/**
	 * At@rNotEqual̓T|[gĂ邩
	 * @return At@rNotEqualT|[gĂȂtrue
	 */
	virtual bool supportedAlphaCompareNotEqual() const{
		return alphaCompareNotEqual_;
	}

	/**
	 * At@rGreaterEqual̓T|[gĂ邩
	 * @return At@rGreaterEqualT|[gĂȂtrue
	 */
	virtual bool supportedAlphaCompareGreaterEqual() const{
		return alphaCompareGreaterEqual_;
	}

	/**
	 * At@rAlways̓T|[gĂ邩
	 * @return At@rAlwaysT|[gĂȂtrue
	 */
	virtual bool supportedAlphaCompareAlways() const{
		return alphaCompareAlways_;
	}

	//--------------------------------------------------------------------------
	// ufBO
	//--------------------------------------------------------------------------
	/**
	 * \[XZero̓T|[gĂ邩
	 * @return \[XZeroT|[gĂȂtrue
	 */
	virtual bool supportedBlendSourceZero() const{ return blendSourceZero_; }

	/**
	 * \[XOne̓T|[gĂ邩
	 * @return \[XOneT|[gĂȂtrue
	 */
	virtual bool supportedBlendSourceOne() const{ return blendSourceOne_; }

	/**
	 * \[XSrcColor̓T|[gĂ邩
	 * @return \[XSrcColorT|[gĂȂtrue
	 */
	virtual bool supportedBlendSourceSrcColor() const{
		return blendSourceSrcColor_;
	}

	/**
	 * \[XInvSrcColor̓T|[gĂ邩
	 * @return \[XInvSrcColorT|[gĂȂtrue
	 */
	virtual bool supportedBlendSourceInvSrcColor() const{
		return blendSourceInvSrcColor_;
	}

	/**
	 * \[XSrcAlpha̓T|[gĂ邩
	 * @return \[XSrcAlphaT|[gĂȂtrue
	 */
	virtual bool supportedBlendSourceSrcAlpha() const{
		return blendSourceSrcAlpha_;
	}

	/**
	 * \[XInvSrcAlpha̓T|[gĂ邩
	 * @return \[XInvSrcAlphaT|[gĂȂtrue
	 */
	virtual bool supportedBlendSourceInvSrcAlpha() const{
		return blendSourceInvSrcAlpha_;
	}

	/**
	 * \[XDestAlpha̓T|[gĂ邩
	 * @return \[XDestAlphaT|[gĂȂtrue
	 */
	virtual bool supportedBlendSourceDestAlpha() const{
		return blendSourceDestAlpha_;
	}

	/**
	 * \[XInvDestAlpha̓T|[gĂ邩
	 * @return \[XInvDestAlphaT|[gĂȂtrue
	 */
	virtual bool supportedBlendSourceInvDestAlpha() const{
		return blendSourceInvDestAlpha_;
	}

	/**
	 * \[XDestColor̓T|[gĂ邩
	 * @return \[XDestColorT|[gĂȂtrue
	 */
	virtual bool supportedBlendSourceDestColor() const{
		return blendSourceDestColor_;
	}

	/**
	 * \[XInvDestColor̓T|[gĂ邩
	 * @return \[XInvDestColorT|[gĂȂtrue
	 */
	virtual bool supportedBlendSourceInvDestColor() const{
		return blendSourceInvDestColor_;
	}

	/**
	 * \[XSrcAlphaSat̓T|[gĂ邩
	 * @return \[XSrcAlphaSatT|[gĂȂtrue
	 */
	virtual bool supportedBlendSourceSrcAlphaSat() const{
		return blendSourceSrcAlphaSat_;
	}

	/**
	 * \[XBothSrcAlpha̓T|[gĂ邩
	 * @return \[XBothSrcAlphaT|[gĂȂtrue
	 */
	virtual bool supportedBlendSourceBothSrcAlpha() const{
		return blendSourceBothSrcAlpha_;
	}

	/**
	 * \[XBothInvSrcAlpha̓T|[gĂ邩
	 * @return \[XBothInvSrcAlphaT|[gĂȂtrue
	 */
	virtual bool supportedBlendSourceBothInvSrcAlpha() const{
		return blendSourceBothInvSrcAlpha_;
	}

	/**
	 * \[XBlendFactor̓T|[gĂ邩
	 * @return \[XBlendFactorT|[gĂȂtrue
	 */
	virtual bool supportedBlendSourceBlendFactor() const{
		return blendSourceBlendFactor_;
	}

	//--------------------------------------------------------------------------
	/**
	 * fXeBl[VZero̓T|[gĂ邩
	 * @return fXeBl[VZeroT|[gĂȂtrue
	 */
	virtual bool supportedBlendDestinationZero() const{
		return blendDestinationZero_;
	}

	/**
	 * fXeBl[VOne̓T|[gĂ邩
	 * @return fXeBl[VOneT|[gĂȂtrue
	 */
	virtual bool supportedBlendDestinationOne() const{
		return blendDestinationOne_;
	}

	/**
	 * fXeBl[VSrcColor̓T|[gĂ邩
	 * @return fXeBl[VSrcColorT|[gĂȂtrue
	 */
	virtual bool supportedBlendDestinationSrcColor() const{
		return blendDestinationSrcColor_;
	}

	/**
	 * fXeBl[VInvSrcColor̓T|[gĂ邩
	 * @return fXeBl[VInvSrcColorT|[gĂȂtrue
	 */
	virtual bool supportedBlendDestinationInvSrcColor() const{
		return blendDestinationInvSrcColor_;
	}

	/**
	 * fXeBl[VSrcAlpha̓T|[gĂ邩
	 * @return fXeBl[VSrcAlphaT|[gĂȂtrue
	 */
	virtual bool supportedBlendDestinationSrcAlpha() const{
		return blendDestinationSrcAlpha_;
	}

	/**
	 * fXeBl[VInvSrcAlpha̓T|[gĂ邩
	 * @return fXeBl[VInvSrcAlphaT|[gĂȂtrue
	 */
	virtual bool supportedBlendDestinationInvSrcAlpha() const{
		return blendDestinationInvSrcAlpha_;
	}

	/**
	 * fXeBl[VDestAlpha̓T|[gĂ邩
	 * @return fXeBl[VDestAlphaT|[gĂȂtrue
	 */
	virtual bool supportedBlendDestinationDestAlpha() const{
		return blendDestinationDestAlpha_;
	}

	/**
	 * fXeBl[VInvDestAlpha̓T|[gĂ邩
	 * @return fXeBl[VInvDestAlphaT|[gĂȂtrue
	 */
	virtual bool supportedBlendDestinationInvDestAlpha() const{
		return blendDestinationInvDestAlpha_;
	}

	/**
	 * fXeBl[VDestColor̓T|[gĂ邩
	 * @return fXeBl[VDestColorT|[gĂȂtrue
	 */
	virtual bool supportedBlendDestinationDestColor() const{
		return blendDestinationDestColor_;
	}

	/**
	 * fXeBl[VInvDestColor̓T|[gĂ邩
	 * @return fXeBl[VInvDestColorT|[gĂȂtrue
	 */
	virtual bool supportedBlendDestinationInvDestColor() const{
		return blendDestinationInvDestColor_;
	}

	/**
	 * fXeBl[VSrcAlphaSat̓T|[gĂ邩
	 * @return fXeBl[VSrcAlphaSatT|[gĂȂtrue
	 */
	virtual bool supportedBlendDestinationSrcAlphaSat() const{
		return blendDestinationSrcAlphaSat_;
	}

	/**
	 * fXeBl[VBothSrcAlpha̓T|[gĂ邩
	 * @return fXeBl[VBothSrcAlphaT|[gĂȂtrue
	 */
	virtual bool supportedBlendDestinationBothSrcAlpha() const{
		return blendDestinationBothSrcAlpha_;
	}

	/**
	 * fXeBl[VBothInvSrcAlpha̓T|[gĂ邩
	 * @return fXeBl[VBothInvSrcAlphaT|[gĂȂtrue
	 */
	virtual bool supportedBlendDestinationBothInvSrcAlpha() const{
		return blendDestinationBothInvSrcAlpha_;
	}

	/**
	 * fXeBl[VBlendFactor̓T|[gĂ邩
	 * @return fXeBl[VBlendFactorT|[gĂȂtrue
	 */
	virtual bool supportedBlendDestinationBlendFactor() const{
		return blendDestinationBlendFactor_;
	}

	//--------------------------------------------------------------------------
	// X^CY
	//--------------------------------------------------------------------------
	/**
	 * A`GCAXg̎擾
	 * @return A`GCAXg
	 */
	virtual float getExtentsAdjust() const{ return extentsAdjust_; }

	/**
	 * fBU̓T|[gĂ邩
	 * @return fBUT|[gĂȂtrue
	 */
	virtual bool supportedRasterDither() const{ return rasterDither_; }

	/**
	 * ZeXg̓T|[gĂ邩
	 * @return ZeXgT|[gĂȂtrue
	 */
	virtual bool supportedRasterZTest() const{ return rasterZTest_; }

	/**
	 * _tHO̓T|[gĂ邩
	 * @return _tHOT|[gĂȂtrue
	 */
	virtual bool supportedRasterFogVertex() const{ return rasterFogVertex_; }

	/**
	 * tHOe[u̓T|[gĂ邩
	 * @return tHOe[uT|[gĂȂtrue
	 */
	virtual bool supportedRasterFogTable() const{ return rasterFogTable_; }

	/**
	 * ~bv}bvoCAX̓T|[gĂ邩
	 * @return ~bv}bvoCAXT|[gĂȂtrue
	 */
	virtual bool supportedRasterMipmapLODBias() const{
		return rasterMipmapLODBias_;
	}

	/**
	 * Bʏ̓T|[gĂ邩
	 * @return BʏT|[gĂȂtrue
	 */
	virtual bool supportedRasterZBufferLessHSR() const{
		return rasterZBufferLessHSR_;
	}

	/**
	 * WtHO̓T|[gĂ邩
	 * @return WtHOT|[gĂȂtrue
	 */
	virtual bool supportedRasterFogRange() const{ return rasterFogRange_; }

	/**
	 * ٕtB^O̓T|[gĂ邩
	 * @return ٕtB^OT|[gĂȂtrue
	 */
	virtual bool supportedRasterAnisotropy() const{ return rasterAnisotropy_; }

	/**
	 * Wobt@̓T|[gĂ邩
	 * @return Wobt@T|[gĂȂtrue
	 */
	virtual bool supportedRasterWBuffer() const{ return rasterWBuffer_; }

	/**
	 * WtHO̓T|[gĂ邩
	 * @return WtHOT|[gĂȂtrue
	 */
	virtual bool supportedRasterWFog() const{ return rasterWFog_; }

	/**
	 * ZtHO̓T|[gĂ邩
	 * @return ZtHOT|[gĂȂtrue
	 */
	virtual bool supportedRasterZFog() const{ return rasterZFog_; }

	/**
	 * Fp[XyNeBu␳̓T|[gĂ邩
	 * @return Fp[XyNeBu␳T|[gĂȂtrue
	 */
	virtual bool supportedRasterColorPerspective() const{
		return rasterColorPerspective_;
	}

	/**
	 * VU[eXg̓T|[gĂ邩
	 * @return VU[eXgT|[gĂȂtrue
	 */
	virtual bool supportedRasterScissorTest() const{
		return rasterScissorTest_;
	}

	/**
	 * X[vXP[[xoCAX̓T|[gĂ邩
	 * @return X[vXP[[xoCAXT|[gĂȂtrue
	 */
	virtual bool supportedRasterSlopeScaleDepthBias() const{
		return rasterSlopeScaleDepthBias_;
	}

	/**
	 * [xoCAX̓T|[gĂ邩
	 * @return [xoCAXT|[gĂȂtrue
	 */
	virtual bool supportedRasterDepthBias() const{ return rasterDepthBias_; }

	/**
	 * }`Tv؂ւ̓T|[gĂ邩
	 * @return }`Tv؂ւT|[gĂȂtrue
	 */
	virtual bool supportedRasterMultiSampleToggle() const{
		return rasterMultiSampleToggle_;
	}

	//--------------------------------------------------------------------------
	// _VF[_
	//--------------------------------------------------------------------------
	/**
	 * _VF[_W[o[W̎擾
	 * @return _VF[_W[o[W
	 */
	virtual u_int getVertexShaderMajorVersion() const{
		return vertexShaderMajorVersion_;
	}

	/**
	 * _VF[_}Ci[o[W̎擾
	 * @return _VF[_}Ci[o[W
	 */
	virtual u_int getVertexShaderMinorVersion() const{
		return vertexShaderMinorVersion_;
	}

	/**
	 * ő咸_VF[_萔̎擾
	 * @return ő咸_VF[_萔
	 */
	virtual u_int getMaxVertexShaderConst() const{
		return maxVertexShaderConst_;
	}

	/**
	 * őXg[XgCh̎擾
	 * @return őXg[XgCh
	 */
	virtual u_int getMaxStreamStride() const{ return maxStreamStride_; }

 	/**
	 * ő喽ߎs̎擾
	 * @return ő喽ߎs
	 */
	virtual u_int getMaxVShaderInstructionsExecuted() const{
		return maxVShaderInstructionsExecuted_;
	}

 	/**
	 * ő喽߃Xbg̎擾
	 * @return ő喽߃Xbg
	 */
	virtual u_int getMaxVertexShader30InstructionSlots() const{
		return maxVertexShader30InstructionSlots_;
	}

 	/**
	 * It[lXgx̎擾
	 * @return It[lXgx
	 */
	virtual u_int getVertexShaderDynamicFlowControlDepth() const{
		return vertexShaderDynamicFlowControlDepth_;
	}

 	/**
	 * e|̎擾
	 * @return e|
	 */
	virtual u_int getVertexShaderNumTemps() const{
		return vertexShaderNumTemps_;
	}

 	/**
	 * ÓIt[lXgx̎擾
	 * @return ÓIt[lXgx
	 */
	virtual u_int getVertexShaderStaticFlowControlDepth() const{
		return vertexShaderStaticFlowControlDepth_;
	}

	/**
	 * vfBP[V߂̓T|[gĂ邩
	 * @return vfBP[V߂T|[gĂȂtrue
	 */
	virtual bool supportedVertexShaderPredication() const{
		return vertexShaderPredication_;
	}

	//--------------------------------------------------------------------------
	// sNZVF[_
	//--------------------------------------------------------------------------
	/**
	 * sNZVF[_W[o[W̎擾
	 * @return sNZVF[_W[o[W
	 */
	virtual u_int getPixelShaderMajorVersion() const{
		return pixelShaderMajorVersion_;
	}

	/**
	 * sNZVF[_}Ci[o[W̎擾
	 * @return sNZVF[_}Ci[o[W
	 */
	virtual u_int getPixelShaderMinorVersion() const{
		return pixelShaderMinorVersion_;
	}

	/**
	 * sNZVF[_1xől̎擾
	 * @return sNZVF[_1xől
	 */
	virtual float getPixelShader1xMaxValue() const{
		return pixelShader1xMaxValue_;
	}

 	/**
	 * ő喽ߎs̎擾
	 * @return ő喽ߎs
	 */
	virtual u_int getMaxPShaderInstructionsExecuted() const{
		return maxPShaderInstructionsExecuted_;
	}

 	/**
	 * ő喽߃Xbg̎擾
	 * @return ő喽߃Xbg
	 */
	virtual u_int getMaxPixelShader30InstructionSlots() const{
		return maxPixelShader30InstructionSlots_;
	}

 	/**
	 * It[lXgx̎擾
	 * @return It[lXgx
	 */
	virtual u_int getPixelShaderDynamicFlowControlDepth() const{
		return pixelShaderDynamicFlowControlDepth_;
	}

 	/**
	 * e|̎擾
	 * @return e|
	 */
	virtual u_int getPixelShaderNumTemps() const{
		return pixelShaderNumTemps_;
	}

 	/**
	 * ÓIt[lXgx̎擾
	 * @return ÓIt[lXgx
	 */
	virtual u_int getPixelShaderStaticFlowControlDepth() const{
		return pixelShaderStaticFlowControlDepth_;
	}

 	/**
	 * ߃Xbg̎擾
	 * @return ߃Xbg
	 */
	virtual u_int getPixelShaderNumInstructionSlots() const{
		return pixelShaderNumInstructionSlots_;
	}

	/**
	 * Cӂ̓ւ̓T|[gĂ邩
	 * @return Cӂ̓ւT|[gĂȂtrue
	 */
	virtual bool supportedPixelShaderArbitrarySwizzle() const{
		return pixelShaderArbitrarySwizzle_;
	}

	/**
	 * Of[V߂̓T|[gĂ邩
	 * @return Of[V߂T|[gĂȂtrue
	 */
	virtual bool supportedPixelShaderGradientInstructions() const{
		return pixelShaderGradientInstructions_;
	}

	/**
	 * vfBP[V߂̓T|[gĂ邩
	 * @return vfBP[V߂T|[gĂȂtrue
	 */
	virtual bool supportedPixelShaderPredication() const{
		return pixelShaderPredication_;
	}

	/**
	 * ]ǂݍݖ̓T|[gĂ邩
	 * @return ]ǂݍݖT|[gĂȂtrue
	 */
	virtual bool supportedPixelShaderNoDependentReadLimit() const{
		return pixelShaderNoDependentReadLimit_;
	}

	/**
	 * texߖ̓T|[gĂ邩
	 * @return texߖT|[gĂȂtrue
	 */
	virtual bool supportedPixelShaderNoTexnstructionLimit() const{
		return pixelShaderNoTexnstructionLimit_;
	}

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 */
	GraphicsDeviceCapacity();

	/**
	 * fXgN^
	 */
	virtual ~GraphicsDeviceCapacity();

	/**
	 * foCXZbgꂽ
	 * @param direct3DDevice Direct3DfoCX
	 */
	virtual void deviceReset(Direct3DDevice* direct3DDevice);

	/**
	 * T|[g̎擾
	 * @param supported T|[gtO
	 * @return 
	 */
	virtual String supportedString(bool supported) const{
		if(supported){ return "\n"; }
		return "~\n";
	}

	//--------------------------------------------------------------------------
private:
	// Rs[RXgN^̉B
	GraphicsDeviceCapacity(const GraphicsDeviceCapacity& copy);

	// Rs[̉B
	void operator =(const GraphicsDeviceCapacity& copy);

	// foCX\
	D3DCapacity capacity_;

	// CX^X
	static GraphicsDeviceCapacity* instance_;

	//--------------------------------------------------------------------------
	// foCX
	//--------------------------------------------------------------------------
	// foCX
	String deviceName_;
	// hCo
	String driverName_;
	// foCXԍ
	int deviceOrdinal_;
	// foCX^Cv
	D3DDEVTYPE deviceType_;
	// EBhE[h
	bool isWindowed_;
	// _vZX^Cv
	VertexProcessingType vertexProcessingType_;
	// A_v^tH[}bg
	D3DFORMAT adapterFormat_;
	// obNobt@tH[}bg
	D3DFORMAT backBufferFormat_;
	// obNobt@TCY
	DimensionI backBufferSize_;
	// tbV[g
	int refreshRate_;
	// [xAXeVobt@͗L
	bool depthStencilEnabled_;
	// [xAXeVtH[}bg
	D3DFORMAT depthStencilFormat_;
	// v[e[VԊu
	u_int presentationInterval_;
	// }`Tv^Cv
	D3DMULTISAMPLE_TYPE multiSampleType_;
	// }`TvNHeB
	u_int multiSampleQuality_;

	//--------------------------------------------------------------------------
	// foCX\
	//--------------------------------------------------------------------------
	// }`_[^[Qbg
	u_int numSimultaneousRTs_;
	// VXeŎs
	bool executeSystemMemory_;
	// rfIŎs
	bool executeVideoMemory_;
	// VXeTL_
	bool tlVertexSystemMemory_;
	// rfITL_
	bool tlVertexVideoMemory_;
	// VXẽeNX`
	bool textureSystemMemory_;
	// rfĨeNX`
	bool textureVideoMemory_;
	// TL_̕`
	bool drawPrimTlVertex_;
	// tbṽ_O
	bool canRenderAfterFlip_;
	// 񃍁[JrfI
	bool textureNonLocalVidedMemory_;
	// DrawPrivitives2
	bool drawPrimitives2_;
	// ƗeNX`v[
	bool separateTextureMemories_;
	// DrawPrimitives2EX
	bool drawPrimitives2EX_;
	// n[hEFAT&L
	bool hwTransformAndLight_;
	// VXerfIւBLT
	bool canBltSystemToNonLocal_;
	// n[hEFAX^CY
	bool hwRasterization_;
	// sAfoCX
	bool pureDevice_;
	// xWFABXvC
	bool quinticRtPatches_;
	// `AOp`pb`
	bool rtPatches_;
	// Iȃnh0pb`
	bool rtPatchHanldeZero_;
	// Npb`
	bool nPatches_;
	// v[e[VԊu
	bool presentationIntervalImmediate_;
	// v[e[VԊu1
	bool presentationIntervalOne_;
	// v[e[VԊu2
	bool presentationIntervalTwo_;
	// v[e[VԊu3
	bool presentationIntervalThree_;
	// v[e[VԊu4
	bool presentationIntervalFour_;
	// n[hEFAJ[\
	bool cursorColor_;
	// 𑜓xn[hEFAJ[\
	bool cursorLowRes_;
	// StretchRectMinPointtB^
	bool stretchRectMinPoint_;
	// StretchRectMagPointtB^
	bool stretchRectMagPoint_;
	// StretchRectMinLineartB^
	bool stretchRectMinLinear_;
	// StretchRectMagLineartB^
	bool stretchRectMagLinear_;

	//--------------------------------------------------------------------------
	// foCX̑
	//--------------------------------------------------------------------------
	// }X^[A_v^ԍ
	u_int masterAdapterOrdinal_;
	// O[ṽA_v^ԍ
	u_int adapterOrdinalInGroup_;
	// O[ṽA_v^
	u_int numberOfAdaptersInGroup_;
	// Z}XN
	bool maskZ_;
	// JO
	bool cullNone_;
	// vJO
	bool cullCW_;
	// vJO
	bool cullCCW_;
	// J[`l
	bool colorWriteEnable_;
	// mȃ|CgNbv
	bool clipPlaneScaledPoints_;
	// _Nbv
	bool clipTlVerts_;
	// e|eNX`
	bool tssArgTemp_;
	// At@ufBO
	bool blendOp_;
	// kt@X
	bool nullReference_;
	// Ɨ݃}XN
	bool independentWriteMasks_;
	// eNX`Xe[W萔
	bool perStageConstant_;
	// tHOƃXyLAt@
	bool fogAndSpecularAlpha_;
	// At@puh
	bool separateAlphaBlend_;
	// MRTɈႤZ[x
	bool mrtIndependentBitDepth_;
	// MRTɃsNZVF[_㏈
	bool mrtPostPixelShaderBlending_;
	// _tHÕNv
	bool fogVertexClamped_;

	//--------------------------------------------------------------------------
	// hCo\
	//--------------------------------------------------------------------------
	// XLC̓ǂݍ
	bool readScanLine_;
	// tXN[K}
	bool fullscreenGamma_;
	// Lu[gK}
	bool canCalibrateGamma_;
	// }l[Wh\[X
	bool canManageResource_;
	// IeNX`
	bool dynamicTextures_;
	// ~bv}bv
	bool canAutogenMipmap_;
	// tXN[At@uh
	bool alphaFullscreenFlipOrDiscard_;
	// sRGBv[e[V
	bool linerToSrgbPresentation_;
	// rfIւ̃Rs[
	bool copyToVideoMemory_;
	// VXeւ̃Rs[
	bool copyToSystemMemory_;

	//--------------------------------------------------------------------------
	// v~eBu
	//--------------------------------------------------------------------------
	// ő_TCY
	float maxPointSize_;
	// CeNX`
	bool lineTexture_;
	// CZeXg
	bool lineZTest_;
	// Cuh
	bool lineBlend_;
	// CAt@r
	bool lineAlphaCompare_;
	// CtHO
	bool lineFog_;
	// CA`GCAX
	bool lineAntialias_;

	//--------------------------------------------------------------------------
	// _
	//--------------------------------------------------------------------------
	// őv~eBu
	u_int maxPrimitiveCount_;
	// őCfbNX
	u_int maxVertexIndex_;
	// őXg[
	u_int maxStreams_;
	// ő僉Cg
	u_int maxActiveLights_;
	// őWl
	float maxVertexW_;
	// őuhs
	u_int maxVertexBlendMatrices_;
	// őuhsCfbNX
	u_int maxVertexBlendMatrixIndex_;
	// K[hoh
	float guardBandLeft_;
	// K[hoh
	float guardBandTop_;
	// K[hohE
	float guardBandRight_;
	// K[hoh
	float guardBandBottom_;
	// ő僆[UNbv
	u_int maxUserCliplanes_;
	// Texgen
	bool texGen_;
	// J[}eA\[X
	bool materialSource_;
	// fBNViCg
	bool directionalLights_;
	// |WVCg
	bool positionalLights_;
	// [Jr[
	bool localViewer_;
	// _gDC[jO
	bool tweening_;
	// XtBA}bv
	bool texgenSpheremap_;
	// [Jr[OTexgens
	bool noTexgenNonLocalViewer_;

	//--------------------------------------------------------------------------
	// _tH[}bg
	//--------------------------------------------------------------------------
	// FVFeNX`WJEg}XN
	bool fvfTexCoordCountMask_;
	// FVF_ɗ]ȗvf܂߂
	bool fvfDoNotStripElements_;
	// FVF_TCY
	bool fvfPSize_;
	// u_byte4錾
	bool declUByte4_;
	// u_byte4N錾
	bool declUByte4N_;
	// short2N錾
	bool declShort2N_;
	// short4N錾
	bool declShort4N_;
	// u_short2N錾
	bool declUShort2N_;
	// u_short4N錾
	bool declUShort4N_;
	// uDec3錾
	bool declUDec3_;
	// dec3錾
	bool declDec3_;
	// float16_2錾
	bool declFloat16_2_;
	// float16_4錾
	bool declFloat16_4_;

	//--------------------------------------------------------------------------
	// ebZ[V
	//--------------------------------------------------------------------------
	// Npb`ő啪x
	float maxNPatchTesselationLevel_;
	// Xg[ItZbg
	bool streamOffset_;
	// fBXv[XgNpb`
	bool dmapNPatch_;
	// K^RTpb`
	bool adaptiveTessRTPatch_;
	// K^Npb`
	bool adaptiveTessNPatch_;
	// eNX`StretchRect
	bool canStretchRectFromTextures_;
	// vfBXv[XhNpb`
	bool preSampledDmapNPatch_;
	// Xg[ItZbgL
	bool vertexElementsCanShareStreamOffset_;

	//--------------------------------------------------------------------------
	// VF[fBO
	//--------------------------------------------------------------------------
	// J[O[
	bool shadeColorGouraudRGB_;
	// XyLO[
	bool shadeSpecularGouraudRGB_;
	// At@O[
	bool shadeAlphaGouraudBlend_;
	// tHOO[
	bool shadeFogGouraud_;

	//--------------------------------------------------------------------------
	// eNX`
	//--------------------------------------------------------------------------
	// őeNX`TCY
	DimensionI maxTextureSize_;
	// ő{[eNX`
	u_int maxVolumeExtent_;
	// őeNX`s[g
	u_int maxTextureRepeat_;
	// őٕtB^l
	u_int maxAnisotropy_;
	// őeNX`AXyNg
	u_int maxTextureAspectRaito_;
	// p[XyNeBu␳
	bool texturePerspective_;
	// ӂ2̗ݏ̂
	bool texturePow2_;
	// At@
	bool textureAlpha_;
	// `̂
	bool textureSquareOnly_;
	// s[gXP[
	bool textureRepeatNotScaledBySize_;
	// At@pbg
	bool textureAlphaPalette_;
	// ӂ2̗ݏŖĂ悢
	bool textureNonPow2Conditional_;
	// ˉe
	bool textureProjected_;
	// L[u}bv
	bool textureCubemap_;
	// {[}bv
	bool textureVolumemap_;
	// ~bv}bv
	bool textureMipmap_;
	// L[u~bv}bv
	bool textureMipmapCubemap_;
	// {[~bv}bv
	bool textureMipmapVolumemap_;
	// L[u}bvӂ2̗ݏ̂
	bool textureCubemapPow2_;
	// {[}bvӂ2̗ݏ̂
	bool textureVolumemapPow2_;
	// ˉeov}bv
	bool textureNoProjectedBumpEnvironment_;

	//--------------------------------------------------------------------------
	// eNX`AhX
	//--------------------------------------------------------------------------
	// bv
	bool textureAddressWrap_;
	// ~[
	bool textureAddressMirror_;
	// UṼNv
	bool textureAddressClamp_;
	// EF̐ݒ
	bool textureAddressBorder_;
	// ƗUV[h
	bool textureAddressIndependentUV_;
	// 1~[
	bool textureAddressMirrorOnce_;

	// {[bv
	bool volumeTextureAddressWrap_;
	// {[~[
	bool volumeTextureAddressMirror_;
	// {[UṼNv
	bool volumeTextureAddressClamp_;
	// {[EF̐ݒ
	bool volumeTextureAddressBorder_;
	// {[ƗUV[h
	bool volumeTextureAddressIndependentUV_;
	// {[1~[
	bool volumeTextureAddressMirrorOnce_;

	//--------------------------------------------------------------------------
	// eNX`tB^
	//--------------------------------------------------------------------------
	// k|Cg
	bool textureFilterMinPoint_;
	// k`
	bool textureFilterMinLiner_;
	// kٕ
	bool textureFilterMinAnisotropic_;
	// ks~bh
	bool textureFilterMinPyramidalQuad_;
	// k2KEX
	bool textureFilterMinGaussianQuad_;
	// g|Cg
	bool textureFilterMagPoint_;
	// g`
	bool textureFilterMagLiner_;
	// gٕ
	bool textureFilterMagAnisotropic_;
	// gs~bh
	bool textureFilterMagPyramidalQuad_;
	// g2KEX
	bool textureFilterMagGaussianQuad_;
	// ~bv}bv|Cg
	bool textureFilterMipmapPoint_;
	// ~bv}bv`
	bool textureFilterMipmapLiner_;

	// L[uk|Cg
	bool cubeTextureFilterMinPoint_;
	// L[uk`
	bool cubeTextureFilterMinLiner_;
	// L[ukٕ
	bool cubeTextureFilterMinAnisotropic_;
	// L[uks~bh
	bool cubeTextureFilterMinPyramidalQuad_;
	// L[uk2KEX
	bool cubeTextureFilterMinGaussianQuad_;
	// L[ug|Cg
	bool cubeTextureFilterMagPoint_;
	// L[ug`
	bool cubeTextureFilterMagLiner_;
	// L[ugٕ
	bool cubeTextureFilterMagAnisotropic_;
	// L[ugs~bh
	bool cubeTextureFilterMagPyramidalQuad_;
	// L[ug2KEX
	bool cubeTextureFilterMagGaussianQuad_;
	// L[u~bv}bv|Cg
	bool cubeTextureFilterMipmapPoint_;
	// L[u~bv}bv`
	bool cubeTextureFilterMipmapLiner_;

	// {[k|Cg
	bool volumeTextureFilterMinPoint_;
	// {[k`
	bool volumeTextureFilterMinLiner_;
	// {[kٕ
	bool volumeTextureFilterMinAnisotropic_;
	// {[ks~bh
	bool volumeTextureFilterMinPyramidalQuad_;
	// {[k2KEX
	bool volumeTextureFilterMinGaussianQuad_;
	// {[g|Cg
	bool volumeTextureFilterMagPoint_;
	// {[g`
	bool volumeTextureFilterMagLiner_;
	// {[gٕ
	bool volumeTextureFilterMagAnisotropic_;
	// {[gs~bh
	bool volumeTextureFilterMagPyramidalQuad_;
	// {[g2KEX
	bool volumeTextureFilterMagGaussianQuad_;
	// {[~bv}bv|Cg
	bool volumeTextureFilterMipmapPoint_;
	// {[~bv}bv`
	bool volumeTextureFilterMipmapLiner_;

	// _k|Cg
	bool vertexTextureFilterMinPoint_;
	// _k`
	bool vertexTextureFilterMinLiner_;
	// _kٕ
	bool vertexTextureFilterMinAnisotropic_;
	// _ks~bh
	bool vertexTextureFilterMinPyramidalQuad_;
	// _k2KEX
	bool vertexTextureFilterMinGaussianQuad_;
	// _g|Cg
	bool vertexTextureFilterMagPoint_;
	// _g`
	bool vertexTextureFilterMagLiner_;
	// _gٕ
	bool vertexTextureFilterMagAnisotropic_;
	// _gs~bh
	bool vertexTextureFilterMagPyramidalQuad_;
	// _g2KEX
	bool vertexTextureFilterMagGaussianQuad_;
	// _~bv}bv|Cg
	bool vertexTextureFilterMipmapPoint_;
	// _~bv}bv`
	bool vertexTextureFilterMipmapLiner_;

	//--------------------------------------------------------------------------
	// eNX`Xe[W
	//--------------------------------------------------------------------------
	// őeNX`Xe[W
	u_int maxTextureBlendStages_;
	// ő}`eNX`
	u_int maxSimultaneousTextures_;
	// DisableIy[V
	bool textureOperationDisable_;
	// SelectArg1Iy[V
	bool textureOperationSelectArg1_;
	// SelectArg2Iy[V
	bool textureOperationSelectArg2_;
	// ModulateIy[V
	bool textureOperationModulate_;
	// Modulate2xIy[V
	bool textureOperationModulate2x_;
	// Modulate4xIy[V
	bool textureOperationModulate4x_;
	// AddIy[V
	bool textureOperationAdd_;
	// AddSignedIy[V
	bool textureOperationAddSigned_;
	// AddSigned2xIy[V
	bool textureOperationAddSigned2x_;
	// SubtractIy[V
	bool textureOperationSubtract_;
	// AddSmoothIy[V
	bool textureOperationAddSmooth_;
	// BlendDiffuseAlphaIy[V
	bool textureOperationBlendDiffuseAlpha_;
	// BlendTextureAlphaIy[V
	bool textureOperationBlendTextureAlpha_;
	// BlendFactorAlphaIy[V
	bool textureOperationBlendFactorAlpha_;
	// BlendTextureAlphaPMIy[V
	bool textureOperationBlendTextureAlphaPM_;
	// BlendCurrentAlphaIy[V
	bool textureOperationBlendCurrentAlpha_;
	// PreModulateIy[V
	bool textureOperationPreModulate_;
	// ModulateAlphaAddColorIy[V
	bool textureOperationModulateAlphaAddColor_;
	// ModulateColorAddAlphaIy[V
	bool textureOperationModulateColorAddAlpha_;
	// ModulateInvAlphaAddColorIy[V
	bool textureOperationModulateInvAlphaAddColor_;
	// ModulateInvColorAddAlphaIy[V
	bool textureOperationModulateInvColorAddAlpha_;
	// BumpEnvMapIy[V
	bool textureOperationBumpEnvMap_;
	// BumpEnvMapLuminanceIy[V
	bool textureOperationBumpEnvMapLuminance_;
	// DotProduct3Iy[V
	bool textureOperationDotProduct3_;
	// MultiplyAddIy[V
	bool textureOperationMultiplyAdd_;
	// LerpIy[V
	bool textureOperationLerp_;

	//--------------------------------------------------------------------------
	// r
	//--------------------------------------------------------------------------
	// ZrNever
	bool zCompareNever_;
	// ZrLess
	bool zCompareLess_;
	// ZrEqual
	bool zCompareEqual_;
	// ZrLessEqual
	bool zCompareLessEqual_;
	// ZrGreater
	bool zCompareGreater_;
	// ZrNotEqual
	bool zCompareNotEqual_;
	// ZrGreaterEqual
	bool zCompareGreaterEqual_;
	// ZrAlways
	bool zCompareAlways_;

	// XeVKeep
	bool stencilKeep_;
	// XeVZero
	bool stencilZero_;
	// XeVReplace
	bool stencilReplace_;
	// XeVIncrSat
	bool stencilIncrSat_;
	// XeVDecrSat
	bool stencilDecrSat_;
	// XeVInvert
	bool stencilInvert_;
	// XeVIncr
	bool stencilIncr_;
	// XeVDecr
	bool stencilDecr_;
	// XeVTwoSided
	bool stencilTwoSided_;

	// At@rNever
	bool alphaCompareNever_;
	// At@rLess
	bool alphaCompareLess_;
	// At@rEqual
	bool alphaCompareEqual_;
	// At@rLessEqual
	bool alphaCompareLessEqual_;
	// At@rGreater
	bool alphaCompareGreater_;
	// At@rNotEqual
	bool alphaCompareNotEqual_;
	// At@rGreaterEqual
	bool alphaCompareGreaterEqual_;
	// At@rAlways
	bool alphaCompareAlways_;

	//--------------------------------------------------------------------------
	// ufBO
	//--------------------------------------------------------------------------
	// \[XZero
	bool blendSourceZero_;
	// \[XOne
	bool blendSourceOne_;
	// \[XSrcColor
	bool blendSourceSrcColor_;
	// \[XInvSrcColor
	bool blendSourceInvSrcColor_;
	// \[XSrcAlpha
	bool blendSourceSrcAlpha_;
	// \[XInvSrcAlpha
	bool blendSourceInvSrcAlpha_;
	// \[XDestAlpha
	bool blendSourceDestAlpha_;
	// \[XInvDestAlpha
	bool blendSourceInvDestAlpha_;
	// \[XDestColor
	bool blendSourceDestColor_;
	// \[XInvDestColor
	bool blendSourceInvDestColor_;
	// \[XSrcAlphaSat
	bool blendSourceSrcAlphaSat_;
	// \[XBothSrcAlpha
	bool blendSourceBothSrcAlpha_;
	// \[XBothInvSrcAlpha
	bool blendSourceBothInvSrcAlpha_;
	// \[XBlendFactor
	bool blendSourceBlendFactor_;

	// fXeBl[VZero
	bool blendDestinationZero_;
	// fXeBl[VOne
	bool blendDestinationOne_;
	// fXeBl[VSrcColor
	bool blendDestinationSrcColor_;
	// fXeBl[VInvSrcColor
	bool blendDestinationInvSrcColor_;
	// fXeBl[VSrcAlpha
	bool blendDestinationSrcAlpha_;
	// fXeBl[VInvSrcAlpha
	bool blendDestinationInvSrcAlpha_;
	// fXeBl[VDestAlpha
	bool blendDestinationDestAlpha_;
	// fXeBl[VInvDestAlpha
	bool blendDestinationInvDestAlpha_;
	// fXeBl[VDestColor
	bool blendDestinationDestColor_;
	// fXeBl[VInvDestColor
	bool blendDestinationInvDestColor_;
	// fXeBl[VSrcAlphaSat
	bool blendDestinationSrcAlphaSat_;
	// fXeBl[VBothSrcAlpha
	bool blendDestinationBothSrcAlpha_;
	// fXeBl[VBothInvSrcAlpha
	bool blendDestinationBothInvSrcAlpha_;
	// fXeBl[VBlendFactor
	bool blendDestinationBlendFactor_;

	//--------------------------------------------------------------------------
	// X^CY
	//--------------------------------------------------------------------------
	// A`GCAXg
	float extentsAdjust_;
	// fBU
	bool rasterDither_;
	// ZeXg
	bool rasterZTest_;
	// _tHO
	bool rasterFogVertex_;
	// tHOe[u
	bool rasterFogTable_;
	// ~bv}bvoCAX
	bool rasterMipmapLODBias_;
	// Bʏ
	bool rasterZBufferLessHSR_;
	// WtHO
	bool rasterFogRange_;
	// ٕtB^O
	bool rasterAnisotropy_;
	// Wobt@
	bool rasterWBuffer_;
	// WtHO
	bool rasterWFog_;
	// ZtHO
	bool rasterZFog_;
	// Fp[XyNeBu␳
	bool rasterColorPerspective_;
	// VU[eXg
	bool rasterScissorTest_;
	// X[vXP[[xoCAX
	bool rasterSlopeScaleDepthBias_;
	// [xoCAX
	bool rasterDepthBias_;
	// }`Tv؂ւ
	bool rasterMultiSampleToggle_;

	//--------------------------------------------------------------------------
	// _VF[_
	//--------------------------------------------------------------------------
	// _VF[_W[o[W
	u_int vertexShaderMajorVersion_;
	// _VF[_}Ci[o[W
	u_int vertexShaderMinorVersion_;
	// ő咸_VF[_萔
	u_int maxVertexShaderConst_;
	// őXg[XgCh
	u_int maxStreamStride_;
	// ő喽ߎs
	u_int maxVShaderInstructionsExecuted_;
	// ő喽߃Xbg
	u_int maxVertexShader30InstructionSlots_;
	// It[lXgx
	int vertexShaderDynamicFlowControlDepth_;
	// e|
	int vertexShaderNumTemps_;
	// ÓIt[lXgx
	int vertexShaderStaticFlowControlDepth_;
	// vfBP[V
	bool vertexShaderPredication_;

	//--------------------------------------------------------------------------
	// sNZVF[_
	//--------------------------------------------------------------------------
	// sNZVF[_W[o[W
	u_int pixelShaderMajorVersion_;
	// sNZVF[_}Ci[o[W
	u_int pixelShaderMinorVersion_;
	// sNZVF[_1xől
	float pixelShader1xMaxValue_;
	// ő喽ߎs
	u_int maxPShaderInstructionsExecuted_;
	// ő喽߃Xbg
	u_int maxPixelShader30InstructionSlots_;
	// It[lXgx
	int pixelShaderDynamicFlowControlDepth_;
	// e|
	int pixelShaderNumTemps_;
	// ÓIt[lXgx
	int pixelShaderStaticFlowControlDepth_;
	// ߃Xbg
	int pixelShaderNumInstructionSlots_;
	// Cӂ̓ւ
	bool pixelShaderArbitrarySwizzle_;
	// Of[V
	bool pixelShaderGradientInstructions_;
	// vfBP[V
	bool pixelShaderPredication_;
	// ]ǂݍݖ
	bool pixelShaderNoDependentReadLimit_;
	// texߖ
	bool pixelShaderNoTexnstructionLimit_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of GRAPHICS_DEVICE_CAPACITY_H_
//------------------------------------------------------------------------------

